/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.value.IValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public abstract class AnalysisResultInterval<T>
extends AnalysisResult {
    private Session session;
    protected Map<ITimelineInterval, T> intervals;
    private Set<Timeline> timelines;

    public AnalysisResultInterval(Session session, AnalysisDescriptor desc) {
        super(desc);
        this.session = session;
        this.intervals = new HashMap<ITimelineInterval, T>();
        this.timelines = new HashSet<Timeline>();
    }

    public int getIntervalCount() {
        return this.intervals.size();
    }

    public T getData(ITimelineInterval interval) {
        return this.intervals.get(interval);
    }

    public abstract IValue getValue(ITimelineInterval var1);

    public abstract String getValueDescription(ITimelineInterval var1);

    public boolean containsInterval(ITimelineInterval interval) {
        return this.intervals.keySet().contains(interval);
    }

    public void addInterval(ITimelineInterval interval, T data) {
        this.intervals.put(interval, data);
        Timeline timeline = interval.getPrimaryTimeline();
        if (timeline != null) {
            this.timelines.add(timeline);
        }
    }

    @Override
    public boolean isValid() {
        for (Timeline timeline : this.timelines) {
            if (!timeline.isVisible() || timeline.isFiltered()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Action getMoreAction() {
        return new MoreAction();
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(this.intervals.size());
        for (ITimelineInterval interval : this.intervals.keySet()) {
            TimelineIntervalPair pair = new TimelineIntervalPair(interval.getPrimaryTimeline(), interval);
            pairs.add(pair);
        }
        return pairs;
    }

    private class MoreAction
    extends Action {
        private MoreAction() {
        }

        public void run() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp();
        }
    }
}

