/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class CuptiActivitySourceLocator
extends CuptiActivityBase
implements ICuptiActivity {
    public int kind;
    public int id;
    public int lineNumber;
    public String fileName;

    public CuptiActivitySourceLocator() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    public CuptiActivitySourceLocator(int id, int lineNumber, String fileName) {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR.getCode();
        this.id = id;
        this.lineNumber = lineNumber;
        this.fileName = fileName;
    }

    @Override
    public CuptiActivityKind getKind() {
        return CuptiActivityKind.valueOf(this.kind);
    }

    @Override
    public int getKindCode() {
        return this.kind;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    public URI getFileUri() {
        try {
            return new URI(this.fileName);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(this.fileName).toURI();
        }
    }
}

