/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.NewSessionAction;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ImportCsvWizard;
import com.nvidia.viper.ui.ImportNvprofWizard;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenSessionAction
extends Action {
    private IWorkbenchWindow window;

    public OpenSessionAction(IWorkbenchWindow window) {
        super(ViperMessages.OpenSession_Label, null);
        this.window = window;
        this.setToolTipText(ViperMessages.OpenSession_Tooltip);
        this.setId("com.nvidia.viper.sessionopen");
        this.setActionDefinitionId("com.nvidia.viper.command.opensession");
    }

    public void run() {
        String filename = LocalFileSystem.browseForFileOpen(this.window.getShell(), "Open Session", null, "OpenDialogPath");
        if (filename != null) {
            OpenSessionAction.handleOpenFile(this.window, filename);
            Viper.closeWelcomePage(this.window);
        }
    }

    public static FileTypes handleOpenFile(final IWorkbenchWindow window, String filename) {
        FileTypes type = OpenSessionAction.handleOpenImport(window, filename);
        if (type.equals((Object)FileTypes.UNSUPPORTED)) {
            try {
                final Executable executable = new Executable();
                executable.setFilename(filename);
                if (executable.isRunnable()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            NewSessionAction.createNewSession(executable, window, false);
                        }
                    });
                    return FileTypes.EXECUTABLE;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ViperMessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.Open_Fail_Title, ViperMessages.Open_Fail_Message);
                    }
                });
            }
            catch (ConnectionNotFoundException e) {
                ViperExceptionHandler.handle(ViperMessages.Open_Fail_Title, ViperMessages.Open_Fail_Message, new ViperException(e));
            }
        }
        return type;
    }

    private static FileTypes handleOpenImport(IWorkbenchWindow window, String filename) {
        final RunnableWithProgress progress = new RunnableWithProgress(window, filename);
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    dialog.run(true, true, (IRunnableWithProgress)progress);
                }
                catch (InvocationTargetException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
                catch (InterruptedException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
            }
        });
        return progress.getFileType();
    }

    public static enum FileTypes {
        CSV,
        NVPROF,
        EXECUTABLE,
        SESSION,
        UNSUPPORTED;

    }

    static class RunnableWithProgress
    implements IRunnableWithProgress {
        private IWorkbenchWindow window;
        private String filename;
        private FileTypes fileType = FileTypes.UNSUPPORTED;

        public RunnableWithProgress(IWorkbenchWindow window, String filename) {
            this.window = window;
            this.filename = filename;
        }

        public FileTypes getFileType() {
            return this.fileType;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Open file...", -1);
            monitor.subTask("Open file " + this.filename);
            Thread thread = new Thread("LoadPdm"){

                @Override
                public void run() {
                    block2: {
                        try {
                            RunnableWithProgress.this.performOpen();
                        }
                        catch (Exception e) {
                            if (!(e instanceof ViperException)) break block2;
                            ViperException ex = (ViperException)e;
                            ex.getMessage().endsWith("LoadPdmCancel");
                        }
                    }
                }
            };
            thread.start();
            while (thread != null && thread.isAlive()) {
                if (!monitor.isCanceled()) continue;
                thread.interrupt();
            }
        }

        private void performOpen() {
            try {
                File file = new File(this.filename);
                try {
                    if (ImportCsvWizard.isCSV(file)) {
                        Session session = new Session();
                        new ImportCsvWizard.ImportCSVRunnableWithProgress(session, file.getName(), new String[]{this.filename}).run((IProgressMonitor)new NullProgressMonitor());
                        this.fileType = FileTypes.CSV;
                        return;
                    }
                }
                catch (Exception exception) {}
                try {
                    ImportNvprofWizard.importNvprofTimelineFileThrowsException(this.filename);
                    this.fileType = FileTypes.NVPROF;
                    return;
                }
                catch (ViperException e) {
                    if (e.getMessage().endsWith("LoadPdmCancel")) {
                        this.fileType = FileTypes.NVPROF;
                        return;
                    }
                    try {
                        final Session session = FileUtils.loadSession(file);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPage activePage = RunnableWithProgress.this.window.getActivePage();
                                try {
                                    SessionEditor editor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(session), "com.nvidia.viper.sessioneditor");
                                    editor.scaleToFit();
                                    editor.setDirty(false);
                                    session.setDirty(false);
                                }
                                catch (PartInitException e) {
                                    ViperExceptionHandler.handle(ViperMessages.Open_Fail_Title, "Unable to open file " + RunnableWithProgress.this.filename, new ViperException(e));
                                }
                            }
                        });
                        this.fileType = FileTypes.SESSION;
                        return;
                    }
                    catch (Exception e2) {
                        if (e2.getMessage().endsWith("LoadPdmCancel")) {
                            this.fileType = FileTypes.SESSION;
                            return;
                        }
                    }
                }
            }
            catch (CoreException e) {
                ViperExceptionHandler.handle(ViperMessages.Open_Fail_Title, ViperMessages.Open_Fail_Message, new ViperException(e));
            }
            this.fileType = FileTypes.UNSUPPORTED;
        }
    }
}

