/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.model.ExpertData;
import org.eclipse.jface.action.Action;

public class ExpertDataModeAction
extends Action {
    public static final String MODE = "expertdata:mode";
    private ExpertData.Mode mode;

    public ExpertDataModeAction(ExpertData.Mode mode) {
        super(ViperMessages.ExpertDataModeInterval_Label, 2);
        this.setImageDescriptor(ViperImages.DESC_TOGGLEDATAMODE);
        this.setId("com.nvidia.viper.toggledatamode");
        this.setMode(mode);
    }

    public void setMode(ExpertData.Mode mode) {
        if (this.mode == null || !this.mode.equals((Object)mode)) {
            switch (mode) {
                case INTERVAL: {
                    this.setChecked(false);
                    this.setText(ViperMessages.ExpertDataModeAggregate_Label);
                    this.setToolTipText(ViperMessages.ExpertDataModeAggregate_Tooltip);
                    break;
                }
                default: {
                    this.setChecked(true);
                    this.setText(ViperMessages.ExpertDataModeInterval_Label);
                    this.setToolTipText(ViperMessages.ExpertDataModeInterval_Tooltip);
                }
            }
            ExpertData.Mode oldMode = this.mode;
            this.mode = mode;
            this.firePropertyChange(MODE, (Object)oldMode, (Object)this.mode);
        }
    }

    public void run() {
        ExpertData.Mode newMode;
        switch (this.mode) {
            case INTERVAL: {
                newMode = ExpertData.Mode.KERNEL_AGGREGATE;
                break;
            }
            default: {
                newMode = ExpertData.Mode.INTERVAL;
            }
        }
        this.setMode(newMode);
    }
}

