/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.Activator;
import com.nvidia.viper.FileUtils;
import com.nvidia.viper.IViperWorkbench;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.editor.ISourceMappingRule;
import com.nvidia.viper.editor.RulesConfiguration;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.PathMappingWizard;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.ViperTabbedPropertySheetPage;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public final class ViperStandaloneWorkbench
implements IViperWorkbench {
    @Override
    public void closeEditorInput(IEditorInput editorInput) {
        if (editorInput != null && editorInput instanceof SessionEditorInput) {
            ((SessionEditorInput)editorInput).closeSession();
        }
    }

    @Override
    public Composite configureEditorSite(Composite parent, IEditorPart part) {
        return parent;
    }

    private Map<URI, Collection<Object>> convertToUri2Object(Map<Object, URI> locations) {
        HashMap<URI, Collection<Object>> map = new HashMap<URI, Collection<Object>>();
        for (Map.Entry<Object, URI> entry : locations.entrySet()) {
            URI uri = entry.getValue();
            Collection<Object> list = map.get(uri);
            if (list == null) {
                list = new LinkedList<Object>();
                map.put(uri, list);
            }
            list.add(entry.getKey());
        }
        return map;
    }

    @Override
    public IPropertySheetPage createPropertySheetPage(SessionEditor sessionEditor) {
        return new ViperTabbedPropertySheetPage(sessionEditor);
    }

    @Override
    public String getConsoleViewID() {
        return "com.nvidia.viper.consoleview";
    }

    @Override
    public String getPropertiesViewId() {
        return "com.nvidia.viper.timelinepropertyview";
    }

    private RulesConfiguration getRulesConfiguration(Executable executable) {
        return RulesConfiguration.read(executable, Activator.getDefault().getStateLocation().append("pathMappings.xml").toFile());
    }

    @Override
    public String getRunMenuId() {
        return "com.nvidia.viper.runmenu";
    }

    @Override
    public Session getSession(IEditorInput input) throws PartInitException {
        if (input instanceof SessionEditorInput) {
            return ((SessionEditorInput)input).getSession();
        }
        throw new PartInitException(String.format("Invalid Input: %s - must be an instance of SessionEditorInput", input.getClass()));
    }

    protected void lookupMultipleFilesInDisplayThread(RulesConfiguration configuration, Collection<URI> resolved) {
        PathMappingWizard wizard = new PathMappingWizard(configuration, resolved);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
    }

    protected URI lookupSingleFileInDisplayThread(URI uri) {
        String open;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Path path = new Path(uri.getPath());
        if (path.toFile().exists()) {
            String prefPath = null;
            prefPath = path.toFile().isDirectory() ? path.toOSString() : path.toFile().getParent().toString();
            Activator.getDefault().getPreferenceStore().setValue("PathMappingWizardPath", prefPath);
        }
        if ((open = LocalFileSystem.browseForFileOpen(window.getShell(), String.format("Select location of the %s on the local filesystem", path.toOSString()), path.lastSegment(), "PathMappingWizardPath")) != null) {
            return new File(open).toURI();
        }
        return null;
    }

    private void manualResolve(final RulesConfiguration configuration, final Collection<URI> resolved) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ViperStandaloneWorkbench.this.lookupMultipleFilesInDisplayThread(configuration, resolved);
            }
        });
    }

    private void manualResolveSingle(RulesConfiguration configuration, final URI uri) {
        final AtomicReference result = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.set(ViperStandaloneWorkbench.this.lookupSingleFileInDisplayThread(uri));
            }
        });
        URI ret = (URI)result.get();
        if (ret != null) {
            configuration.addMapping(uri.getPath(), ret);
            configuration.save();
        }
    }

    @Override
    public boolean requiresPathMappingWizard() {
        return true;
    }

    @Override
    public void updatePathsInSession(Session session, Collection<URI> locations, boolean forceMulti) {
        RulesConfiguration configuration = this.getRulesConfiguration(session.getExecutable());
        if (forceMulti || locations.size() > 1) {
            this.manualResolve(configuration, locations);
        } else {
            this.manualResolveSingle(configuration, locations.iterator().next());
        }
    }

    @Override
    public Executable resolveExecutableSettings(Executable executable) {
        return null;
    }

    @Override
    public void resolvePathsInSession(Session session, Map<Object, URI> locations) {
        RulesConfiguration configuration = this.getRulesConfiguration(session.getExecutable());
        Map<URI, Collection<Object>> toResolve = this.convertToUri2Object(locations);
        AtomicReference<URI> singleUnresolved = new AtomicReference<URI>();
        HashMap<URI, ISourceMappingRule.SourceMapping> resolved = new HashMap<URI, ISourceMappingRule.SourceMapping>();
        this.doResolve(configuration, toResolve.keySet(), singleUnresolved, resolved);
        Set<Map.Entry<URI, Collection<Object>>> entries = toResolve.entrySet();
        for (Map.Entry<URI, Collection<Object>> entry : entries) {
            ISourceMappingRule.SourceMapping mapping = (ISourceMappingRule.SourceMapping)resolved.get(entry.getKey());
            Collection<Object> value = entry.getValue();
            for (Object object : value) {
                locations.put(object, mapping == null ? null : mapping.uri);
            }
        }
    }

    private int doResolve(RulesConfiguration configuration, Collection<URI> toResolve, AtomicReference<URI> singleUnresolved, Map<URI, ISourceMappingRule.SourceMapping> resolved) {
        int unresolved = 0;
        for (URI uri : toResolve) {
            ISourceMappingRule.SourceMapping newUri = configuration.map(uri);
            if (newUri == null) {
                ++unresolved;
                singleUnresolved.set(uri);
            }
            resolved.put(uri, newUri);
        }
        return unresolved;
    }

    @Override
    public void save(Shell shell, Session session, IEditorInput input) throws ViperException {
        if (session.getFile() == null) {
            this.saveAs(shell, session, input);
        } else {
            this.saveSession((File)session.getFile(), session);
        }
    }

    @Override
    public IEditorInput saveAs(Shell shell, Session session, IEditorInput input) throws ViperException {
        String filename = LocalFileSystem.browseForFileSave(shell, "Save " + session.getName(), session.getName(), "SaveDialogPath");
        if (filename != null) {
            File file = new File(filename);
            String oldName = session.getName();
            File oldFile = (File)session.getFile();
            session.setFile(file);
            session.setName(file.getName());
            if (!this.saveSession(file, session)) {
                session.setFile(oldFile);
                session.setName(oldName);
                return input;
            }
        }
        return null;
    }

    protected boolean saveSession(File file, Session session) throws ViperException {
        FileUtils.saveSession(file, session);
        session.setDirty(false);
        session.setReadOnly(false);
        return true;
    }

    @Override
    public boolean useGlobalToolbar() {
        return true;
    }

    @Override
    public boolean readyToRun(Session session) {
        return true;
    }

    @Override
    public void informUnableToLoadLibraries(Exception e) {
        ViperExceptionHandler.handle(ViperMessages.LibVp_Fail_Title, ViperMessages.LibVp_Fail_Message, e);
        Viper.exit(1);
    }

    @Override
    public boolean needProfilingDataDelete(Session session) {
        return false;
    }
}

