/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ViperColors {
    public static final Color SCALE_DRAG_BGCOLOR = ColorConstants.gray;
    public static final Color TIMELINE_BGCOLOR_0 = new Color(null, 250, 250, 250);
    public static final Color TIMELINE_BGCOLOR_1 = new Color(null, 232, 232, 232);
    public static final Color TIMELINE_DEFAULT_BGCOLOR = ColorConstants.white;
    public static final Color TIMELINE_SELECTED_COLOR = new Color(null, 63, 133, 24);
    public static final Color TIMELINE_SELECTED_FONT_COLOR = ColorConstants.white;
    public static final Color INTERVAL_TEXT_FGCOLOR = ColorConstants.white;
    public static final Color INTERVAL_HILITE_TEXT_FGCOLOR = ColorConstants.black;
    public static final Color INTERVAL_SELECTED_COLOR = ColorConstants.black;
    public static final GradientColors INTERVAL_HILITE_COLORS = new GradientColors(new Color(null, 236, 240, 45), new Color(null, 229, 232, 100));
    public static final GradientColors INTERVAL_DISABLE_COLORS = new GradientColors(ColorConstants.gray, ColorConstants.darkGray);
    public static final int INTERVAL_DISABLE_ALPHA = 50;
    public static final GradientColors INTERVAL_UNKNOWN_COLORS = new GradientColors(ColorConstants.red);
    public static final GradientColors INTERVAL_MEMCPY_HTOD_COLORS;
    public static final GradientColors INTERVAL_MEMCPY_DTOH_COLORS;
    public static final GradientColors INTERVAL_MEMCPY_DTOD_COLORS;
    public static final GradientColors INTERVAL_MEMCPY_PTOP_COLORS;
    public static final GradientColors INTERVAL_MEMSET_COLORS;
    public static final GradientColors INTERVAL_KERNEL_COLORS;
    public static final GradientColors INTERVAL_RUNTIME_COLORS;
    public static final GradientColors INTERVAL_DRIVER_COLORS;
    public static final GradientColors INTERVAL_OVERHEAD_COLORS;
    public static final GradientColors INTERVAL_MARKER_COLORS;
    public static final GradientColors INTERVAL_ENVIRONMENT_SPEED_COLORS;
    public static final GradientColors INTERVAL_ENVIRONMENT_TEMP_COLORS;
    public static final GradientColors INTERVAL_ENVIRONMENT_POWER_COLORS;
    public static final GradientColors INTERVAL_ENVIRONMENT_COOLING_COLORS;
    public static final GradientColors INTERVAL_UVM_MEMCPY_HTOD_COLORS;
    public static final GradientColors INTERVAL_UVM_MEMCPY_DTOH_COLORS;
    public static final GradientColors INTERVAL_UVM_PAGE_FAULT_COLORS;
    public static final GradientColors INTERVAL_GPU_UTILIZATION;
    public static final Color REGIONOFINTEREST_SELECTED_BGCOLOR;
    public static final Color REGIONOFINTEREST_SELECTED_FGCOLOR;
    public static final int REGIONOFINTEREST_SELECTED_ALPHA = 255;
    public static final Color REGIONOFINTEREST_BGCOLOR;
    public static final Color REGIONOFINTEREST_FGCOLOR;
    public static final int REGIONOFINTEREST_ALPHA = 100;
    public static final ColorTheme INTERVAL_KERNEL_COLORTHEME;
    public static final Color COLOR_INACTIVE_THREADS;
    public static final Color COLOR_PRED_OFF_THREADS;
    public static final Color COLOR_GRAPH_BORDER;
    public static final Color COLOR_EXEC_COUNT_BACKGROUND;
    public static final Color COLOR_HOTSPOT_HIGH;
    public static final Color COLOR_HOTSPOT_MED;
    public static final Color COLOR_OPERAND_PREDICATE;
    public static final Color COLOR_LABEL;
    public static final Color COLOR_OPERAND_REGISTER;
    private static Map<Integer, GradientColors> markerColors;

    static {
        INTERVAL_MEMCPY_DTOH_COLORS = INTERVAL_MEMCPY_HTOD_COLORS = new GradientColors(new Color(null, 196, 164, 71), new Color(null, 130, 107, 39));
        INTERVAL_MEMCPY_DTOD_COLORS = INTERVAL_MEMCPY_HTOD_COLORS;
        INTERVAL_MEMCPY_PTOP_COLORS = INTERVAL_MEMCPY_HTOD_COLORS;
        INTERVAL_MEMSET_COLORS = INTERVAL_MEMCPY_HTOD_COLORS;
        INTERVAL_KERNEL_COLORS = new GradientColors(ColorConstants.green, ColorConstants.darkGreen);
        INTERVAL_RUNTIME_COLORS = new GradientColors(new Color(null, 224, 125, 32), new Color(null, 168, 107, 49));
        INTERVAL_DRIVER_COLORS = new GradientColors(new Color(null, 167, 78, 15), new Color(null, 109, 53, 15));
        INTERVAL_OVERHEAD_COLORS = new GradientColors(ColorConstants.red, new Color(null, 215, 7, 7));
        INTERVAL_MARKER_COLORS = INTERVAL_KERNEL_COLORS;
        INTERVAL_ENVIRONMENT_SPEED_COLORS = new GradientColors(ColorConstants.green, ColorConstants.green);
        INTERVAL_ENVIRONMENT_TEMP_COLORS = new GradientColors(ColorConstants.blue, ColorConstants.blue);
        INTERVAL_ENVIRONMENT_POWER_COLORS = new GradientColors(ColorConstants.cyan, ColorConstants.cyan);
        INTERVAL_ENVIRONMENT_COOLING_COLORS = new GradientColors(ColorConstants.orange, ColorConstants.orange);
        INTERVAL_UVM_MEMCPY_DTOH_COLORS = INTERVAL_UVM_MEMCPY_HTOD_COLORS = new GradientColors(new Color(null, 154, 101, 48), new Color(null, 162, 104, 45));
        INTERVAL_UVM_PAGE_FAULT_COLORS = INTERVAL_UVM_MEMCPY_HTOD_COLORS;
        INTERVAL_GPU_UTILIZATION = new GradientColors(new Color(null, 170, 170, 170), new Color(null, 170, 170, 170));
        REGIONOFINTEREST_SELECTED_FGCOLOR = REGIONOFINTEREST_SELECTED_BGCOLOR = new Color(null, 39, 168, 42);
        REGIONOFINTEREST_FGCOLOR = REGIONOFINTEREST_BGCOLOR = new Color(null, 145, 213, 147);
        INTERVAL_KERNEL_COLORTHEME = new ColorTheme(180.0f, 55.0f, 0.5f, 0.85f);
        COLOR_INACTIVE_THREADS = new Color(null, 255, 128, 128);
        COLOR_PRED_OFF_THREADS = new Color(null, 128, 128, 255);
        COLOR_GRAPH_BORDER = ColorConstants.lightGray;
        COLOR_EXEC_COUNT_BACKGROUND = new Color(null, 225, 225, 225);
        COLOR_HOTSPOT_HIGH = ColorConstants.red;
        COLOR_HOTSPOT_MED = ColorConstants.yellow;
        COLOR_OPERAND_PREDICATE = ColorConstants.blue;
        COLOR_LABEL = ColorConstants.darkGreen;
        COLOR_OPERAND_REGISTER = new Color(null, 139, 69, 19);
        markerColors = new HashMap<Integer, GradientColors>();
    }

    public static List<Color> getColors(int numColors, ColorTheme theme) {
        ArrayList<Color> colors = new ArrayList<Color>(numColors);
        double degreesTotal = theme.startHue > theme.endHue ? 360.0f - theme.startHue + theme.endHue : theme.endHue - theme.startHue;
        double incr = Math.abs(theme.endHue - theme.startHue) == 360.0f ? degreesTotal / (double)(numColors + 1) : degreesTotal / (double)numColors;
        double h = theme.startHue;
        int c = 0;
        while (c < numColors) {
            colors.add(new Color(null, new RGB((float)Math.round(h), theme.saturation, theme.value)));
            h = 360.0 - h > incr ? (h += incr) : incr - (360.0 - h);
            ++c;
        }
        return colors;
    }

    public static List<GradientColors> getGradientColors(int numColors, ColorTheme theme) {
        ArrayList<GradientColors> colors = new ArrayList<GradientColors>(numColors);
        double degreesTotal = theme.startHue > theme.endHue ? 360.0f - theme.startHue + theme.endHue : theme.endHue - theme.startHue;
        double incr = Math.abs(theme.endHue - theme.startHue) == 360.0f ? degreesTotal / (double)(numColors + 1) : degreesTotal / (double)numColors;
        float secondaryValue = theme.value / 2.0f;
        double h = theme.startHue;
        int c = 0;
        while (c < numColors) {
            Color primary = new Color(null, new RGB((float)Math.round(h), theme.saturation, theme.value));
            Color secondary = new Color(null, new RGB((float)Math.round(h), theme.saturation, secondaryValue));
            colors.add(new GradientColors(primary, secondary));
            h = 360.0 - h > incr ? (h += incr) : incr - (360.0 - h);
            ++c;
        }
        return colors;
    }

    public static GradientColors getMarkerGradientColors(int rgb, boolean gradient) {
        GradientColors colors = markerColors.get(rgb);
        if (colors == null) {
            Color primary;
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            RGB primaryRgb = new RGB(red, green, blue);
            Color secondary = primary = new Color(null, primaryRgb);
            if (gradient) {
                float[] hsb = primaryRgb.getHSB();
                secondary = new Color(null, new RGB(hsb[0], hsb[1], hsb[2] / 2.0f));
            }
            colors = new GradientColors(primary, secondary);
            markerColors.put(rgb, colors);
        }
        return colors;
    }

    public static class ColorTheme {
        public float startHue;
        public float endHue;
        public float saturation;
        public float value;

        public ColorTheme(float startHue, float endHue, float saturation, float value) {
            this.startHue = this.clamp(startHue, 0.0f, 360.0f);
            this.endHue = this.clamp(endHue, 0.0f, 360.0f);
            this.saturation = this.clamp(saturation, 0.0f, 1.0f);
            this.value = this.clamp(value, 0.0f, 1.0f);
        }

        private float clamp(float value, float low, float high) {
            return Math.min(Math.max(value, low), high);
        }
    }

    public static class GradientColors {
        public final Color primary;
        public final Color secondary;

        public GradientColors(Color primary, Color secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public GradientColors(Color color) {
            this(color, color);
        }

        public void dispose() {
            if (this.primary != null) {
                this.primary.dispose();
            }
            if (this.secondary != null) {
                this.secondary.dispose();
            }
        }
    }
}

