/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.widgets;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.SynchronizeParticipantRegistry;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.preferences.SyncFileFilterDialog;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.PreferenceSyncFileFilterStorage;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SyncProjectWidget
extends Composite {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String EMPTY_STRING = "";
    private Text fLocalProjectLocationText;
    private Button fUseDefaultLocationButton;
    private Button fLocalBrowseButton;
    private PreferenceSyncFileFilterStorage fCustomFilter;
    private ISynchronizeParticipant fSelectedParticipant;
    private String fMessage;
    private String fErrorMessage;
    private int fMessageType;
    private boolean fIsComplete;
    private final boolean fHasLocalGroup;
    private String fProjectName = "";

    public static SyncProjectWidget newProjectWidget(Composite parent, int style, IRunnableContext context) {
        return new SyncProjectWidget(parent, style, context, true);
    }

    public static SyncProjectWidget convertProjectWidget(Composite parent, int style, IRunnableContext context) {
        return new SyncProjectWidget(parent, style, context, false);
    }

    private SyncProjectWidget(Composite parent, int style, IRunnableContext context, boolean isForNewProject) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.fHasLocalGroup = isForNewProject;
        if (isForNewProject) {
            this.createLocalGroup(this);
        }
        this.createRemoteGroup(this, context);
        this.createFilterGroup(this);
    }

    private final void createFilterGroup(Composite parent) {
        final Button filterButton = new Button(parent, 8);
        filterButton.setText(Messages.SyncProjectWidget_Modify_file_filtering);
        filterButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceSyncFileFilterStorage tmpFilter = SyncProjectWidget.this.fCustomFilter == null ? SyncManager.getDefaultFileFilter() : new PreferenceSyncFileFilterStorage(SyncProjectWidget.this.fCustomFilter);
                int filterReturnCode = SyncFileFilterDialog.openBlocking(filterButton.getShell(), (AbstractSyncFileFilter)tmpFilter);
                if (filterReturnCode == 0) {
                    SyncProjectWidget.this.fCustomFilter = tmpFilter;
                }
            }
        });
    }

    private final void createLocalGroup(Composite parent) {
        Group localGroup = new Group(parent, 16);
        localGroup.setText(Messages.SyncProjectWidget_Local_directory);
        localGroup.setLayout((Layout)new GridLayout(3, false));
        localGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fUseDefaultLocationButton = new Button((Composite)localGroup, 32);
        this.fUseDefaultLocationButton.setText(Messages.SyncProjectWidget_Use_default_location);
        this.fUseDefaultLocationButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.fUseDefaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncProjectWidget.this.setLocalProjectLocation();
            }
        });
        this.fUseDefaultLocationButton.setSelection(true);
        Label label = new Label((Composite)localGroup, 0);
        label.setText(Messages.SyncProjectWidget_Local_directory_label);
        label.setFont(parent.getFont());
        this.fLocalProjectLocationText = new Text((Composite)localGroup, 2048);
        GridData locationData = new GridData(4, 0x1000000, true, false, 1, 1);
        locationData.widthHint = 250;
        this.fLocalProjectLocationText.setLayoutData((Object)locationData);
        this.fLocalProjectLocationText.setFont(parent.getFont());
        this.fLocalProjectLocationText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SyncProjectWidget.this.setPageComplete(SyncProjectWidget.this.validatePage());
                SyncProjectWidget.this.notifyListeners(24, e);
            }
        });
        this.fLocalProjectLocationText.setEnabled(false);
        this.fLocalBrowseButton = new Button((Composite)localGroup, 8);
        this.fLocalBrowseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fLocalBrowseButton.setText(Messages.SyncProjectWidget_Browse);
        this.fLocalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(SyncProjectWidget.this.getShell());
                dirDialog.setText(Messages.SyncProjectWidget_Select_project_local_directory);
                String selectedDir = dirDialog.open();
                SyncProjectWidget.this.fLocalProjectLocationText.setText(selectedDir);
            }
        });
    }

    private final void createRemoteGroup(Composite parent, IRunnableContext context) {
        Group remoteGroup = new Group(parent, 16);
        remoteGroup.setText(Messages.SyncProjectWidget_Remote_directory);
        remoteGroup.setLayout((Layout)new GridLayout(1, false));
        remoteGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ISynchronizeParticipantDescriptor[] providers = SynchronizeParticipantRegistry.getDescriptors();
        this.fSelectedParticipant = providers[0].getParticipant();
        this.fSelectedParticipant.createConfigurationArea((Composite)remoteGroup, context);
        this.fSelectedParticipant.setProjectName(EMPTY_STRING);
    }

    public String getSyncConfigName() {
        return this.fSelectedParticipant.getSyncConfigName();
    }

    public AbstractSyncFileFilter getCustomFileFilter() {
        return this.fCustomFilter;
    }

    public String getErrorMessage() {
        this.setPageComplete(this.validatePage());
        return this.fErrorMessage;
    }

    public String getMessage() {
        this.setPageComplete(this.validatePage());
        return this.fMessage;
    }

    public int getMessageType() {
        this.setPageComplete(this.validatePage());
        return this.fMessageType;
    }

    public String getProjectLocalLocation() {
        if (!this.fHasLocalGroup) {
            return null;
        }
        if (this.fLocalProjectLocationText == null) {
            return EMPTY_STRING;
        }
        return this.fLocalProjectLocationText.getText().trim();
    }

    private String getProjectName() {
        return this.fProjectName;
    }

    public ISynchronizeParticipant getSynchronizeParticipant() {
        return this.fSelectedParticipant;
    }

    public boolean isPageComplete() {
        return this.fIsComplete;
    }

    private void setLocalProjectLocation() {
        if (this.fUseDefaultLocationButton.getSelection()) {
            String name = this.getProjectName();
            if (!name.equals(EMPTY_STRING)) {
                this.fLocalProjectLocationText.setText(String.valueOf(Platform.getLocation().toOSString()) + File.separator + name);
            } else {
                this.fLocalProjectLocationText.setText(Platform.getLocation().toOSString());
            }
        } else if (!this.fLocalProjectLocationText.isEnabled()) {
            this.fLocalProjectLocationText.setText(EMPTY_STRING);
        }
        this.fLocalProjectLocationText.setEnabled(!this.fUseDefaultLocationButton.getSelection());
    }

    private void setPageComplete(boolean complete) {
        this.fIsComplete = complete;
    }

    public void setProjectName(String name) {
        this.fProjectName = name;
        if (this.fHasLocalGroup) {
            this.setLocalProjectLocation();
        }
        if (this.fSelectedParticipant != null) {
            this.fSelectedParticipant.setProjectName(name);
        }
    }

    public boolean useDefaults() {
        if (!this.fHasLocalGroup) {
            return false;
        }
        return this.fUseDefaultLocationButton.getSelection();
    }

    private boolean validateLocalLocation() {
        block6: {
            IStatus locationStatus;
            if (this.getProjectName().equals(EMPTY_STRING)) {
                this.fErrorMessage = Messages.SyncProjectWidget_Project_name_must_be_specified;
                return false;
            }
            IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
            URI location = URIUtil.toURI((String)this.fLocalProjectLocationText.getText());
            if (handle.exists()) {
                this.fErrorMessage = Messages.SyncProjectWidget_Project_already_exists;
                return false;
            }
            if (!this.fUseDefaultLocationButton.getSelection() && !(locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocationURI(handle, location)).isOK()) {
                this.fErrorMessage = locationStatus.getMessage();
                return false;
            }
            try {
                IFileStore fs = EFS.getStore((URI)location);
                IFileInfo f = fs.fetchInfo();
                if (!f.exists()) break block6;
                if (f.isDirectory()) {
                    this.fMessage = Messages.SyncProjectWidget_Directory_already_exists;
                    this.fMessageType = 2;
                    break block6;
                }
                this.fErrorMessage = Messages.SyncProjectWidget_9;
                return false;
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.log(e.getStatus());
            }
        }
        return true;
    }

    private boolean validatePage() {
        this.fMessage = null;
        this.fMessageType = 0;
        this.fErrorMessage = null;
        if (this.fHasLocalGroup) {
            return this.validateLocalLocation() && this.validateRemoteLocation();
        }
        return this.validateRemoteLocation();
    }

    private boolean validateRemoteLocation() {
        this.fErrorMessage = this.fSelectedParticipant.getErrorMessage();
        return this.fSelectedParticipant.getErrorMessage() == null && this.fSelectedParticipant.isConfigComplete();
    }
}

