/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.wizards;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.SynchronizeWizardExtensionRegistry;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.SyncWizardDataCache;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeWizardExtension;
import org.eclipse.ptp.rdt.sync.ui.widgets.SyncProjectWidget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class SyncMainWizardPage
extends WizardNewProjectCreationPage {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String EMPTY_STRING = "";
    private static final String syncConfigSetKey = "sync-config-set";
    private static final String projectNameKey = "project-name";
    private String message;
    private int messageType = 0;
    private String errorMessage;
    private Text fProjectNameText;
    private Combo fProjectSelectionCombo;
    private SyncProjectWidget fSyncWidget;
    private ISynchronizeWizardExtension extension;
    private IWizardPage extWizardPage;
    private final boolean isNewProject;

    public static SyncMainWizardPage newProjectPage(String pageName) {
        return new SyncMainWizardPage(pageName, true);
    }

    public static SyncMainWizardPage convertProjectPage(String pageName) {
        return new SyncMainWizardPage(pageName, false);
    }

    private SyncMainWizardPage(String pageName, boolean isForNewProject) {
        super(pageName);
        this.isNewProject = isForNewProject;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite);
        if (this.isNewProject) {
            this.createProjectInfoGroupForNewProject(composite);
        } else {
            this.createProjectInfoGroupForExistingProject(composite);
        }
        this.fSyncWidget = this.isNewProject ? SyncProjectWidget.newProjectWidget(composite, 0, (IRunnableContext)this.getWizard().getContainer()) : SyncProjectWidget.convertProjectWidget(composite, 0, (IRunnableContext)this.getWizard().getContainer());
        this.fSyncWidget.setLayoutData(new GridData(1808));
        this.fSyncWidget.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SyncMainWizardPage.this.update();
                SyncMainWizardPage.this.getWizard().getContainer().updateMessage();
            }
        });
        this.setPageComplete(false);
        this.errorMessage = null;
        this.message = null;
        this.messageType = 0;
        Dialog.applyDialogFont((Control)composite);
    }

    private final void createProjectInfoGroupForExistingProject(Composite parent) {
        Group localGroup = new Group(parent, 16);
        localGroup.setText(Messages.SyncProjectWidget_Project_to_convert);
        localGroup.setLayout((Layout)new GridLayout(2, false));
        localGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label = new Label((Composite)localGroup, 0);
        label.setText(Messages.SyncProjectWidget_Project_to_convert_label);
        label.setFont(parent.getFont());
        this.fProjectSelectionCombo = new Combo((Composite)localGroup, 8);
        this.populateProjectCombo();
        this.fProjectSelectionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fProjectSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                if (SyncMainWizardPage.this.fSyncWidget != null && (SyncMainWizardPage.this.validateProjectName() || SyncMainWizardPage.this.getProjectName().equals(SyncMainWizardPage.EMPTY_STRING))) {
                    SyncMainWizardPage.this.fSyncWidget.setProjectName(SyncMainWizardPage.this.getProjectName());
                    SyncMainWizardPage.this.handleProjectSelected(SyncMainWizardPage.this.getProject());
                }
                SyncMainWizardPage.this.update();
                SyncMainWizardPage.this.getWizard().getContainer().updateMessage();
            }
        });
    }

    private final void createProjectInfoGroupForNewProject(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectNameLabel = new Label(projectGroup, 0);
        projectNameLabel.setText(Messages.SyncMainWizardPage_Project_name);
        projectNameLabel.setFont(parent.getFont());
        this.fProjectNameText = new Text(projectGroup, 2048);
        GridData nameData = new GridData(768);
        nameData.widthHint = 250;
        this.fProjectNameText.setLayoutData((Object)nameData);
        this.fProjectNameText.setFont(parent.getFont());
        this.fProjectNameText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (SyncMainWizardPage.this.fSyncWidget != null && (SyncMainWizardPage.this.validateProjectName() || SyncMainWizardPage.this.getProjectName().equals(SyncMainWizardPage.EMPTY_STRING))) {
                    SyncMainWizardPage.this.fSyncWidget.setProjectName(SyncMainWizardPage.this.getProjectName());
                }
                SyncMainWizardPage.this.update();
                SyncMainWizardPage.this.getWizard().getContainer().updateMessage();
            }
        });
    }

    public IProject getProject() {
        if (this.isNewProject) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.isNewProject) {
            if (this.fProjectNameText == null) {
                return EMPTY_STRING;
            }
            return this.fProjectNameText.getText().trim();
        }
        return this.fProjectSelectionCombo.getText();
    }

    public AbstractSyncFileFilter getCustomFileFilter() {
        return this.fSyncWidget.getCustomFileFilter();
    }

    public String getErrorMessage() {
        this.update();
        return this.errorMessage;
    }

    public IPath getLocationPath() {
        return new Path(this.fSyncWidget.getProjectLocalLocation());
    }

    public URI getLocationURI() {
        try {
            return new URI("file://" + this.getLocationPath().toString());
        }
        catch (URISyntaxException e) {
            RDTSyncUIPlugin.log(e);
            return null;
        }
    }

    public String getMessage() {
        this.update();
        return this.message;
    }

    public int getMessageType() {
        this.update();
        return this.messageType;
    }

    public IWizardPage getNextPage() {
        return this.extWizardPage;
    }

    private String[] getSyncConfigNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        configNames.add("Local");
        String remoteConfigName = this.fSyncWidget.getSyncConfigName();
        if (remoteConfigName != null) {
            configNames.add(remoteConfigName);
        }
        return configNames.toArray(new String[0]);
    }

    public ISynchronizeParticipant getSynchronizeParticipant() {
        return this.fSyncWidget.getSynchronizeParticipant();
    }

    public ISynchronizeWizardExtension getExtension() {
        return this.extension;
    }

    private void handleProjectSelected(IProject project) {
        ISynchronizeWizardExtension ext = SynchronizeWizardExtensionRegistry.getSynchronizeWizardExtensionForProject(project);
        if (ext == null) {
            this.extWizardPage = null;
        } else {
            this.extension = ext;
            this.extWizardPage = ext.createConvertProjectWizardPage();
            IWizard wizard = this.getWizard();
            assert (wizard instanceof Wizard);
            ((Wizard)wizard).addPage(this.extWizardPage);
        }
    }

    private void populateProjectCombo() {
        IProject[] allProjects;
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.isOpen() && !RemoteSyncNature.hasNature((IProject)p)) {
                this.fProjectSelectionCombo.add(p.getName());
            }
            ++n2;
        }
    }

    public void setInitialProjectName(String name) {
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            if (this.isNewProject) {
                this.fProjectNameText.setFocus();
            } else {
                this.fProjectSelectionCombo.setFocus();
            }
        }
    }

    private void update() {
        boolean isValid = this.validatePage();
        this.setPageComplete(isValid);
        if (isValid) {
            HashSet<String> configNamesSet = new HashSet<String>();
            String[] stringArray = this.getSyncConfigNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                configNamesSet.add(name);
                ++n2;
            }
            SyncWizardDataCache.setProperty(projectNameKey, this.getProjectName());
            SyncWizardDataCache.setMultiValueProperty(syncConfigSetKey, configNamesSet);
        }
    }

    public boolean useDefaults() {
        return this.fSyncWidget.useDefaults();
    }

    protected boolean validatePage() {
        this.message = null;
        this.messageType = 0;
        this.errorMessage = null;
        if (!this.validateProjectName()) {
            return false;
        }
        if (!this.fSyncWidget.isPageComplete()) {
            this.message = this.fSyncWidget.getMessage();
            this.messageType = this.fSyncWidget.getMessageType();
            this.errorMessage = this.fSyncWidget.getErrorMessage();
            return false;
        }
        return true;
    }

    private boolean validateProjectName() {
        String projectFieldContents = this.getProjectName();
        if (projectFieldContents.equals(EMPTY_STRING)) {
            this.message = Messages.SyncMainWizardPage_Project_name_must_be_specified;
            this.messageType = 0;
            return false;
        }
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.errorMessage = nameStatus.getMessage();
            return false;
        }
        if (this.getProjectName().indexOf(35) >= 0) {
            this.errorMessage = Messages.SyncMainWizardPage_Project_name_cannot_contain_hash;
            return false;
        }
        return true;
    }
}

