/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.sdk.ui;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.common.ui.Messages;
import com.nvidia.cuda.ide.devices.CudaDevice;
import com.nvidia.cuda.ide.sdk.CudaSDKCore;
import com.nvidia.cuda.ide.sdk.ui.CLabelFieldEditor;
import com.nvidia.cuda.ide.sdk.ui.CheckboxListFieldEditor;
import com.nvidia.cuda.ide.sdk.ui.ClearDialogTogglesFieldEditor;
import com.nvidia.cuda.ide.sdk.ui.PreemptionFieldEditor;
import com.nvidia.cuda.ide.sdk.ui.SpacerFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class CudaTookitPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FieldEditor devices = null;
    private PreemptionFieldEditor preemption;

    public CudaTookitPreferencePage() {
        super("CUDA Toolkit", 0);
        this.setPreferenceStore(CudaSDKCore.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        if (CudaDevice.devicesFilteredExternally()) {
            this.addField(new CLabelFieldEditor(parent, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"), "CUDA_VISIBLE_DEVICES is set for Nsight Eclipse Edition process"));
        } else {
            String[][] devs = this.getDevices();
            if (devs == null) {
                this.addField(new CLabelFieldEditor(parent, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"), "No CUDA-compatible devices were detected on your system"));
            } else {
                this.devices = new CheckboxListFieldEditor("defaultCudaDevice", "Enabled CUDA Devices", devs, parent);
                this.addField(this.devices);
            }
        }
        parent.getParent().getParent().layout(true);
        this.addField(new SpacerFieldEditor("", "", parent));
        this.preemption = new PreemptionFieldEditor("enablePreemption", Messages.title_preemption, parent);
        this.addField(this.preemption);
        this.addField(new SpacerFieldEditor("", "", parent));
        this.addField(new ClearDialogTogglesFieldEditor(parent));
    }

    private String[][] getDevices() {
        ICudaDevice[] devices = CudaDevice.getDevices(true, null);
        if (devices.length == 0) {
            return null;
        }
        String[][] combo = new String[devices.length][2];
        int i = 0;
        while (i < devices.length) {
            combo[i][0] = devices[i].getName();
            combo[i][1] = String.valueOf(devices[i].getOrdinal());
            ++i;
        }
        return combo;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    public void init(IWorkbench workbench) {
    }
}

