/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.launch;

public enum LaunchMode {
    DEBUG("debug"),
    PROFILE("profile"),
    RUN("run");

    private final String platformString;

    public static LaunchMode fromPlatformString(String string) {
        LaunchMode[] launchModeArray = LaunchMode.values();
        int n = launchModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchMode mode = launchModeArray[n2];
            if (mode.getPlatformString().equals(string)) {
                return mode;
            }
            ++n2;
        }
        throw new IllegalArgumentException(string);
    }

    private LaunchMode(String platformString) {
        this.platformString = platformString;
    }

    public String getPlatformString() {
        return this.platformString;
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this) {
            case DEBUG: {
                return visitor.debug();
            }
            case RUN: {
                return visitor.run();
            }
            case PROFILE: {
                return visitor.profile();
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public static interface Visitor<T> {
        public T debug();

        public T profile();

        public T run();
    }
}

