/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.connection.CudaToolkitWorkingCopy;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.wizard.AbstractRemoteDebugSession;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugWizardProperties;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteDebugMainWizardPage;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteLaunchMainWizardPage;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.RemoteConnectionToolkitWizardPage;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import com.nvidia.cuda.ide.remote.ui.launch.LaunchMode;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;

public final class RemoteRunDebugSession
extends AbstractRemoteDebugSession {
    public static final PropertyDescriptor<String> PROPERTY_PROGRAM_ARGUMENTS = new PropertyDescriptor("program.arguments", String.class);
    public static final PropertyDescriptor<ICudaRemoteDebugConstants.ExecutableTransferMode> PROPERTY_TRANSFER_EXECUTABLE = new PropertyDescriptor("transfer.executable", ICudaRemoteDebugConstants.ExecutableTransferMode.class);
    private final String executable;
    private final IBinary binary;
    private final LaunchMode mode;
    private RemoteConnectionToolkitWizardPage toolkitPage;

    private static String createUniqueLaunchConfigurationName(String exe, String target) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.generateLaunchConfigurationName(String.format("%s on %s", exe, target));
    }

    private static IPath getSynchronizedExecutablePath(WizardContext context) {
        SyncConfig config;
        IFile file;
        String localExe = (String)context.getProperty(PROPERTY_LOCAL_EXECUTABLE_PATH);
        IRemoteConnection connection = (IRemoteConnection)context.getProperty(PROPERTY_REMOTE_CONNECTION);
        if (!CoreUtil.isNullOrEmpty((String)localExe) && connection != null && !connection.isLocalSystem() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(localExe))).exists() && (config = SyncConfigManager.getConfig((IProject)file.getProject(), (String)connection.getName())) != null) {
            return new Path(config.getLocation(file.getProject())).append(file.getProjectRelativePath());
        }
        return null;
    }

    public RemoteRunDebugSession(LaunchMode mode) {
        this(null, mode);
    }

    protected String getBinaryPath() {
        if (this.binary == null) {
            return null;
        }
        return this.binary.getPath().toOSString();
    }

    protected IProject getBinaryProject() {
        ICElement parent = this.binary.getParent();
        while (parent != null) {
            if (parent instanceof ICProject) {
                return ((ICProject)parent).getProject();
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected IProject getProjectWithNature(String natureId) {
        IProject project = this.getBinaryProject();
        try {
            if (project.hasNature(natureId)) {
                return project;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public RemoteRunDebugSession(IBinary binary, LaunchMode mode) {
        this.binary = binary;
        this.executable = this.getBinaryPath();
        this.mode = mode;
    }

    private RemoteLaunchMainWizardPage createMainPage() {
        return this.mode.visit(new LaunchMode.Visitor<RemoteLaunchMainWizardPage>(){

            @Override
            public RemoteLaunchMainWizardPage debug() {
                return new RemoteDebugMainWizardPage(RemoteRunDebugSession.this.context);
            }

            @Override
            public RemoteLaunchMainWizardPage profile() {
                return new RemoteLaunchMainWizardPage(RemoteRunDebugSession.this.context, "Profile Application Remotely", "Profile application on a remote system", "Collect application performance data by executing the application on a remote system");
            }

            @Override
            public RemoteLaunchMainWizardPage run() {
                return new RemoteLaunchMainWizardPage(RemoteRunDebugSession.this.context, "Run Application Remotely", "Run application on a remote system", "Execute the application on a remote system");
            }
        });
    }

    @Override
    public IWizardPage[] createWizardPages() {
        this.toolkitPage = new RemoteConnectionToolkitWizardPage(this.context, PROPERTY_REMOTE_CONNECTION, "Select cuda-gdbserver location", "nvcc");
        return new IWizardPage[]{this.createMainPage(), this.toolkitPage};
    }

    @Override
    protected void fillLaunchConfigurationProperties(ILaunchConfigurationWorkingCopy lc, IRemoteConnection connection) {
        lc.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", (String)this.context.getProperty(PROPERTY_PROGRAM_ARGUMENTS));
        CudaToolkitWorkingCopy toolkit = this.toolkitPage.getToolkit();
        connection.updateToolkit(toolkit);
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, toolkit.getToolPath(ICudaToolkit.Tool.GdbServer));
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
        lc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "gdbserver");
        lc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", GdbUIPlugin.getDefault().getPreferenceStore().getBoolean("defaultStopAtMain"));
        ICudaRemoteDebugConstants.ExecutableTransferMode transferMode = this.getTransfer();
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, transferMode == ICudaRemoteDebugConstants.ExecutableTransferMode.Notransfer);
        lc.setAttribute(ICudaRemoteDebugConstants.ATTRIBUTE_EXECUTABLE_TRANSFER, transferMode.name());
    }

    @Override
    public String getDescription() {
        return "Remotely debug a CUDA application. This debug session can:\n1. Copy debugged application executable to the the remote target.\n2. Remotely launch cuda-gdbserver.\n3. Connect to the remote server using local cuda-gdb";
    }

    @Override
    protected final String getLaunchConfigurationType() {
        return "org.eclipse.cdt.launch.remoteApplicationLaunchType";
    }

    @Override
    public String getName() {
        return "Debug an application on a remote system";
    }

    private ICudaRemoteDebugConstants.ExecutableTransferMode getTransfer() {
        Path userEntry;
        if (this.mode == LaunchMode.DEBUG) {
            return (ICudaRemoteDebugConstants.ExecutableTransferMode)((Object)this.context.getProperty(PROPERTY_TRANSFER_EXECUTABLE));
        }
        IPath path = RemoteRunDebugSession.getSynchronizedExecutablePath(this.context);
        if (CoreUtil.equals((Object)path, (Object)(userEntry = new Path((String)this.context.getProperty(PROPERTY_REMOTE_EXECUTABLE))))) {
            return ICudaRemoteDebugConstants.ExecutableTransferMode.Download;
        }
        return ICudaRemoteDebugConstants.ExecutableTransferMode.Upload;
    }

    @Override
    public boolean isEditable(PropertyDescriptor<?> property) {
        return this.executable == null || property != PROPERTY_LOCAL_EXECUTABLE_PATH;
    }

    @Override
    protected void recomputeDefaults(ContextPropertyStore defaultsStore, IProgressMonitor monitor) {
        String pathString;
        IRemoteConnection connection;
        if (this.executable != null) {
            defaultsStore.setProperty(PROPERTY_LOCAL_EXECUTABLE_PATH, (Object)this.executable);
        }
        if (monitor != null) {
            IRemoteConnection connection2;
            IProject project = this.getProjectWithNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature");
            SyncConfig config = project != null ? SyncConfigManager.getActive((IProject)project) : null;
            String connectionName = config != null ? config.getConnectionName() : null;
            IRemoteConnection iRemoteConnection = connection2 = connectionName != null ? IRemoteConnectionsService.GetConnection.getConnection((String)connectionName, (IProgressMonitor)monitor) : null;
            if (connection2 != null) {
                defaultsStore.setProperty(PROPERTY_REMOTE_CONNECTION, (Object)connection2);
            }
        }
        defaultsStore.setProperty(IDebugWizardProperties.PROPERTY_LAUNCH_CONFIGURATION_NAME, (Object)"Remote Launch");
        if (!this.setupSynchronizedProjectDefaults(defaultsStore)) {
            this.setupNonSynchronizedProjectDefaults(defaultsStore);
        }
        if ((connection = this.updateContextConnectionProperties()) != null && !CoreUtil.isNullOrEmpty((String)(pathString = (String)this.context.getProperty(PROPERTY_REMOTE_EXECUTABLE)))) {
            String exe = Path.fromOSString((String)pathString).lastSegment();
            String label = RemoteRunDebugSession.createUniqueLaunchConfigurationName(exe, connection.getName());
            defaultsStore.setProperty(IDebugWizardProperties.PROPERTY_LAUNCH_CONFIGURATION_NAME, (Object)DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(label));
        }
    }

    @Override
    protected void saveDefaults(IRemoteConnection connection) {
    }

    private void setupNonSynchronizedProjectDefaults(ContextPropertyStore defaultsStore) {
        String localExePath;
        defaultsStore.setProperty(PROPERTY_TRANSFER_EXECUTABLE, (Object)ICudaRemoteDebugConstants.ExecutableTransferMode.Upload);
        String remotePath = null;
        if (this.context.getProperty(PROPERTY_TRANSFER_EXECUTABLE) == ICudaRemoteDebugConstants.ExecutableTransferMode.Upload && !CoreUtil.isNullOrEmpty((String)(localExePath = (String)this.context.getProperty(PROPERTY_LOCAL_EXECUTABLE_PATH)))) {
            Path path = new Path(localExePath);
            remotePath = new Path("/tmp/nsight-debug").append(path.lastSegment()).toString();
        }
        defaultsStore.setProperty(PROPERTY_REMOTE_EXECUTABLE, remotePath);
    }

    private boolean setupSynchronizedProjectDefaults(ContextPropertyStore defaultsStore) {
        IPath remoteExecutablePath = RemoteRunDebugSession.getSynchronizedExecutablePath(this.context);
        if (remoteExecutablePath != null) {
            defaultsStore.setProperty(PROPERTY_TRANSFER_EXECUTABLE, (Object)ICudaRemoteDebugConstants.ExecutableTransferMode.Notransfer);
            defaultsStore.setProperty(PROPERTY_REMOTE_EXECUTABLE, (Object)remoteExecutablePath.toString());
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldRecomputeDefaults(PropertyDescriptor<?> property) {
        return CoreUtil.isOneOf(property, (Object[])new Object[]{PROPERTY_LOCAL_EXECUTABLE_PATH, PROPERTY_TRANSFER_EXECUTABLE, PROPERTY_REMOTE_EXECUTABLE, PROPERTY_REMOTE_CONNECTION});
    }
}

