/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.internal.wizard.AbstractRemoteDebugSession;
import com.nvidia.cuda.ide.remote.internal.wizard.LocalPathField;
import com.nvidia.cuda.ide.remote.internal.wizard.RemotePathField;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteRunDebugSession;
import com.nvidia.cuda.ide.remote.ui.connection.ConnectionStateLabel;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionField;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteLaunchMainWizardPage
extends WizardPage
implements IWizardPage {
    private Label connectionGroupSeparator;
    private ConnectionStateLabel connectionStateLabel;
    protected final WizardContext context;
    protected LocalPathField localPathField;
    private Text programArguments;
    private RemoteConnectionField remoteConnectionField;
    protected RemotePathField remotePathField;

    public RemoteLaunchMainWizardPage(WizardContext context, String title, String message, String description) {
        super(title, message, null);
        this.context = context;
        this.setDescription(description);
    }

    protected void createAdditionalRemoteSystemControls(Composite composite) {
    }

    public final void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        this.setControl((Control)root);
        root.setLayout((Layout)new GridLayout(3, false));
        this.createTopControls(root);
        this.localPathField = new LocalPathField(root, this.context, true);
        this.connectionGroupSeparator = new Label(root, 258);
        this.connectionGroupSeparator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.remoteConnectionField = new RemoteConnectionField(root, this.context);
        this.createRemoteSystemWidgets(root);
        new Label(root, 0);
        Label lblNewLabel = new Label(root, 0);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.connectionStateLabel = new ConnectionStateLabel(root, this.context, AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION);
        this.setupBinding();
        this.setErrorMessage(null);
    }

    private void createRemoteSystemWidgets(Composite composite) {
        this.remotePathField = new RemotePathField(composite, this.context);
        Label lblProgramArguments = new Label(composite, 0);
        lblProgramArguments.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblProgramArguments.setText(Messages.RemoteDebug_firstWizardPage_argsLabel);
        this.programArguments = new Text(composite, 2048);
        this.programArguments.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.createAdditionalRemoteSystemControls(composite);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
    }

    protected void createTopControls(Composite root) {
    }

    private void setupBinding() {
        DataBindingContext bindingContext = new DataBindingContext(SWTObservables.getRealm((Display)this.getContainer().getShell().getDisplay()));
        this.remoteConnectionField.bind(bindingContext, AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION);
        this.remotePathField.bind(bindingContext, AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION, AbstractRemoteDebugSession.PROPERTY_REMOTE_EXECUTABLE);
        this.localPathField.bind(bindingContext, AbstractRemoteDebugSession.PROPERTY_LOCAL_EXECUTABLE_PATH);
        bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.programArguments, (int)24), this.context.observeProperty(RemoteRunDebugSession.PROPERTY_PROGRAM_ARGUMENTS));
        IObservableValue uploadProperty = this.context.observeProperty(RemoteRunDebugSession.PROPERTY_TRANSFER_EXECUTABLE);
        bindingContext.bindValue(uploadProperty, (IObservableValue)new AbstractObservableValue(){

            protected Object doGetValue() {
                if (RemoteLaunchMainWizardPage.this.context.getProperty(RemoteRunDebugSession.PROPERTY_TRANSFER_EXECUTABLE) != ICudaRemoteDebugConstants.ExecutableTransferMode.Download) {
                    return true;
                }
                return false;
            }

            protected void doSetValue(Object value) {
                boolean isNotDownloading = !ICudaRemoteDebugConstants.ExecutableTransferMode.Download.equals(value);
                RemoteLaunchMainWizardPage.this.localPathField.toggleState(isNotDownloading);
                SWTUtil.setVisible((Control)RemoteLaunchMainWizardPage.this.connectionGroupSeparator, (boolean)isNotDownloading);
                RemoteLaunchMainWizardPage.this.connectionGroupSeparator.getParent().layout();
            }

            public Object getValueType() {
                return Boolean.class;
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        bindingContext.bindValue((IObservableValue)new AbstractObservableValue(){

            protected Object doGetValue() {
                return CoreUtil.OK_STATUS;
            }

            protected void doSetValue(Object value) {
                RemoteLaunchMainWizardPage.this.updateTitle((IStatus)value);
            }

            public Object getValueType() {
                return IStatus.class;
            }
        }, (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                return RemoteLaunchMainWizardPage.this.validate();
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.connectionStateLabel.bind(bindingContext);
        this.setupBindings(this.context, bindingContext);
    }

    protected void setupBindings(WizardContext context, DataBindingContext bindingContext) {
    }

    protected final void updateTitle(IStatus status) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (status == null) {
            status = Status.OK_STATUS;
        }
        this.setPageComplete(status.getSeverity() < 4);
        switch (status.getSeverity()) {
            case 4: {
                this.setErrorMessage(status.getMessage());
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
            }
        }
    }

    protected IStatus validate() {
        return this.remoteConnectionField.validate();
    }
}

