/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.properties;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.remote.connection.ConnectionEditorDelegate;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.ui.properties.ManagedProjectRemoteTargetEntry;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTarget;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTargetEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RemoteTargetsList
extends Composite
implements RemoteTarget.ITargetContainer {
    private static final String PROMPT_SELECT_CONNECTION = "Select remote connection...";
    private final ComboViewer connections;
    private final Composite connectionsPane;
    private final DataBindingContext context = new DataBindingContext();
    private String localProjectLocation;
    private final ScrolledComposite scrolledComposite;
    private final AtomicBoolean selectionRecursionGuard = new AtomicBoolean(false);
    private final IObservableValue status = new WritableValue();
    private final List<IStatus> statuses = new ArrayList<IStatus>();
    private final Set<RemoteTarget> targets = new TreeSet<RemoteTarget>();
    private final boolean managed;

    private static SyncConfig getNewActiveConfig(IProject project) {
        SyncConfig[] c;
        SyncConfig[] syncConfigArray = c = SyncConfigManager.getConfigs((IProject)project);
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            SyncConfig syncConfig = syncConfigArray[n2];
            if (SyncConfigManager.isLocal((SyncConfig)syncConfig)) {
                return syncConfig;
            }
            ++n2;
        }
        return c[0];
    }

    public RemoteTargetsList(Composite parent, int style, boolean managed) {
        super(parent, style);
        this.managed = managed;
        RemoteTargetsList body = this;
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.verticalSpacing = 15;
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        body.setLayout((Layout)gl_composite);
        this.connections = this.addConfigItem(body);
        this.scrolledComposite = new ScrolledComposite((Composite)body, 512);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.connectionsPane = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout gl_connectionsPane = new GridLayout(1, false);
        gl_connectionsPane.marginWidth = 0;
        gl_connectionsPane.marginHeight = 0;
        this.connectionsPane.setLayout((Layout)gl_connectionsPane);
        this.refresh(null);
        this.scrolledComposite.setContent((Control)this.connectionsPane);
        body.layout();
    }

    protected void addConfig(IStructuredSelection selection) {
        Object selected;
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IRemoteConnection) {
            RemoteTarget target = RemoteTarget.forConnection(this, this.getProjectName(), (IRemoteConnection)selected, null);
            if (target != null) {
                if (target.isLocal()) {
                    target.setProjectLocation(this.localProjectLocation);
                }
                this.targets.add(target);
            }
            this.refresh(target);
        }
    }

    private String getProjectName() {
        return CoreUtil.isNullOrEmpty((String)this.localProjectLocation) ? null : new Path(this.localProjectLocation).lastSegment();
    }

    private ComboViewer addConfigItem(Composite composite) {
        Composite pane = new Composite(composite, 2048);
        pane.setForeground(Display.getCurrent().getSystemColor(2));
        pane.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        GridLayout gl_composite_2 = new GridLayout(2, false);
        gl_composite_2.marginHeight = 0;
        gl_composite_2.marginWidth = 0;
        pane.setLayout((Layout)gl_composite_2);
        final ComboViewer connections = new ComboViewer(pane, 8);
        connections.getControl().setLayoutData((Object)new GridData(768));
        connections.setContentProvider((IContentProvider)new ArrayContentProvider());
        connections.setLabelProvider((IBaseLabelProvider)new ConnectionsLabelProvider());
        connections.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IRemoteConnection) || RemoteTargetsList.this.unusedConnection((IRemoteConnection)element);
            }
        }});
        connections.setSorter(new ViewerSorter(){

            public int category(Object element) {
                return element instanceof IRemoteConnection ? 2 : 0;
            }
        });
        connections.setInput((Object)this.getComboInput());
        connections.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RemoteTargetsList.this.restoreSelection(connections)) {
                    RemoteTargetsList.this.addConfig((IStructuredSelection)event.getSelection());
                }
            }
        });
        this.restoreSelection(connections);
        Button newConfig = new Button(pane, 0);
        newConfig.setText("Manage...");
        newConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IRemoteConnection edited = (IRemoteConnection)CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, IRemoteConnection>(){

                        public IRemoteConnection runWithService(IRemoteConnectionsService service) throws CoreException {
                            return service.manage(RemoteTargetsList.this.getShell(), (ConnectionEditorDelegate)new ConnectionWizardDelegate());
                        }
                    });
                    if (edited != null) {
                        RemoteTargetsList.this.addConfig((IStructuredSelection)new StructuredSelection((Object)edited));
                    }
                    connections.setInput((Object)RemoteTargetsList.this.getComboInput());
                    connections.setSelection((ISelection)new StructuredSelection((Object)RemoteTargetsList.PROMPT_SELECT_CONNECTION));
                    connections.refresh();
                }
                catch (CoreException e1) {
                    Activator.log((Exception)((Object)e1));
                }
            }
        });
        SWTUtil.setBackground((Control)pane, (int)15);
        connections.getControl().setBackground(null);
        return connections;
    }

    private Object[] getComboInput() {
        try {
            Object[] remoteConnections = (Object[])CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, Object[]>(){

                public Object[] runWithService(IRemoteConnectionsService service) {
                    return service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
                }
            });
            return CoreUtil.join((Object[])new Object[]{PROMPT_SELECT_CONNECTION}, (Object[])remoteConnections);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return new Object[0];
        }
    }

    private RemoteTarget getLocalBuildTarget() {
        for (RemoteTarget target : this.targets) {
            if (target == null || !target.isLocal()) continue;
            return target;
        }
        return null;
    }

    public IObservableValue getStatus() {
        return this.status;
    }

    private boolean isLocalOnly() {
        if (this.targets.size() == 1) {
            RemoteTarget target = (RemoteTarget)CoreUtil.first(this.targets);
            return target != null && target.isLocal();
        }
        return false;
    }

    private RemoteTargetEntry newEntry(int index) {
        RemoteTargetEntry entry = this.createTargetEntry();
        entry.setLayoutData(new GridData(4, 0x1000000, true, false));
        Binding binding = this.context.bindValue((IObservableValue)new StatusObservable(index), entry.getStatus(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        entry.setData(IBinding.class.getName(), binding);
        return entry;
    }

    private RemoteTargetEntry createTargetEntry() {
        return this.managed ? new ManagedProjectRemoteTargetEntry(this.connectionsPane, 0) : new RemoteTargetEntry(this.connectionsPane, 0);
    }

    private SyncConfig[][] prepareConfigsDelta(IProject project, SyncConfig[] syncConfigs) throws CoreException {
        HashSet<SyncConfig> removed = new HashSet<SyncConfig>(Arrays.asList(syncConfigs));
        LinkedList<SyncConfig> added = new LinkedList<SyncConfig>();
        for (RemoteTarget target : this.targets) {
            if (this.updateExistingConfig(removed, target)) continue;
            SyncConfig config = target.createConfig(project);
            target.fill(config);
            added.add(config);
        }
        return new SyncConfig[][]{added.toArray(new SyncConfig[added.size()]), removed.toArray(new SyncConfig[removed.size()])};
    }

    private void refresh(RemoteTarget newTarget) {
        Control[] entries = this.connectionsPane.getChildren();
        RemoteTargetEntry newEntry = null;
        int i = 0;
        for (RemoteTarget target : this.targets) {
            RemoteTargetEntry entry = i < entries.length ? (RemoteTargetEntry)entries[i++] : this.newEntry(i++);
            entry.setTarget(target);
            if (target != newTarget) continue;
            newEntry = entry;
        }
        while (i < entries.length) {
            Control entry = entries[i++];
            this.context.removeBinding((Binding)entry.getData(IBinding.class.getName()));
            this.statuses.remove(this.statuses.size() - 1);
            entry.dispose();
        }
        this.connectionsPane.layout();
        this.scrolledComposite.setMinSize(this.connectionsPane.computeSize(-1, -1));
        this.connections.refresh();
        if (newEntry != null) {
            newEntry.highlight();
            this.scrolledComposite.setOrigin(newEntry.getLocation());
            newEntry.setFocus();
        }
        this.updateStatus();
    }

    @Override
    public void remove(RemoteTarget remoteTarget) {
        this.targets.remove(remoteTarget);
        this.refresh(null);
    }

    private boolean restoreSelection(ComboViewer connections) {
        if (this.selectionRecursionGuard.compareAndSet(false, true)) {
            try {
                connections.setSelection((ISelection)new StructuredSelection((Object)PROMPT_SELECT_CONNECTION));
            }
            finally {
                this.selectionRecursionGuard.set(false);
            }
            return true;
        }
        return false;
    }

    public void setLocalProjectLocation(String localProjectLocation) {
        this.localProjectLocation = localProjectLocation;
    }

    public void setTargets(Collection<RemoteTarget> newTargets) {
        this.targets.clear();
        this.targets.addAll(newTargets);
        this.refresh(null);
    }

    public boolean setup(IProject project) {
        try {
            RemoteTarget local;
            SyncConfig[] configs;
            if (this.isLocalOnly()) {
                if (RemoteSyncNature.hasNature((IProject)project)) {
                    configs = SyncConfigManager.getConfigs((IProject)project);
                    SyncConfigManager.updateConfigs((IProject)project, (SyncConfig[])new SyncConfig[]{this.targets.iterator().next().createConfig(project)}, (SyncConfig[])configs);
                    SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.NONE);
                    RemoteSyncNature.removeNature((IProject)project, (String)"org.eclipse.ptp.rdt.sync.core.remoteSyncNature", (IProgressMonitor)new NullProgressMonitor());
                }
            } else {
                configs = this.prepareConfigsDelta(project, SyncConfigManager.getConfigs((IProject)project));
                SyncConfigManager.updateConfigs((IProject)project, (SyncConfig[])configs[0], (SyncConfig[])configs[1]);
                if (SyncConfigManager.getActive((IProject)project) == null) {
                    SyncConfigManager.setActive((IProject)project, (SyncConfig)RemoteTargetsList.getNewActiveConfig(project));
                }
            }
            if ((local = this.getLocalBuildTarget()) != null) {
                local.getCpu().setCpu(project);
            }
            return true;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)"Failed to setup project %s", (Object[])new Object[]{project.getName()}), 3);
            return false;
        }
    }

    protected boolean unusedConnection(IRemoteConnection element) {
        for (RemoteTarget target : this.targets) {
            if (!target.sameConnection(element)) continue;
            return false;
        }
        return true;
    }

    private boolean updateExistingConfig(Set<SyncConfig> removed, RemoteTarget target) {
        Iterator<SyncConfig> i = removed.iterator();
        while (i.hasNext()) {
            SyncConfig config = i.next();
            if (!target.isSameConfig(config)) continue;
            target.fill(config);
            i.remove();
            return true;
        }
        return false;
    }

    private void updateStatus() {
        if (this.targets.isEmpty()) {
            this.status.setValue((Object)CoreUtil.errorStatus((String)"No project build targets selected", (Object[])new Object[0]));
        } else {
            this.status.setValue((Object)CoreUtil.getMostSevereStatus((IStatus[])this.statuses.toArray(new IStatus[this.statuses.size()])));
        }
    }

    private final class ConnectionWizardDelegate
    extends ConnectionEditorDelegate {
        private ConnectionWizardDelegate() {
        }

        public boolean canDelete(IRemoteConnection connection) {
            for (RemoteTarget target : RemoteTargetsList.this.targets) {
                if (!CoreUtil.equals((Object)target.getConnectionName(), (Object)connection.getName())) continue;
                return false;
            }
            return true;
        }

        public void renamed(String name, IRemoteConnection connection) {
            for (final RemoteTarget target : RemoteTargetsList.this.targets) {
                if (!CoreUtil.equals((Object)target.getConnectionName(), (Object)name)) continue;
                final RemoteTarget newTarget = RemoteTarget.forConnection(RemoteTargetsList.this, RemoteTargetsList.this.getProjectName(), connection, null);
                newTarget.setCpu(target.getCpu());
                newTarget.setProjectLocation(target.getProjectLocation());
                RemoteTargetsList.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoteTargetsList.this.targets.add(newTarget);
                        target.remove();
                        RemoteTargetsList.this.connections.setInput((Object)RemoteTargetsList.this.getComboInput());
                        RemoteTargetsList.this.refresh(null);
                    }
                });
            }
        }

        public IRemoteConnection getSelectedConnection() {
            return null;
        }
    }

    public class ConnectionsLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof IRemoteConnection) {
                return ((IRemoteConnection)element).getName();
            }
            return element.toString();
        }
    }

    private final class StatusObservable
    extends AbstractObservableValue {
        private final int index;

        private StatusObservable(int index) {
            while (RemoteTargetsList.this.statuses.size() <= index) {
                RemoteTargetsList.this.statuses.add(null);
            }
            this.index = index;
        }

        protected Object doGetValue() {
            throw new UnsupportedOperationException();
        }

        protected void doSetValue(Object value) {
            RemoteTargetsList.this.statuses.set(this.index, (IStatus)value);
            RemoteTargetsList.this.updateStatus();
        }

        public Object getValueType() {
            return IStatus.class;
        }
    }
}

