/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.Images;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionCombo;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractRemoteTab
extends AbstractLaunchConfigurationTab {
    protected Button btnBrowseExecutable;
    protected Button[] buttonsTransfer;
    protected RemoteConnectionCombo connections;
    protected Text executable;
    protected Label lblExecutable;
    private Spinner port;
    private ServiceReference<IRemoteConnectionsService> reference;
    private IRemoteConnectionsService remoteConnectionsService;
    private int suspendValidation = 0;
    private boolean valid = false;

    protected abstract void apply(ILaunchConfigurationWorkingCopy var1);

    protected void browseForRemoteExe() {
        final IRemoteConnection connection = this.connections.getSelection();
        if (connection != null) {
            try {
                Shell shell = this.getShell();
                String path = this.executable.getText();
                this.getLaunchConfigurationDialog().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            connection.connect(IRemoteConnection.Service.Files, monitor);
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle(e.getStatus(), 3);
                        }
                    }
                });
                String newPath = connection.browse(shell, Messages.RemoteExecutableTab_dialog_browse_executable, path);
                if (newPath != null) {
                    this.executable.setText(newPath);
                }
            }
            catch (InvocationTargetException e) {
                Activator.log(e);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public boolean canSave() {
        return this.valid;
    }

    protected abstract void connectionSelected(IStructuredSelection var1);

    protected final Button createButton(Composite composite, String label, ICudaRemoteDebugConstants.ExecutableTransferMode mode) {
        Button button = new Button(composite, 16);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRemoteTab.this.modeChanged();
            }
        });
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        button.setText(label);
        button.setData((Object)mode);
        return button;
    }

    protected final void createButtons(Composite pane) {
        Composite composite = new Composite(pane, 0);
        this.buttonsTransfer = this.createTransferButtons(composite);
        GridLayout gl_composite = new GridLayout(this.buttonsTransfer.length, true);
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 3, 1));
    }

    protected final void createConnectionsCombo(Composite pane) {
        Label lblRemoteConnection = new Label(pane, 0);
        lblRemoteConnection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblRemoteConnection.setText(Messages.RemoteDebug_firstWizardPage_remoteConnectionLabel);
        this.connections = new RemoteConnectionCombo(pane);
        this.connections.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractRemoteTab.this.selectConnection((IStructuredSelection)event.getSelection());
            }
        });
        Control connectionsCombo = this.connections.getControl();
        connectionsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnNewButton = new Button(pane, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRemoteTab.this.connections.manage();
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNewButton.setText(Messages.RemoteDebug_firstWizardPage_buttonNew);
    }

    protected final void createPortEntry(Composite pane) {
        Label lblDebuggerPort = new Label(pane, 0);
        lblDebuggerPort.setText(Messages.RemoteExecutableTab_label_port);
        this.port = new Spinner(pane, 2048);
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRemoteTab.this.validate();
            }
        });
        this.port.setMaximum(65535);
        this.port.setMinimum(1);
        new Label(pane, 0);
    }

    protected final void createRemoteExecutableEntry(Composite pane) {
        this.lblExecutable = new Label(pane, 0);
        this.lblExecutable.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblExecutable.setText(Messages.RemoteExecutableTab_label_executable);
        this.executable = new Text(pane, 2048);
        this.executable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRemoteTab.this.validate();
            }
        });
        GridData gd_executable = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_executable.widthHint = 50;
        this.executable.setLayoutData((Object)gd_executable);
        this.btnBrowseExecutable = new Button(pane, 0);
        this.btnBrowseExecutable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRemoteTab.this.browseForRemoteExe();
            }
        });
        this.btnBrowseExecutable.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnBrowseExecutable.setText(Messages.RemoteDebug_buttonBrowse);
    }

    protected abstract Button[] createTransferButtons(Composite var1);

    public void dispose() {
        if (this.reference != null) {
            BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
            bundleContext.ungetService(this.reference);
        }
        super.dispose();
    }

    public String getId() {
        return this.getPageId();
    }

    public Image getImage() {
        return Images.Remote_Tab.getImage();
    }

    public String getName() {
        return Messages.RemoteExecutableTab_name;
    }

    protected abstract String getPageId();

    protected final synchronized IRemoteConnectionsService getRemoteConnectionService() {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        if (this.reference == null) {
            this.reference = bundleContext.getServiceReference(IRemoteConnectionsService.class);
            this.remoteConnectionsService = (IRemoteConnectionsService)bundleContext.getService(this.reference);
        }
        return this.remoteConnectionsService;
    }

    protected final ICudaRemoteDebugConstants.ExecutableTransferMode getSelectedMode() {
        Button[] buttonArray = this.buttonsTransfer;
        int n = this.buttonsTransfer.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            if (button.getSelection()) {
                return (ICudaRemoteDebugConstants.ExecutableTransferMode)((Object)button.getData());
            }
            ++n2;
        }
        return null;
    }

    protected ICudaRemoteDebugConstants.ExecutableTransferMode getSelectedTransfer(ICudaRemoteDebugConstants.ExecutableTransferMode selectedMode) {
        return selectedMode == null ? ICudaRemoteDebugConstants.ExecutableTransferMode.Notransfer : selectedMode;
    }

    protected ICudaRemoteDebugConstants.ExecutableTransferMode getLaunchConfigurationTransferMode(ILaunchConfiguration config) {
        return ICudaRemoteDebugConstants.ExecutableTransferMode.fromLaunchConfiguration(config);
    }

    protected boolean ignoreExecutable() {
        return false;
    }

    protected abstract void initialize(ILaunchConfiguration var1, IRemoteConnection var2) throws CoreException;

    public void initializeFrom(ILaunchConfiguration config) {
        block9: {
            try {
                try {
                    IRemoteConnection remoteConnection;
                    String connection;
                    ++this.suspendValidation;
                    this.executable.setText(config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, ""));
                    ICudaRemoteDebugConstants.ExecutableTransferMode mode = this.getLaunchConfigurationTransferMode(config);
                    Button[] buttonArray = this.buttonsTransfer;
                    int n = this.buttonsTransfer.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button button;
                        button.setSelection(mode == (button = buttonArray[n2]).getData());
                        ++n2;
                    }
                    if (this.port != null) {
                        Integer p = Integer.valueOf(config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345"));
                        this.port.setSelection(p.intValue());
                    }
                    if (!CoreUtil.isNullOrEmpty((String)(connection = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, null)))) {
                        remoteConnection = IRemoteConnectionsService.GetConnection.getConnection((String)connection, (IProgressMonitor)new NullProgressMonitor());
                        this.connections.setSelection(remoteConnection);
                    } else {
                        remoteConnection = null;
                    }
                    this.initialize(config, remoteConnection);
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)"Failed to load launch configuration attributes", (Object[])new Object[0]), 3);
                    --this.suspendValidation;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                --this.suspendValidation;
                throw throwable;
            }
            --this.suspendValidation;
        }
        this.validate();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.canSave();
    }

    protected void modeChanged() {
        this.validate();
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        IRemoteConnection conn;
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, this.executable.getText());
        if (this.port != null) {
            config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, String.valueOf(this.port.getSelection()));
        }
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, (conn = this.connections.getSelection()) != null ? conn.getName() : null);
        ICudaRemoteDebugConstants.ExecutableTransferMode selectedMode = this.getSelectedMode();
        config.setAttribute(ICudaRemoteDebugConstants.ATTRIBUTE_EXECUTABLE_TRANSFER, this.getSelectedTransfer(selectedMode).name());
        this.apply(config);
    }

    protected void selectConnection(IStructuredSelection selection) {
        boolean enabled = !selection.isEmpty();
        this.btnBrowseExecutable.setEnabled(enabled);
        this.connectionSelected(selection);
        this.validate();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(ICudaRemoteDebugConstants.ATTRIBUTE_EXECUTABLE_TRANSFER, ICudaRemoteDebugConstants.ExecutableTransferMode.Upload.name());
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
    }

    protected final void validate() {
        if (this.executable != null && this.suspendValidation == 0) {
            String message = null;
            IRemoteConnection connection = this.connections.getSelection();
            if (connection == null) {
                message = Messages.RemoteDebug_error_remote_connection_not_selected;
            } else {
                String exe = this.executable.getText();
                message = !this.ignoreExecutable() && CoreUtil.isNullOrEmpty((String)exe) ? Messages.RemoteExecutableTab_error_no_executable_selected : this.validateChild();
            }
            this.valid = message == null;
            this.setErrorMessage(message);
            this.updateLaunchConfigurationDialog();
        }
    }

    protected abstract String validateChild();
}

