/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.build;

import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.ui.build.BuildConfigurationsMenuBuilder;
import com.nvidia.cuda.ide.remote.internal.ui.build.PlainLabelContributionItem;
import org.eclipse.cdt.internal.ui.cview.BuildGroup;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public final class BuildConfigurationsMenu
extends ExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        ISelectionService service = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        IPartService partService = (IPartService)serviceLocator.getService(IPartService.class);
        final IWorkbenchWindow window = (IWorkbenchWindow)serviceLocator.getService(IWorkbenchWindow.class);
        final IProject project = BuildConfigurationsMenuBuilder.getSelectedProject(service.getSelection(), partService.getActivePart(), window);
        if (project != null) {
            IAction[] menu;
            IAction[] iActionArray = menu = new BuildConfigurationsMenuBuilder(){

                @Override
                protected IAction createMenuItem(String label, SyncConfig target, String configuration) {
                    return new BuildProject(label, project, window, target, configuration);
                }
            }.buildMenu(project);
            int n = menu.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                additions.addContributionItem((IContributionItem)new PlainLabelContributionItem(action), null);
                ++n2;
            }
        }
    }

    private static final class BuildProject
    extends Action {
        private final String configuration;
        private final IProject project;
        private final SyncConfig syncConfig;
        private final IWorkbenchWindow window;

        private BuildProject(String label, IProject project, IWorkbenchWindow window, SyncConfig syncConfig, String configuration) {
            super(label, 32);
            this.project = project;
            this.window = window;
            this.syncConfig = syncConfig;
            this.configuration = configuration;
        }

        public void run() {
            try {
                if (this.window.getWorkbench().saveAllEditors(true)) {
                    this.buildProject(this.window, this.project, this.syncConfig, this.configuration);
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }

        private void buildProject(IWorkbenchWindow window, IProject project, SyncConfig syncConfig, String configuration) throws CoreException {
            BuildConfigurationsMenuBuilder.updateCurrentBuildConfigurationAndTarget(project, syncConfig, configuration);
            BuildGroup.CDTBuildAction action = new BuildGroup.CDTBuildAction((IShellProvider)window, 10);
            action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)project));
            action.run();
        }
    }
}

