/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.factory;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.util.Date;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.util.CDateTime;

public class DateFormatWrapperFactory {
    private DateFormatWrapperFactory() {
    }

    public static final IDateFormatWrapper getPreferredDateFormat(int iUnit) {
        return DateFormatWrapperFactory.getPreferredDateFormat(iUnit, ULocale.getDefault());
    }

    public static final IDateFormatWrapper getPreferredDateFormat(int iUnit, ULocale locale) {
        return DateFormatWrapperFactory.getPreferredDateFormat(iUnit, locale, true);
    }

    public static final IDateFormatWrapper getPreferredDateFormat(int iUnit, ULocale locale, boolean keepHierarchy) {
        IDateFormatWrapper df = null;
        switch (iUnit) {
            case 1: {
                df = new CommonDateFormatWrapper((DateFormat)new SimpleDateFormat("yyyy", locale));
                break;
            }
            case 6: {
                df = new CommonDateFormatWrapper((DateFormat)new SimpleDateFormat(keepHierarchy ? "yyyy QQQ" : "QQQ", locale));
                break;
            }
            case 2: {
                if (keepHierarchy) {
                    df = new MonthDateFormat(locale);
                    break;
                }
                df = new CommonDateFormatWrapper((DateFormat)new SimpleDateFormat("MMM", locale));
                break;
            }
            case 3: 
            case 5: {
                df = new CommonDateFormatWrapper(DateFormat.getDateInstance((int)2, (ULocale)locale));
                break;
            }
            case 11: {
                df = new CommonDateFormatWrapper((DateFormat)new SimpleDateFormat("HH:mm", locale));
                break;
            }
            case 12: 
            case 13: {
                df = new CommonDateFormatWrapper((DateFormat)new SimpleDateFormat("HH:mm:ss", locale));
            }
        }
        return df;
    }

    static class CommonDateFormatWrapper
    implements IDateFormatWrapper {
        private DateFormat formater;

        public CommonDateFormatWrapper(DateFormat formater) {
            this.formater = formater;
        }

        public String format(Date date) {
            return this.formater.format(date);
        }

        public String format(CDateTime calendar) {
            if (calendar.isFullDateTime()) {
                this.formater.setTimeZone(calendar.getTimeZone());
            }
            return this.format(calendar.getTime());
        }

        public String toLocalizedPattern() {
            if (this.formater instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)this.formater).toLocalizedPattern();
            }
            return "MMM d, yyyy h:mm:ss a";
        }
    }

    static class HourDateFormat
    implements IDateFormatWrapper {
        private ULocale locale;
        private TimeZone tz;

        public HourDateFormat(ULocale locale) {
            this.locale = locale;
        }

        public String format(Date date) {
            StringBuffer sb = new StringBuffer();
            DateFormat df = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
            if (this.tz != null) {
                df.setTimeZone(this.tz);
            }
            sb.append(df.format(date));
            sb.append("\n");
            df = new SimpleDateFormat("HH:mm", this.locale);
            if (this.tz != null) {
                df.setTimeZone(this.tz);
            }
            sb.append(df.format(date));
            return sb.toString();
        }

        public String format(CDateTime calendar) {
            if (calendar.isFullDateTime()) {
                this.tz = calendar.getTimeZone();
            }
            return this.format(calendar.getTime());
        }

        public String toLocalizedPattern() {
            DateFormat df = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
            if (df instanceof SimpleDateFormat) {
                return String.valueOf(((SimpleDateFormat)df).toLocalizedPattern()) + "\n" + new SimpleDateFormat("HH:mm", this.locale).toLocalizedPattern();
            }
            return "MMMM d, yyyy HH:mm";
        }
    }

    static class MonthDateFormat
    implements IDateFormatWrapper {
        private ULocale locale;
        private TimeZone tz;

        public MonthDateFormat(ULocale locale) {
            this.locale = locale;
        }

        public String format(Date date) {
            StringBuffer str = new StringBuffer();
            FieldPosition pos = new FieldPosition(3);
            DateFormat df = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
            if (this.tz != null) {
                df.setTimeZone(this.tz);
            }
            df.format(date, str, pos);
            int endIndex = pos.getEndIndex() >= str.length() ? pos.getEndIndex() : pos.getEndIndex() + (str.charAt(pos.getEndIndex()) == ',' ? 2 : 1);
            if (endIndex >= str.length()) {
                return str.substring(0, pos.getBeginIndex()).trim();
            }
            return String.valueOf(str.substring(0, pos.getBeginIndex())) + str.substring(endIndex);
        }

        public String format(CDateTime calendar) {
            if (calendar.isFullDateTime()) {
                this.tz = calendar.getTimeZone();
            }
            return this.format(calendar.getTime());
        }

        public String toLocalizedPattern() {
            DateFormat df = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
            if (df instanceof SimpleDateFormat) {
                String pattern = ((SimpleDateFormat)df).toLocalizedPattern();
                return pattern.replaceAll("(-|/)?d+(\\.|,|/|-)?\\s?", "").trim();
            }
            return "MMM yyyy";
        }
    }
}

