/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.EllipsisHelper;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.Rectangle;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.ScaleContext;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.AxisOrigin;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.data.BigNumberDataElement;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.BigNumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoScale
extends Methods
implements Cloneable {
    private AxisLabelInfo axisLabelInfo = new AxisLabelInfo();
    private final ScaleInfo info;
    private ScaleContext context;
    public static String KEY_SHARED_MINMAX = "SharedMinMax";
    private double dStartShift;
    private double dEndShift;
    private double dStart;
    private double dEnd;
    private AxisTickCoordinates atcTickCoordinates;
    private LabelVisibleHelper labelVisHelper = null;
    private Map<Integer, String> hmComputedLabelText = null;
    private StaggeredHelper staggeredHelper = null;
    private ScaleContext tmpSC;
    private static final int TICKS_MAX = 1000;
    private static final NumberFormat dfDoulbeNormalized = NumberFormat.getInstance((Locale)Locale.ENGLISH);
    private static int[] iaLinearDeltas;
    private static int[] iaLogarithmicDeltas;
    private static int[] iaCalendarUnits;
    private static int[] iaSecondDeltas;
    private static int[] iaMinuteDeltas;
    private static int[] iaHourDeltas;
    private static int[] iaDayDeltas;
    private static int[] iaMonthDeltas;
    private static int[][] iaCalendarDeltas;
    private static ILogger logger;
    private boolean bIsBigNumber;
    private BigDecimal bigNumberDivisor;
    private static final BigDecimal UPER_LIMIT;

    static {
        try {
            ((DecimalFormat)dfDoulbeNormalized).applyPattern(".###############E0");
        }
        catch (ClassCastException classCastException) {}
        iaLinearDeltas = new int[]{1, 2, 5, 10};
        iaLogarithmicDeltas = new int[]{10};
        iaCalendarUnits = new int[]{13, 12, 11, 5, 2, 1, 6};
        iaSecondDeltas = new int[]{1, 5, 10, 15, 20, 30};
        iaMinuteDeltas = new int[]{1, 5, 10, 15, 20, 30};
        iaHourDeltas = new int[]{1, 2, 3, 4, 12};
        iaDayDeltas = new int[]{1, 7, 14};
        iaMonthDeltas = new int[]{1, 2, 3, 4, 6};
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = iaSecondDeltas;
        nArrayArray[1] = iaMinuteDeltas;
        nArrayArray[2] = iaHourDeltas;
        nArrayArray[3] = iaDayDeltas;
        nArrayArray[4] = iaMonthDeltas;
        iaCalendarDeltas = nArrayArray;
        logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation.withaxes");
        UPER_LIMIT = new BigDecimal("1E9");
    }

    AxisLabelInfo getAxisLabelInfo() {
        return this.axisLabelInfo;
    }

    public AutoScale(ScaleInfo info) {
        this(info, new ScaleContext(info.iMarginPercent, info.type));
    }

    public AutoScale(ScaleInfo info, ScaleContext context) {
        this.info = info;
        this.context = context;
    }

    public int getDirection() {
        return this.info.iScaleDirection;
    }

    public final Object clone() {
        AutoScale sc = new AutoScale(this.info);
        sc.context = this.context.copy();
        sc.dStart = this.dStart;
        sc.dEnd = this.dEnd;
        sc.dStartShift = this.dStartShift;
        sc.dEndShift = this.dEndShift;
        sc.atcTickCoordinates = this.atcTickCoordinates;
        sc.labelVisHelper = this.labelVisHelper;
        sc.staggeredHelper = this.staggeredHelper;
        sc.hmComputedLabelText = this.hmComputedLabelText;
        sc.tmpSC = this.tmpSC;
        sc.axisLabelInfo = this.axisLabelInfo;
        sc.setBigNubmerDivisor(this.getBigNumberDivisor());
        return sc;
    }

    public final boolean zoomIn() {
        block22: {
            block19: {
                double dStep;
                block20: {
                    double dStep2;
                    block21: {
                        if (this.info.bStepFixed) {
                            return false;
                        }
                        if (ChartUtil.mathEqual(0.0, ((Number)this.context.getStep()).doubleValue(), this.isBigNumber())) {
                            return false;
                        }
                        if ((this.info.type & 1) != 1) break block19;
                        if ((this.info.type & 4) != 4) break block20;
                        dStep2 = AutoScale.asDouble(this.context.getStep());
                        if (!(Math.log(dStep2) / LOG_10 > 1.0)) break block21;
                        this.setStep(new Double(dStep2 / 10.0));
                        break block22;
                    }
                    int n = iaLogarithmicDeltas.length;
                    int i = n - 1;
                    while (i >= 0) {
                        if ((int)dStep2 == iaLogarithmicDeltas[i]) {
                            if (i > 0) {
                                this.setStep(new Double(iaLogarithmicDeltas[i - 1]));
                                return true;
                            }
                            return false;
                        }
                        --i;
                    }
                    return false;
                }
                if ((this.info.type & 2) != 2) break block22;
                double oldStep = dStep = AutoScale.asDouble(this.context.getStep()).doubleValue();
                double dPower = Math.log(dStep) / LOG_10;
                dPower = Math.floor(dPower);
                dPower = Math.pow(10.0, dPower);
                dStep /= dPower;
                dStep = Math.round(dStep);
                int n = iaLinearDeltas.length;
                int i = 0;
                while (i < n) {
                    if ((int)dStep == iaLinearDeltas[i]) {
                        if (i > 0) {
                            dStep = (double)iaLinearDeltas[i - 1] * dPower;
                            break;
                        }
                        dStep = (double)iaLinearDeltas[n - 2] * (dPower /= 10.0);
                        break;
                    }
                    ++i;
                }
                if (ChartUtil.mathEqual(dStep, oldStep, this.isBigNumber())) {
                    dStep /= 2.0;
                }
                this.setStep(new Double(dStep));
                if (((Number)this.context.getStep()).doubleValue() < this.info.dPrecision) {
                    this.setStep(oldStep);
                    return false;
                }
                break block22;
            }
            if ((this.info.type & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(this.context.getStep());
                int iUnit = AutoScale.asInteger(this.context.getUnit());
                int icu = 0;
                while (icu < iaCalendarUnits.length) {
                    if (iUnit == iaCalendarUnits[icu]) {
                        ia = iaCalendarDeltas[icu];
                        if (ia == null) {
                            if (--iStep == 0) {
                                this.setStep(iaMonthDeltas[iaMonthDeltas.length - 1]);
                                this.context.setUnit(2);
                            }
                        } else {
                            int i = 0;
                            while (i < ia.length) {
                                if (ia[i] == iStep) break;
                                ++i;
                            }
                            if (i == 0) {
                                if (icu <= this.info.iMinUnit) {
                                    return false;
                                }
                                ia = iaCalendarDeltas[icu - 1];
                                i = ia.length;
                                this.context.setUnit(iaCalendarUnits[icu - 1]);
                            }
                            this.setStep(ia[i - 1]);
                            break;
                        }
                    }
                    ++icu;
                }
            }
        }
        return true;
    }

    public final boolean zoomOut() {
        block22: {
            Object oStep;
            block19: {
                block20: {
                    double dStep;
                    block21: {
                        if (this.info.bStepFixed || this.getTickCordinates().size() < 3) {
                            return false;
                        }
                        oStep = this.context.getStep();
                        if (((Number)oStep).doubleValue() >= Double.MAX_VALUE) {
                            return false;
                        }
                        if ((this.info.type & 1) != 1) break block19;
                        if ((this.info.type & 4) != 4) break block20;
                        dStep = AutoScale.asDouble(oStep);
                        if (!(Math.log(dStep) / LOG_10 >= 1.0)) break block21;
                        this.setStep(new Double(dStep * 10.0));
                        break block22;
                    }
                    int n = iaLogarithmicDeltas.length;
                    int i = 0;
                    while (i < n) {
                        if ((int)dStep == iaLogarithmicDeltas[i]) {
                            this.setStep(new Double(iaLogarithmicDeltas[i + 1]));
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                if ((this.info.type & 2) != 2) break block22;
                if (AutoScale.asDouble(this.context.getMin()) * AutoScale.asDouble(this.context.getMax()) < 0.0 && this.getTickCordinates().size() <= 3) {
                    return false;
                }
                double dStep = AutoScale.asDouble(oStep);
                double dPower = Math.log10(dStep);
                if (dPower < 0.0) {
                    dPower = Math.floor(dPower);
                    dPower = Math.pow(10.0, dPower);
                } else {
                    dPower = dStep;
                }
                dStep /= dPower;
                dStep = Math.round(dStep);
                int n = iaLinearDeltas.length;
                int i = 0;
                while (i < n) {
                    if (dStep < (double)iaLinearDeltas[i]) {
                        dStep = (double)iaLinearDeltas[i] * dPower;
                        break;
                    }
                    ++i;
                }
                if (i == n) {
                    dStep = (double)iaLinearDeltas[0] * (dPower *= 20.0);
                }
                if (ChartUtil.mathEqual(((Number)oStep).doubleValue(), dStep, this.isBigNumber())) {
                    return false;
                }
                dStep = ChartUtil.alignWithInt(dStep, false);
                this.setStep(new Double(dStep));
                break block22;
            }
            if ((this.info.type & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(oStep);
                int iUnit = AutoScale.asInteger(this.context.getUnit());
                int icu = 0;
                while (icu < iaCalendarUnits.length) {
                    if (iUnit == iaCalendarUnits[icu]) {
                        ia = iaCalendarDeltas[icu];
                        if (ia == null) {
                            this.setStep(++iStep);
                        } else {
                            int i = 0;
                            int n = ia.length;
                            while (i < n) {
                                if (ia[i] == iStep) break;
                                ++i;
                            }
                            if (i == n - 1) {
                                ia = iaCalendarDeltas[icu + 1];
                                this.context.setUnit(iaCalendarUnits[icu + 1]);
                                if (ia == null) {
                                    this.setStep(1);
                                    return true;
                                }
                                i = -1;
                            }
                            this.setStep(ia[i + 1]);
                            break;
                        }
                    }
                    ++icu;
                }
            }
        }
        return true;
    }

    public final String getNumericPattern() {
        Object oStep = this.context.getStep();
        if (this.context.getMin() == null || oStep == null) {
            return "0.00";
        }
        Number nMinValue = (Number)this.context.getMin();
        Number nStep = (Number)oStep;
        if ((this.info.type & 4) == 4) {
            return ValueFormatter.getNumericPattern(nMinValue);
        }
        return ValueFormatter.getNumericPattern(nStep);
    }

    public final int getType() {
        return this.info.type;
    }

    public final void setData(DataSetIterator _oaData) {
        this.info.dsiData(_oaData);
    }

    public final FormatSpecifier getFormatSpecifier() {
        return this.info.fs;
    }

    public final Object getUnit() {
        return this.context.getUnit();
    }

    public final DataSetIterator getData() {
        return this.info.dsiData;
    }

    final void setTickCordinates(AxisTickCoordinates atc) {
        if (atc != null && atc.size() == 1 && !this.isSetFactor()) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.tick.computations", Messages.getResourceBundle(this.info.rtc.getULocale()))));
        }
        this.atcTickCoordinates = atc;
    }

    public final boolean isTickLabelVisible(int index) {
        assert (this.labelVisHelper != null);
        return this.labelVisHelper.isTickLabelVisible(index);
    }

    public final String getComputedLabelText(int index) {
        assert (this.hmComputedLabelText != null);
        return this.hmComputedLabelText.get(index);
    }

    public final Collection<Integer> getVisibleLabelIds() {
        return this.hmComputedLabelText.keySet();
    }

    public final boolean isTickLabelStaggered(int index) {
        if (this.staggeredHelper == null) {
            this.staggeredHelper = StaggeredHelper.createInstance(this.isAxisLabelStaggered(), this.atcTickCoordinates.size(), this.info.iLabelShowingInterval);
        }
        return this.staggeredHelper.isTickLabelStaggered(index);
    }

    public final boolean isAxisLabelStaggered() {
        return this.info.bAxisLabelStaggered;
    }

    public final boolean isTickBetweenCategories() {
        return this.info.bTickBetweenCategories;
    }

    public final AxisTickCoordinates getTickCordinates() {
        return this.atcTickCoordinates;
    }

    public final double getNormalizedStart() {
        return 0.0;
    }

    public final double getNormalizedEnd() {
        return this.dEnd - this.dStart;
    }

    public final double[] getNormalizedEndPoints() {
        return new double[]{0.0, this.dEnd - this.dStart};
    }

    public final double[] getEndPoints() {
        return new double[]{this.dStart, this.dEnd};
    }

    final void setEndPoints(double _dStart, double _dEnd) {
        if (_dStart != -1.0) {
            this.dStart = _dStart;
        }
        if (_dEnd != -1.0) {
            this.dEnd = _dEnd;
        }
        if (this.atcTickCoordinates != null) {
            this.atcTickCoordinates.setEndPoints(this.dStart, this.dEnd);
        }
    }

    private void checkValible(double dValue, String sName) throws ChartException {
        if (Double.isInfinite(dValue)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, String.valueOf(sName) + Messages.getString("AutoScale.Exception.IsInfiite"), Messages.getResourceBundle(this.info.rtc.getULocale()));
        }
        if (Double.isNaN(dValue)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, String.valueOf(sName) + Messages.getString("AutoScale.Exception.IsNaN"), Messages.getResourceBundle(this.info.rtc.getULocale()));
        }
    }

    public final int getTickCount() throws ChartException {
        if (this.context.getStepNumber() != null) {
            if (this.info.bCategoryScale || (this.info.type & 1) != 1) {
                logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unsupported.step.number", Messages.getResourceBundle(this.info.rtc.getULocale()))));
            } else {
                return this.context.getStepNumber() + 1;
            }
        }
        Object oStep = this.context.getStep();
        int nTicks = 2;
        if (this.isCategoryScale()) {
            if (this.info.dsiData != null) {
                nTicks = this.info.dsiData.size() + 1;
                if (!this.info.bTickBetweenCategories) {
                    ++nTicks;
                }
            }
        } else if ((this.info.type & 1) == 1) {
            if ((this.info.type & 2) == 2) {
                double dMax = AutoScale.asDouble(this.context.getMax());
                double dMin = AutoScale.asDouble(this.context.getMin());
                double dStep = AutoScale.asDouble(oStep);
                if (!ChartUtil.mathEqual(dMax, dMin, this.isBigNumber())) {
                    double lNTicks = Math.ceil((dMax - dMin) / dStep - 0.5) + 1.0;
                    if (lNTicks > 1000.0 || lNTicks < 2.0) {
                        nTicks = lNTicks > 1000.0 ? 1000 : 2;
                        dStep = dMax / (double)(nTicks - 1) - dMin / (double)(nTicks - 1);
                        this.checkValible(dStep, Messages.getString("AutoScale.ValueName.StepSize"));
                        dStep = ChartUtil.alignWithInt(dStep, true);
                        this.setStep(new Double(dStep));
                    } else {
                        nTicks = (int)lNTicks;
                    }
                } else {
                    nTicks = 5;
                }
            } else if ((this.info.type & 4) == 4) {
                double dMax = AutoScale.asDouble(this.context.getMax());
                double dMin = AutoScale.asDouble(this.context.getMin());
                double dStep = AutoScale.asDouble(oStep);
                double dMaxLog = Math.log(dMax) / LOG_10;
                double dMinLog = Math.log(dMin) / LOG_10;
                double dStepLog = Math.log(dStep) / LOG_10;
                nTicks = (int)Math.ceil((dMaxLog - dMinLog) / dStepLog) + 1;
            }
        } else if ((this.info.type & 8) == 8) {
            CDateTime cdt1 = (CDateTime)((Object)this.context.getMin());
            CDateTime cdt2 = (CDateTime)((Object)this.context.getMax());
            double diff = CDateTime.computeDifference(cdt2, cdt1, AutoScale.asInteger(this.context.getUnit())) / (double)AutoScale.asInteger(oStep);
            nTicks = (int)Math.round(diff) + 1;
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unknown.axis.type.tick.computations", Messages.getResourceBundle(this.info.rtc.getULocale()));
        }
        if (nTicks < 2) {
            nTicks = 2;
        }
        return nTicks;
    }

    public final double getUnitSize() {
        if (this.atcTickCoordinates == null) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.unit.size.failure", Messages.getResourceBundle(this.info.rtc.getULocale()))));
        }
        return Math.abs(this.atcTickCoordinates.getStep());
    }

    public final Object getMinimum() {
        return this.context.getMin();
    }

    public final void setMinimum(Object o) {
        this.context.setMin(o);
    }

    public final Object getMaximum() {
        return this.context.getMax();
    }

    public final void setMaximum(Object o) {
        this.context.setMax(o);
    }

    public final Object getStep() {
        return this.context.getStep();
    }

    public final void setStep(Object o) {
        this.context.setStep(o);
    }

    public final Integer getStepNumber() {
        return this.context.getStepNumber();
    }

    public final void setStepNumber(Integer o) {
        this.context.setStepNumber(o);
    }

    public final double getFactor() {
        return this.info.dFactor;
    }

    public final boolean isSetFactor() {
        return !(this.info.dFactor < 0.0);
    }

    final Object[] getMinMax() throws ChartException {
        Object oValue = null;
        try {
            if ((this.info.type & 1) == 1) {
                double dMinValue = Double.MAX_VALUE;
                double dMaxValue = -1.7976931348623157E308;
                this.info.dsiData.reset();
                while (this.info.dsiData.hasNext()) {
                    oValue = this.info.dsiData.next();
                    if (oValue == null) continue;
                    double dValue = NumberUtil.isBigNumber(oValue) ? ((BigNumber)oValue).doubleValue() : ((Double)oValue).doubleValue();
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
                return new Object[]{new Double(dMinValue), new Double(dMaxValue)};
            }
            if ((this.info.type & 8) == 8) {
                Calendar caMin = null;
                Calendar caMax = null;
                this.info.dsiData.reset();
                while (this.info.dsiData.hasNext()) {
                    oValue = this.info.dsiData.next();
                    Calendar cValue = (Calendar)oValue;
                    if (caMin == null) {
                        caMin = cValue;
                    }
                    if (caMax == null) {
                        caMax = cValue;
                    }
                    if (cValue == null) continue;
                    if (cValue.before((Object)caMin)) {
                        caMin = cValue;
                        continue;
                    }
                    if (!cValue.after((Object)caMax)) continue;
                    caMax = cValue;
                }
                return new Object[]{new CDateTime(caMin), new CDateTime(caMax)};
            }
        }
        catch (ClassCastException classCastException) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.axis.data.type", new Object[]{oValue}, Messages.getResourceBundle(this.info.rtc.getULocale()));
        }
        return null;
    }

    public final void updateAxisMinMax(Object oMinValue, Object oMaxValue) {
        ScaleContext sct;
        if (this.info.rtc.getSharedScale() != null && this.info.rtc.getSharedScale().isShared()) {
            this.updateContext(this.info.rtc.getSharedScale().getScaleContext());
            return;
        }
        if ((this.info.type & 4) == 4) {
            if ((this.info.type & 0x20) == 32) {
                this.context.setMax(100.0);
                this.context.setMin(1.0);
                this.setStep(new Double(10.0));
                this.info.bMaximumFixed(true);
                this.info.bMinimumFixed(true);
                this.info.bStepFixed(true);
                return;
            }
            sct = new ScaleContext(this.info.iMarginPercent, this.info.type, oMinValue, oMaxValue, this.context.getStep());
        } else if ((this.info.type & 8) == 8) {
            int iUnit = AutoScale.asInteger(this.context.getUnit());
            sct = new ScaleContext(this.info.iMarginPercent, this.info.type, iUnit, oMinValue, oMaxValue, this.context.getStep());
        } else {
            sct = new ScaleContext(this.info.iMarginPercent, this.info.type, oMinValue, oMaxValue, this.context.getStep());
        }
        if ((this.info.type & 8) == 8) {
            sct.setFixedValue(this.info.bMinimumFixed, this.info.bMaximumFixed, this.info.oMinimumFixed, this.info.oMaximumFixed);
        } else {
            sct.setFixedValue(this.info.bMinimumFixed, this.info.bMaximumFixed, this.context.getMin(), this.context.getMax());
        }
        sct.setExpandMinmax(this.info.bExpandMinMax);
        sct.setFixedStep(this.info.bStepFixed, this.context.getStepNumber());
        sct.computeMinMax(this.info.bAlignZero);
        this.updateContext(sct);
        this.tmpSC = sct;
        AutoScale.updateSharedScaleContext(this.info.rtc, this.info.type, this.tmpSC);
    }

    private final void updateContext(ScaleContext sct) {
        this.context.setMax(sct.getMax());
        this.context.setMin(sct.getMin());
        this.context.setMaxWithMargin(sct.getMaxWithMargin());
        this.context.setMinWithMargin(sct.getMinWithMargin());
        this.context.setStep(sct.getStep());
        this.context.setUnit(sct.getUnit());
    }

    Object getMinWithMargin() {
        return this.context.getMinWithMargin();
    }

    Object getMaxWithMargin() {
        return this.context.getMaxWithMargin();
    }

    public final boolean checkFit(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        block35: {
            Double fontHeight;
            RotatedRectangle rrPrev2;
            RotatedRectangle rrPrev;
            AxisTickCoordinates da;
            int iPointToCheck;
            double y;
            double x;
            block36: {
                block34: {
                    if (this.isCategoryScale()) {
                        return true;
                    }
                    double dAngleInDegrees = la.getCaption().getFont().getRotation();
                    x = 0.0;
                    y = 0.0;
                    iPointToCheck = 0;
                    if (iLabelLocation == 4 || iLabelLocation == 8) {
                        iPointToCheck = this.info.iScaleDirection == -1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 1 : 2) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 3 : 0);
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        iPointToCheck = this.info.iScaleDirection == 1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 0 : 1) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 2 : 3);
                    }
                    da = this.atcTickCoordinates;
                    rrPrev = null;
                    rrPrev2 = null;
                    fontHeight = this.info.cComp.computeFontHeight(xs, la);
                    if ((this.info.type & 3) != 3) break block34;
                    double dAxisValue = AutoScale.asDouble(this.getMinimum());
                    double dAxisStep = AutoScale.asDouble(this.getStep());
                    DecimalFormat df = null;
                    AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                    NumberDataElement nde = NumberDataElementImpl.create(0.0);
                    int i = 0;
                    while (i < da.size()) {
                        df = avi.getDecimalFormat();
                        Object value = avi.getValue(nde);
                        String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                        if (iLabelLocation == 4 || iLabelLocation == 8) {
                            x = da.getCoordinate(i) * this.info.dZoomFactor;
                        } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                            y = da.getCoordinate(i) * this.info.dZoomFactor;
                        }
                        la.getCaption().setValue(sText);
                        RotatedRectangle rr = this.info.cComp.computePolygon(xs, iLabelLocation, la, x, y, fontHeight);
                        if (i == 0 && this.info.bLabelWithinAxes) {
                            Rectangle rect = rr.getBounds();
                            if (iLabelLocation == 4 || iLabelLocation == 8) {
                                rr.shiftXVertices(rect.getWidth() / 2.0);
                            } else {
                                rr.shiftYVertices(-rect.getHeight() / 2.0);
                            }
                        }
                        Point p = rr.getPoint(iPointToCheck);
                        if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                            if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                                return false;
                            }
                            rrPrev2 = rr;
                        } else {
                            if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev))) {
                                return false;
                            }
                            rrPrev = rr;
                        }
                        avi.addStep();
                        ++i;
                    }
                    break block35;
                }
                if ((this.info.type & 5) != 5) break block36;
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                DecimalFormat df = null;
                AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                int i = 0;
                while (i < da.size() - 1) {
                    df = avi.getDecimalFormat();
                    Object value = avi.getValue(nde);
                    String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                    if (iLabelLocation == 4 || iLabelLocation == 8) {
                        x = da.getCoordinate(i) * this.info.dZoomFactor;
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        y = da.getCoordinate(i) * this.info.dZoomFactor;
                    }
                    la.getCaption().setValue(sText);
                    RotatedRectangle rr = this.info.cComp.computePolygon(xs, iLabelLocation, la, x, y, fontHeight);
                    Point p = rr.getPoint(iPointToCheck);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                            return false;
                        }
                        rrPrev2 = rr;
                    } else {
                        if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                            return false;
                        }
                        rrPrev = rr;
                    }
                    avi.mutltiplyStep();
                    ++i;
                }
                break block35;
            }
            if (this.info.type != 8) break block35;
            CDateTime cdtAxisValue = AutoScale.asDateTime(this.context.getMin());
            int iUnit = AutoScale.asInteger(this.context.getUnit());
            int iStep = AutoScale.asInteger(this.context.getStep());
            IDateFormatWrapper sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.info.rtc.getULocale());
            CDateTime cdt = cdtAxisValue;
            int i = 0;
            while (i < da.size() - 1) {
                String sText = ValueFormatter.format((Object)cdt, this.info.fs, this.info.rtc.getULocale(), sdf);
                if (iLabelLocation == 4 || iLabelLocation == 8) {
                    x = da.getCoordinate(i) * this.info.dZoomFactor;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = da.getCoordinate(i) * this.info.dZoomFactor;
                }
                la.getCaption().setValue(sText);
                RotatedRectangle rr = this.info.cComp.computePolygon(xs, iLabelLocation, la, x, y, fontHeight);
                if (i == 0 && this.info.bLabelWithinAxes) {
                    Rectangle rect = rr.getBounds();
                    if (iLabelLocation == 4 || iLabelLocation == 8) {
                        rr.shiftXVertices(rect.getWidth() / 2.0);
                    } else {
                        rr.shiftYVertices(-rect.getHeight() / 2.0);
                    }
                }
                Point p = rr.getPoint(iPointToCheck);
                if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                    if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                        return false;
                    }
                    rrPrev2 = rr;
                } else {
                    if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                        return false;
                    }
                    rrPrev = rr;
                }
                cdt = cdtAxisValue.forward(iUnit, iStep * (i + 1));
                ++i;
            }
        }
        return true;
    }

    private CateLabVisTester createCateLabVisTester(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        int iNewPointToCheck = 0;
        int iPrevPointToCheck = 0;
        boolean isNegativeRotation = dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0;
        switch (iLabelLocation) {
            case 4: {
                iNewPointToCheck = isNegativeRotation ? 3 : 0;
                iPrevPointToCheck = isNegativeRotation ? 1 : 3;
                break;
            }
            case 8: {
                int n = isNegativeRotation ? (this.info.iScaleDirection == -1 ? 1 : 3) : (iNewPointToCheck = this.info.iScaleDirection == -1 ? 2 : 0);
                iPrevPointToCheck = isNegativeRotation ? (this.info.iScaleDirection == -1 ? 2 : 0) : (this.info.iScaleDirection == -1 ? 0 : 2);
                break;
            }
            case 1: {
                iNewPointToCheck = this.info.iScaleDirection == 1 ? 1 : 2;
                iPrevPointToCheck = this.info.iScaleDirection == 1 ? 2 : 1;
                break;
            }
            case 2: {
                iNewPointToCheck = this.info.iScaleDirection == 1 ? 0 : 3;
                iPrevPointToCheck = this.info.iScaleDirection == 1 ? 3 : 0;
            }
        }
        return new CateLabVisTester(iLabelLocation, iNewPointToCheck, iPrevPointToCheck, la, xs);
    }

    protected final void checkTickLabelsVisibility(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation) throws ChartException {
        this.hmComputedLabelText = new HashMap<Integer, String>();
        boolean vis = la.isVisible();
        if (!vis && this.info.rtc.getSharedScale() != null) {
            vis = true;
        }
        boolean staggerEnabled = this.isAxisLabelStaggered();
        this.staggeredHelper = StaggeredHelper.createInstance(staggerEnabled, this.atcTickCoordinates.size(), this.info.iLabelShowingInterval);
        this.labelVisHelper = LabelVisibleHelper.createInstance(vis, this.isCategoryScale(), this.atcTickCoordinates.size(), this.info.iLabelShowingInterval);
        if (!vis || !this.isCategoryScale()) {
            return;
        }
        DataSetIterator dsi = this.getData();
        dsi.reset();
        int iDateTimeUnit = 0;
        if (this.info.type == 8) {
            iDateTimeUnit = ChartUtil.computeDateTimeCategoryUnit(this.info.plotComp.getModel(), dsi);
        }
        CateLabVisTester tester = this.createCateLabVisTester(xs, la, iLabelLocation);
        EllipsisHelper eHelper = new EllipsisHelper(tester, la.getEllipsis());
        int start_id = this.isTickBetweenCategories() ? 0 : 1;
        RotatedRectangle[] rrPrev = new RotatedRectangle[2];
        double dStep = Math.abs(this.atcTickCoordinates.getStep() * this.info.dZoomFactor);
        int indexStep = dStep > 1.0 ? 1 : (int)(1.0 / dStep);
        int iSkip = indexStep - 1;
        double ellipsisWidth = 0.0;
        int i = start_id;
        while (i < this.atcTickCoordinates.size() - 1) {
            Object oValue = null;
            if (iSkip > 0 && dsi.skip(iSkip) < iSkip || !dsi.hasNext()) break;
            oValue = dsi.next();
            if (this.labelVisHelper.shouldTickLabelVisible(i)) {
                boolean bVis;
                int arrayIndex;
                double x = 0.0;
                double y = 0.0;
                String sText = this.formatCategoryValue(this.info.type, oValue, iDateTimeUnit);
                if (iLabelLocation == 4 || iLabelLocation == 8) {
                    x = this.atcTickCoordinates.getCoordinate(i) * this.info.dZoomFactor;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = this.atcTickCoordinates.getCoordinate(i) * this.info.dZoomFactor;
                }
                la.getCaption().setValue(sText);
                RotatedRectangle rrCurr = null;
                int n = arrayIndex = this.isAxisLabelStaggered() && this.isTickLabelStaggered(i) ? 1 : 0;
                if (rrPrev[arrayIndex] == null) {
                    rrCurr = this.info.cComp.computePolygon(xs, iLabelLocation, la, x, y, null);
                    bVis = true;
                } else {
                    tester.setFPara(rrPrev[arrayIndex], x, y);
                    bVis = eHelper.checkLabelEllipsis(sText, null);
                    rrCurr = tester.getCurrentRR();
                }
                if (bVis) {
                    this.labelVisHelper.addVisible(i);
                    rrPrev[arrayIndex] = rrCurr;
                    String str = la.getCaption().getValue();
                    double rotation = la.getCaption().getFont().getRotation();
                    if (iOrientation == 1 && this.isCategoryScale() && this.axisLabelInfo.dMaxSize > 0.0 && Math.abs(rotation) <= 45.0) {
                        double size = this.info.cComp.computeWidth(xs, la);
                        if (ellipsisWidth <= 0.0) {
                            la.getCaption().setValue("...");
                            ellipsisWidth = this.info.cComp.computeWidth(xs, la);
                        }
                        if (ChartUtil.mathGT(size, this.axisLabelInfo.dMaxSize)) {
                            int count = (int)((double)str.length() * (this.axisLabelInfo.dMaxSize - ellipsisWidth) / size);
                            if (count >= 0) {
                                this.hmComputedLabelText.put(i, String.valueOf(str.substring(0, count)) + "...");
                            } else {
                                this.hmComputedLabelText.put(i, str);
                            }
                        } else {
                            this.hmComputedLabelText.put(i, str);
                        }
                    } else {
                        this.hmComputedLabelText.put(i, str);
                    }
                }
            }
            i += indexStep;
        }
    }

    protected boolean quickCheckVisibility(int iLabelLocation, Point previousPoint, double x, double y) {
        return !(iLabelLocation == 4 || iLabelLocation == 8 ? this.info.iScaleDirection == -1 && previousPoint.getX() < x || this.info.iScaleDirection != -1 && previousPoint.getX() > x : (iLabelLocation == 1 || iLabelLocation == 2) && (this.info.iScaleDirection == 1 && previousPoint.getY() > y || this.info.iScaleDirection != 1 && previousPoint.getY() < y));
    }

    final void resetShifts() {
        this.dStartShift = 0.0;
        this.dEndShift = 0.0;
    }

    public final double getStart() {
        return this.dStart;
    }

    public final double getEnd() {
        return this.dEnd;
    }

    final double getStartShift() {
        return this.dStartShift;
    }

    final double getEndShift() {
        return this.dEndShift;
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, RunTimeContext rtc, int direction, double zoomFactor, int iMarginPercent, PlotComputation plotComp) throws ChartException {
        return AutoScale.computeScale(xs, ax, dsi, iType, dStart, dEnd, null, rtc, direction, zoomFactor, iMarginPercent, plotComp);
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, AxisOrigin axisOrigin, RunTimeContext rtc, int direction, double zoomFactor, int iMarginPercent, PlotComputation plotComp) throws ChartException {
        Object oValue;
        Object oMaxValue;
        Object oMinValue;
        BigDecimal divisor = null;
        dsi.reset();
        while (dsi.hasNext()) {
            Object v = dsi.next();
            if (!NumberUtil.isBigNumber(v)) continue;
            divisor = ((BigNumber)v).getDivisor();
            break;
        }
        Scale scModel = ax.getModelAxis().getScale();
        FormatSpecifier fs = ax.getFormatSpecifier();
        Label la = ax.getLabel();
        int iLabelLocation = ax.getLabelPosition();
        int iOrientation = ax.getOrientation();
        DataElement oMinimum = scModel.getMin();
        DataElement oMaximum = scModel.getMax();
        Double oStep = scModel.isSetStep() ? new Double(scModel.getStep()) : null;
        Integer oStepNumber = scModel.isSetStepNumber() ? Integer.valueOf(scModel.getStepNumber()) : null;
        AutoScale sc = null;
        AutoScale scCloned = null;
        boolean bIsPercent = ax.getModelAxis().isPercent();
        if (scModel.isSetFactor() && (iType & 2) == 2 && !ax.isCategoryScale()) {
            double factor = scModel.getFactor() * 72.0 / (double)xs.getDpiResolution();
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            dsi.reset();
            double dPrecision = Double.NaN;
            while (dsi.hasNext()) {
                Object oValue2 = dsi.next();
                if (oValue2 == null) continue;
                double dValue = ((Number)oValue2).doubleValue();
                if (dValue < dMinValue) {
                    dMinValue = dValue;
                }
                if (dValue > dMaxValue) {
                    dMaxValue = dValue;
                }
                dPrecision = AutoScale.getPrecision(dPrecision, dValue, fs, rtc.getULocale(), bIsPercent);
            }
            if (oMinimum != null && oMinimum instanceof NumberDataElement) {
                dMinValue = ((NumberDataElement)oMinimum).getValue();
            }
            double length = Math.abs(dEnd - dStart);
            double valueLength = length * factor;
            dMaxValue = dMinValue + valueLength;
            double dStep = 1.0;
            double dDelta = dMaxValue - dMinValue;
            if (dDelta == 0.0) {
                dStep = dPrecision;
            } else {
                dStep = Math.floor(Math.log(dDelta) / LOG_10);
                if ((dStep = Math.pow(10.0, dStep)) < dPrecision) {
                    dStep = dPrecision;
                }
            }
            ScaleInfo info = new ScaleInfo(plotComp, iType, rtc, fs, ax, direction, scModel.isAutoExpand()).dZoomFactor(zoomFactor).iMarginPercent(iMarginPercent).dPrecision(dPrecision).bStepFixed(true).dsiData(dsi).dFactor(factor);
            sc = new AutoScale(info);
            sc.setBigNubmerDivisor(divisor);
            sc.setMinimum(0.0);
            sc.setMaximum(0.0);
            sc.setStep(new Double(dStep));
            sc.setStepNumber(oStepNumber);
            AutoScale.setStepToScale(sc, oStep, null, rtc);
            Double oMinValue2 = new Double(dMinValue);
            Double oMaxValue2 = new Double(dMaxValue);
            sc.setMinimum(oMinValue2);
            sc.setMaximum(oMaxValue2);
            sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
            sc.setData(dsi);
            return sc;
        }
        if ((iType & 0x10) == 16 || ax.isCategoryScale()) {
            ScaleInfo info = new ScaleInfo(plotComp, iType, rtc, fs, ax, direction, scModel.isAutoExpand()).dZoomFactor(zoomFactor).iMarginPercent(iMarginPercent);
            sc = new AutoScale(info);
            sc.setBigNubmerDivisor(divisor);
            sc.setData(dsi);
            sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
            oMinValue = null;
            oMaxValue = null;
        } else if ((iType & 2) == 2) {
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            dsi.reset();
            double dPrecision = Double.NaN;
            while (dsi.hasNext()) {
                oValue = dsi.next();
                if (oValue == null) continue;
                double dValue = ((Number)oValue).doubleValue();
                if (dValue < dMinValue) {
                    dMinValue = dValue;
                }
                if (dValue > dMaxValue) {
                    dMaxValue = dValue;
                }
                dPrecision = AutoScale.getPrecision(dPrecision, dValue, fs, rtc.getULocale(), bIsPercent);
            }
            if (axisOrigin != null && axisOrigin.getType().equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof NumberDataElement) {
                double origin = AutoScale.asDouble(axisOrigin.getValue());
                if (oMinimum == null && origin < dMinValue) {
                    oMinimum = axisOrigin.getValue();
                }
                if (oMaximum == null && origin > dMaxValue) {
                    oMaximum = axisOrigin.getValue();
                }
            }
            double dAbsMax = Math.abs(dMaxValue);
            double dAbsMin = Math.abs(dMinValue);
            double dStep = Math.max(dAbsMax, dAbsMin);
            double dDelta = dMaxValue - dMinValue;
            if (dDelta == 0.0) {
                dStep = dPrecision;
            } else {
                dStep = Math.floor(Math.log(dDelta) / LOG_10);
                if ((dStep = Math.pow(10.0, dStep)) < dPrecision) {
                    dStep = dPrecision;
                }
            }
            ScaleInfo info = new ScaleInfo(plotComp, iType, rtc, fs, ax, direction, scModel.isAutoExpand()).dZoomFactor(zoomFactor).iMarginPercent(iMarginPercent).dPrecision(dPrecision);
            sc = new AutoScale(info);
            sc.setBigNubmerDivisor(divisor);
            sc.setMaximum(0.0);
            sc.setMinimum(0.0);
            sc.setStep(new Double(dStep));
            sc.setStepNumber(oStepNumber);
            sc.setData(dsi);
            AutoScale.setNumberMinMaxToScale(sc, oMinimum, oMaximum, rtc, ax);
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            oMinValue = new Double(dMinValue);
            oMaxValue = new Double(dMaxValue);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
        } else if ((iType & 4) == 4) {
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            if ((iType & 0x20) == 32) {
                dMinValue = 0.0;
                dMaxValue = 100.0;
            } else {
                dsi.reset();
                while (dsi.hasNext()) {
                    oValue = dsi.next();
                    if (oValue == null) continue;
                    double dValue = ((Number)oValue).doubleValue();
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
                if (axisOrigin != null && axisOrigin.getType().equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof NumberDataElement) {
                    double origin = AutoScale.asDouble(axisOrigin.getValue());
                    if (oMinimum == null && origin < dMinValue) {
                        oMinimum = axisOrigin.getValue();
                    }
                    if (oMaximum == null && origin > dMaxValue) {
                        oMaximum = axisOrigin.getValue();
                    }
                }
                if (dMinValue == 0.0) {
                    dMinValue = dMaxValue > 0.0 ? 1 : -1;
                }
            }
            ScaleInfo info = new ScaleInfo(plotComp, iType, rtc, fs, ax, direction, scModel.isAutoExpand()).dZoomFactor(zoomFactor).iMarginPercent(iMarginPercent);
            sc = new AutoScale(info);
            sc.setBigNubmerDivisor(divisor);
            sc.setMaximum(0.0);
            sc.setMinimum(0.0);
            sc.setStep(new Double(10.0));
            sc.setStepNumber(oStepNumber);
            sc.setData(dsi);
            AutoScale.setNumberMinMaxToScale(sc, oMinimum, oMaximum, rtc, ax);
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            oMinValue = new Double(dMinValue);
            oMaxValue = new Double(dMaxValue);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
            if ((iType & 0x20) == 32) {
                sc.info.bStepFixed(true);
                sc.info.bMaximumFixed(true);
                sc.info.bMinimumFixed(true);
                sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
                return sc;
            }
        } else if ((iType & 8) == 8) {
            int iUnit;
            Calendar caMin = null;
            Calendar caMax = null;
            dsi.reset();
            while (dsi.hasNext()) {
                Calendar cValue = (Calendar)dsi.next();
                if (cValue == null) continue;
                if (caMin == null) {
                    caMin = cValue;
                }
                if (caMax == null) {
                    caMax = cValue;
                }
                if (cValue.before((Object)caMin)) {
                    caMin = cValue;
                    continue;
                }
                if (!cValue.after((Object)caMax)) continue;
                caMax = cValue;
            }
            oMinValue = new CDateTime(caMin);
            oMaxValue = new CDateTime(caMax);
            if (axisOrigin != null && axisOrigin.getType().equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof DateTimeDataElement) {
                CDateTime origin = AutoScale.asDateTime(axisOrigin.getValue());
                if (oMinimum == null && origin.before(oMinValue)) {
                    oMinimum = axisOrigin.getValue();
                }
                if (oMaximum == null && origin.after(oMaxValue)) {
                    oMaximum = axisOrigin.getValue();
                }
            }
            if ((iUnit = oStep != null || oStepNumber != null ? ChartUtil.convertUnitTypeToCalendarConstant(scModel.getUnit()) : CDateTime.getPreferredUnit(oMinValue, oMaxValue)) == 0) {
                iUnit = 13;
            }
            CDateTime cdtMinAxis = oMinValue.backward(iUnit, 1);
            CDateTime cdtMaxAxis = oMaxValue.forward(iUnit, 1);
            cdtMinAxis.clearBelow(iUnit, true);
            cdtMaxAxis.clearBelow(iUnit, true);
            ScaleInfo info = new ScaleInfo(plotComp, 8, rtc, fs, ax, direction, scModel.isAutoExpand()).dZoomFactor(zoomFactor).iMarginPercent(iMarginPercent).iMinUnit(((Object)oMinValue).equals(oMaxValue) ? AutoScale.getUnitId(iUnit) : AutoScale.getMinUnitId(fs, rtc));
            sc = new AutoScale(info);
            sc.setBigNubmerDivisor(divisor);
            sc.setMaximum((Object)cdtMaxAxis);
            sc.setMinimum((Object)cdtMinAxis);
            sc.setStep(1);
            sc.setStepNumber(oStepNumber);
            sc.context.setUnit(iUnit);
            if (oMinimum instanceof DateTimeDataElement) {
                sc.setMinimum((Object)((DateTimeDataElement)oMinimum).getValueAsCDateTime());
                sc.info.oMinimumFixed((Object)((DateTimeDataElement)oMinimum).getValueAsCDateTime());
                sc.info.bMinimumFixed(true);
            }
            if (oMaximum instanceof DateTimeDataElement) {
                sc.setMaximum((Object)((DateTimeDataElement)oMaximum).getValueAsCDateTime());
                sc.info.oMaximumFixed((Object)((DateTimeDataElement)oMaximum).getValueAsCDateTime());
                sc.info.bMaximumFixed(true);
            }
            if (sc.info.bMaximumFixed && sc.info.bMinimumFixed && ((CDateTime)((Object)sc.getMinimum())).after(sc.getMaximum())) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.getMinimum(), sc.getMaximum()}, Messages.getResourceBundle(rtc.getULocale()));
            }
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
        } else {
            oMinValue = null;
            oMaxValue = null;
        }
        if ((iType & 0x10) != 16 && !ax.isCategoryScale()) {
            boolean bFirstFit;
            sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
            dStart = sc.dStart;
            dEnd = sc.dEnd;
            boolean bFits = bFirstFit = sc.checkFit(xs, la, iLabelLocation);
            boolean bZoomSuccess = false;
            int i = 0;
            while (bFits == bFirstFit && i < 50) {
                bZoomSuccess = true;
                scCloned = (AutoScale)sc.clone();
                if (sc.info.bStepFixed || rtc.getSharedScale() != null && rtc.getSharedScale().isShared()) break;
                if (bFirstFit) {
                    if (!bFits) break;
                    bZoomSuccess = sc.zoomIn();
                } else {
                    if (!bFits && sc.getTickCordinates().size() == 2) break;
                    bZoomSuccess = sc.zoomOut();
                }
                if (!bZoomSuccess) break;
                sc.updateAxisMinMax(oMinValue, oMaxValue);
                sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
                bFits = sc.checkFit(xs, la, iLabelLocation);
                if (!bFits && sc.getTickCordinates().size() == 2) {
                    sc = scCloned;
                    break;
                }
                ++i;
            }
            if (scCloned != null && bFirstFit && bZoomSuccess) {
                sc = scCloned;
            }
            AutoScale.updateSharedScaleContext(rtc, iType, sc.tmpSC);
        }
        if (sc != null) {
            sc.setData(dsi);
        }
        return sc;
    }

    private static double getValidDouble(double dValue) {
        String sValue = dfDoulbeNormalized.format(dValue);
        double dNewValue = Double.valueOf(sValue);
        return dNewValue;
    }

    private static int getMinUnitId(FormatSpecifier fs, RunTimeContext rtc) throws ChartException {
        int iUnit = 0;
        CDateTime cdt = new CDateTime(7, 6, 5, 4, 3, 2);
        String sDate = ValueFormatter.format((Object)cdt, fs, rtc.getULocale(), null);
        int i = 0;
        while (i < iaCalendarUnits.length) {
            cdt.set(iaCalendarUnits[i], 1);
            String sDatei = ValueFormatter.format((Object)cdt, fs, rtc.getULocale(), null);
            if (!sDate.equals(sDatei)) {
                iUnit = i;
                break;
            }
            ++i;
        }
        return iUnit;
    }

    public static int getMinUnit(CDateTime cdt) {
        int iUnit = 0;
        int i = 0;
        while (i < iaCalendarUnits.length) {
            if (cdt.get(iaCalendarUnits[i]) > 0) {
                iUnit = i;
                break;
            }
            ++i;
        }
        return iaCalendarUnits[iUnit];
    }

    public static int getUnitId(int iUnit) {
        int id = 0;
        int i = 0;
        while (i < iaCalendarUnits.length) {
            if (iaCalendarUnits[i] == iUnit) {
                id = i;
                break;
            }
            ++i;
        }
        return id;
    }

    protected static double getPrecision(double precision, double pValue, FormatSpecifier fs, ULocale locale, boolean bIsPercent) {
        NumberFormatSpecifier ns;
        double value = Math.abs(pValue);
        value = AutoScale.getValidDouble(value);
        boolean isFirst = Double.isNaN(precision);
        if (value == 0.0) {
            if (isFirst || precision == 0.0) {
                return 1.0;
            }
            return precision;
        }
        if (isFirst) {
            precision = 0.0;
        }
        if (precision == 0.0) {
            precision = bIsPercent ? 1.0 : Math.pow(10.0, Math.floor(Math.log(value) / Math.log(10.0)));
        }
        double check = value / precision;
        int loopCounter = 0;
        while (!ChartUtil.mathEqual(Math.floor(check), check) && loopCounter < 20) {
            ++loopCounter;
            check = value / (precision /= 10.0);
        }
        if (loopCounter == 20) {
            logger.log(2, "Autoscale precision not found for " + value);
        }
        if (fs != null && fs instanceof NumberFormatSpecifier && (ns = (NumberFormatSpecifier)fs).isSetFractionDigits()) {
            double multiplier;
            double d = multiplier = ns.isSetMultiplier() ? ns.getMultiplier() : 1.0;
            if (multiplier != 0.0) {
                double formatPrecision = Math.pow(10.0, -ns.getFractionDigits()) / multiplier;
                precision = precision == 0.0 ? formatPrecision : Math.max(precision, formatPrecision);
            }
        }
        return precision;
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartEndLabels, AllAxes aax) throws ChartException {
        return this.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, bConsiderStartEndLabels, bConsiderStartEndLabels, aax);
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartLabel, boolean bConsiderEndLabel, AllAxes aax) throws ChartException {
        int iDirection;
        boolean bMaxIsNotIntegralMultipleOfStep = false;
        int nTicks = 0;
        double dLength = 0.0;
        double dTickGap = 0.0;
        int n = this.info.iScaleDirection == 0 ? (iOrientation == 0 ? 1 : -1) : (iDirection = this.info.iScaleDirection);
        if (bConsiderStartLabel || bConsiderEndLabel) {
            this.computeAxisStartEndShifts(xs, la, iOrientation, iLabelLocation, aax);
            if (!this.info.bLabelWithinAxes && bConsiderStartLabel) {
                double dNewStart = dStart + this.dStartShift * (double)iDirection;
                if (dEnd > dStart && dNewStart > dEnd - 1.0) {
                    dNewStart = dEnd - 1.0;
                } else if (dEnd < dStart && dNewStart < dEnd + 1.0) {
                    dNewStart = dEnd + 1.0;
                }
                this.dStartShift = (dNewStart - dStart) / (double)iDirection;
                dStart = dNewStart;
            }
            if (bConsiderEndLabel) {
                double dNewEnd = dEnd + this.dEndShift * (double)(-iDirection);
                if (dEnd > dStart && dNewEnd < dStart + 1.0) {
                    dNewEnd = dStart + 1.0;
                } else if (dEnd < dStart && dNewEnd > dStart - 1.0) {
                    dNewEnd = dStart - 1.0;
                }
                this.dEndShift = (dNewEnd - dEnd) / (double)(-iDirection);
                dEnd = dNewEnd;
            }
        }
        this.dStart = dStart;
        this.dEnd = dEnd;
        if (this.isSetFactor()) {
            double step = Methods.asDouble(this.getStep());
            dTickGap = step / this.getFactor();
            int stepNum = (int)(Math.abs(dStart - dEnd) / dTickGap);
            AxisTickCoordinates atc = new AxisTickCoordinates(stepNum + 1, dStart, dStart < dEnd ? dStart + dTickGap * (double)stepNum : dStart - dTickGap * (double)stepNum, dTickGap * (double)iDirection, true);
            this.setTickCordinates(atc);
            this.checkTickLabelsVisibility(xs, la, iLabelLocation, iOrientation);
            double length = Math.abs(this.dEnd - this.dStart);
            double valueLength = length * this.getFactor();
            double dMaxValue = ((Number)this.getMinimum()).doubleValue() + valueLength;
            this.setMaximum(dMaxValue);
            return stepNum + 1;
        }
        nTicks = this.getTickCount();
        dLength = Math.abs(dStart - dEnd);
        if (!this.info.bCategoryScale && (this.info.type & 1) == 1 && (this.info.type & 2) == 2) {
            double dMax = AutoScale.asDouble(this.context.getMax());
            double dMin = AutoScale.asDouble(this.context.getMin());
            double dStep = AutoScale.asDouble(this.context.getStep());
            boolean bl = bMaxIsNotIntegralMultipleOfStep = !ChartUtil.mathEqual(dMax / dStep, (int)(dMax / dStep), this.isBigNumber());
            if (this.info.bStepFixed && this.context.getStepNumber() != null) {
                dTickGap = dLength / (double)this.context.getStepNumber().intValue() * (double)iDirection;
            } else {
                double dStepSize = AutoScale.asDouble(this.context.getStep());
                dTickGap = Math.min(Math.abs(dStepSize / (dMax - dMin) * dLength), dLength) * (double)iDirection;
            }
        } else {
            CDateTime cdtMin;
            CDateTime cdtMax;
            double diff;
            dTickGap = !this.info.bCategoryScale && (this.info.type & 8) == 8 ? ((diff = CDateTime.computeDifference(cdtMax = AutoScale.asDateTime(this.context.getMax()), cdtMin = AutoScale.asDateTime(this.context.getMin()), AutoScale.asInteger(this.context.getUnit())) / AutoScale.asDouble(this.context.getStep())) == 0.0 ? dLength : Math.min(Math.abs(dLength / diff), dLength) * (double)iDirection) : (this.isTickBetweenCategories() ? dLength / (double)(nTicks - 1) * (double)iDirection : dLength / (double)(nTicks - 2) * (double)iDirection);
        }
        if (nTicks > 1000 && this.info.bStepFixed && !this.info.bCategoryScale) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.scale.tick.max", Messages.getResourceBundle(this.info.rtc.getULocale()));
        }
        AxisTickCoordinates atc = new AxisTickCoordinates(nTicks, dStart, dEnd, dTickGap, !this.info.bCategoryScale || this.isTickBetweenCategories());
        this.setTickCordinates(null);
        this.setEndPoints(dStart, dEnd);
        this.setTickCordinates(atc);
        if (this.info.bStepFixed && this.context.getStepNumber() == null && nTicks > 2 && bMaxIsNotIntegralMultipleOfStep && !this.checkFit(xs, la, iLabelLocation)) {
            AxisTickCoordinates atc1 = new AxisTickCoordinates(--nTicks, dStart, dEnd, dTickGap, !this.info.bCategoryScale || this.isTickBetweenCategories());
            this.setTickCordinates(null);
            this.setTickCordinates(atc1);
        }
        this.checkTickLabelsVisibility(xs, la, iLabelLocation, iOrientation);
        return nTicks;
    }

    public final String formatCategoryValue(int iType, Object oValue, int iDateTimeUnit) {
        if (oValue == null) {
            return IConstants.NULL_STRING;
        }
        if ((iType & 0x10) == 16) {
            if (oValue instanceof Number) {
                return this.formatCategoryValue(1, oValue, iDateTimeUnit);
            }
            if (this.info.fs != null) {
                try {
                    return ValueFormatter.format(oValue, this.info.fs, this.info.rtc.getULocale(), null);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    return oValue.toString();
                }
            }
            return oValue.toString();
        }
        if ((iType & 8) == 8) {
            Calendar ca = (Calendar)oValue;
            IDateFormatWrapper sdf = null;
            if (this.info.fs == null) {
                sdf = (IDateFormatWrapper)this.info.cacheDateFormat.get(iDateTimeUnit);
            }
            try {
                return ValueFormatter.format(ca, this.info.fs, this.info.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        if ((iType & 1) == 1) {
            DecimalFormat df = null;
            if (this.info.fs == null) {
                String pattern = ValueFormatter.getNumericPattern((Number)oValue);
                df = (DecimalFormat)this.info.cacheNumFormat.get(pattern);
            }
            try {
                return ValueFormatter.format(oValue, this.info.fs, this.info.rtc.getULocale(), df);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        return IConstants.NULL_STRING;
    }

    final void computeAxisStartEndShifts(IDisplayServer xs, Label la, int iOrientation, int iLocation, AllAxes aax) throws ChartException {
        double dMaxES;
        double dMaxSS = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxStartShift() : 0.0;
        double d = dMaxES = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxEndShift() : 0.0;
        if (!la.isVisible() && !this.info.bLabelWithinAxes) {
            this.dStartShift = dMaxSS;
            this.dEndShift = dMaxES;
            return;
        }
        if (this.isCategoryScale()) {
            boolean bCenter;
            int iDateTimeUnit;
            double dUnitSize = this.getUnitSize();
            DataSetIterator dsi = this.getData();
            BoundingBox bb = null;
            try {
                iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
            }
            catch (ClassCastException classCastException) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.dataset.non.datetime", Messages.getResourceBundle(this.info.rtc.getULocale()));
            }
            double rotation = la.getCaption().getFont().getRotation();
            boolean bl = bCenter = rotation == 0.0 || rotation == 90.0 || rotation == -90.0;
            if (!this.isTickLabelVisible(0)) {
                this.dStartShift = dMaxSS;
            } else {
                la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.first(), iDateTimeUnit));
                bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, 0.0);
                if (iOrientation == 1) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitSize) / 2.0) : (this.info.iScaleDirection == 1 ? Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint() - dUnitSize / 2.0));
                } else if (iOrientation == 0) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitSize) / 2.0) : (this.info.iScaleDirection == -1 ? Math.max(dMaxSS, bb.getWidth() - bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0));
                }
            }
            if (!this.isTickLabelVisible(dsi.size() - 1)) {
                double tmpEndShift;
                this.dEndShift = dMaxES;
                if (this.labelVisHelper.getLastVisibleIndex() < dsi.size() - 1 && (tmpEndShift = this.computeEndShift(xs, la, iOrientation, iLocation, dMaxES, dUnitSize * (double)(dsi.size() - this.labelVisHelper.getLastVisibleIndex()), dsi, iDateTimeUnit, bCenter)) > this.dEndShift) {
                    this.dEndShift = tmpEndShift;
                }
            } else {
                this.dEndShift = this.computeEndShift(xs, la, iOrientation, iLocation, dMaxES, dUnitSize, dsi, iDateTimeUnit, bCenter);
            }
        } else if ((this.info.type & 1) == 1) {
            if ((this.info.type & 2) == 2) {
                DecimalFormat df = null;
                Object value = AxisValueProvider.getValue(this.getMinimum(), this.isBigNumber() ? this.getBigNumberDivisor() : null);
                if (this.info.fs == null) {
                    df = !this.isBigNumber() ? new DecimalFormat(this.getNumericPattern()) : new DecimalFormat(ValueFormatter.getNumericPattern((Number)value));
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(value, this.info.fs, this.info.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, 0.0);
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                value = AxisValueProvider.getValue(this.getMaximum(), this.isBigNumber() ? this.getBigNumberDivisor() : null);
                if (this.info.fs == null) {
                    df = new DecimalFormat(ValueFormatter.getNumericPattern((Number)value));
                }
                try {
                    sValue = ValueFormatter.format(value, this.info.fs, this.info.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, 0.0);
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            } else if ((this.info.type & 4) == 4) {
                DecimalFormat df = null;
                Object value = AxisValueProvider.getValue(this.getMinimum(), this.isBigNumber() ? this.getBigNumberDivisor() : null);
                if (this.info.fs == null) {
                    df = new DecimalFormat(ValueFormatter.getNumericPattern((Number)value));
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(value, this.info.fs, this.info.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = null;
                bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, 0.0);
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                value = AxisValueProvider.getValue(this.getMaximum(), this.isBigNumber() ? this.getBigNumberDivisor() : null);
                if (this.info.fs == null) {
                    df = new DecimalFormat(ValueFormatter.getNumericPattern((Number)value));
                }
                try {
                    sValue = ValueFormatter.format(value, this.info.fs, this.info.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, 0.0);
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            }
        } else if (this.getType() == 8) {
            CDateTime cdt = AutoScale.asDateTime(this.getMinimum());
            int iUnit = AutoScale.asInteger(this.context.getUnit());
            IDateFormatWrapper sdf = null;
            String sText = null;
            if (this.info.fs == null) {
                sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.info.rtc.getULocale());
            }
            try {
                sText = ValueFormatter.format((Object)cdt, this.info.fs, this.info.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            BoundingBox bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, 0.0);
            if (iOrientation == 1) {
                this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
            }
            cdt = AutoScale.asDateTime(this.getMaximum());
            try {
                sText = ValueFormatter.format((Object)cdt, this.info.fs, this.info.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, this.dEnd);
            if (iOrientation == 1) {
                this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
            }
        }
    }

    private double computeEndShift(IDisplayServer xs, Label la, int iOrientation, int iLocation, double dMaxES, double dUnitsSize, DataSetIterator dsi, int iDateTimeUnit, boolean bCenter) throws ChartException {
        double endShift = 0.0;
        la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.last(), iDateTimeUnit));
        BoundingBox bb = this.info.cComp.computeBox(xs, iLocation, la, 0.0, this.dEnd);
        if (iOrientation == 1) {
            endShift = bCenter ? Math.max(dMaxES, dUnitsSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitsSize) / 2.0) : (this.info.iScaleDirection == 1 ? Math.max(dMaxES, bb.getHeight() - bb.getHotPoint() - dUnitsSize / 2.0) : Math.max(dMaxES, bb.getHotPoint() - dUnitsSize / 2.0));
        } else if (iOrientation == 0) {
            endShift = bCenter ? Math.max(dMaxES, dUnitsSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitsSize) / 2.0) : (this.info.iScaleDirection == -1 ? Math.max(dMaxES, bb.getHotPoint() - dUnitsSize / 2.0) : Math.max(dMaxES, bb.getWidth() - bb.getHotPoint() - dUnitsSize / 2.0));
        }
        return endShift;
    }

    public final double computeAxisLabelThickness(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isVisible()) {
            return 0.0;
        }
        AxisTickCoordinates da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            double dMaxW2 = 0.0;
            if (this.isCategoryScale()) {
                Collection<Integer> visIds = this.getVisibleLabelIds();
                for (int id : visIds) {
                    la.getCaption().setValue(this.getComputedLabelText(id));
                    double dW = this.info.cComp.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(id)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                        continue;
                    }
                    if (!(dW > dMaxW)) continue;
                    dMaxW = dW;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                DecimalFormat df = avi.getDecimalFormat();
                int i = 0;
                while (i < da.size()) {
                    Object value = avi.getValue(nde);
                    String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                    la.getCaption().setValue(sText);
                    double dW = this.info.cComp.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    avi.addStep();
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    df = avi.getDecimalFormat();
                    Object value = avi.getValue(nde);
                    String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                    la.getCaption().setValue(sText);
                    double dW = this.info.cComp.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    avi.mutltiplyStep();
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.info.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.info.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.info.fs, this.info.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = this.info.cComp.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxW + dMaxW2;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            double dMaxH2 = 0.0;
            if (this.isCategoryScale()) {
                Collection<Integer> visIds = this.getVisibleLabelIds();
                for (int id : visIds) {
                    la.getCaption().setValue(this.getComputedLabelText(id));
                    double dH = this.info.cComp.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(id)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                        continue;
                    }
                    if (!(dH > dMaxH)) continue;
                    dMaxH = dH;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.info.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.info.fs, this.info.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = this.info.cComp.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    if (this.info.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.info.fs, this.info.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = this.info.cComp.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.info.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.info.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.info.fs, this.info.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = this.info.cComp.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxH + dMaxH2;
        }
        return 0.0;
    }

    public final double computeStaggeredAxisLabelOffset(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isVisible() || !this.isAxisLabelStaggered()) {
            return 0.0;
        }
        AxisTickCoordinates da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            if (this.isCategoryScale()) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dW;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.isTickLabelStaggered(i) && (dW = this.info.cComp.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                DecimalFormat df = avi.getDecimalFormat();
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    Object value = avi.getValue(nde);
                    String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dW = this.info.cComp.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    avi.addStep();
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    df = avi.getDecimalFormat();
                    Object value = avi.getValue(nde);
                    String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dW = this.info.cComp.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    avi.mutltiplyStep();
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.info.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.info.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.info.fs, this.info.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dW = this.info.cComp.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxW;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            if (this.isCategoryScale()) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dH;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.isTickLabelStaggered(i) && (dH = this.info.cComp.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                DecimalFormat df = avi.getDecimalFormat();
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    Object value = avi.getValue(nde);
                    String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dH = this.info.cComp.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    avi.addStep();
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                AxisValueProvider avi = new AxisValueProvider(dAxisValue, dAxisStep, this, this.info);
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    df = avi.getDecimalFormat();
                    Object value = avi.getValue(nde);
                    String sText = AxisValueProvider.format(value, this.info.fs, this.info.rtc.getULocale(), df, logger);
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dH = this.info.cComp.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.info.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.info.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.info.fs, this.info.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dH = this.info.cComp.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxH;
        }
        return 0.0;
    }

    public final boolean isStepFixed() {
        return this.info.bStepFixed;
    }

    public final void setStepFixed(boolean v) {
        this.info.bStepFixed(v);
    }

    public final boolean isMinimumFixed() {
        return this.info.bMinimumFixed;
    }

    public final void setMinimumFixed(boolean v) {
        this.info.bMinimumFixed(v);
    }

    public final boolean isMaximumFixed() {
        return this.info.bMaximumFixed;
    }

    public final void setMaximumFixed(boolean v) {
        this.info.bMaximumFixed(v);
    }

    public final boolean isCategoryScale() {
        return this.info.bCategoryScale;
    }

    public final double[] getMinorCoordinates(int iMinorUnitsPerMajor) {
        if (this.atcTickCoordinates == null || iMinorUnitsPerMajor <= 0) {
            return null;
        }
        double[] da = new double[iMinorUnitsPerMajor];
        double dUnit = this.getUnitSize();
        if ((this.info.type & 4) != 4) {
            double dEach = dUnit / (double)iMinorUnitsPerMajor;
            int i = 1;
            while (i < iMinorUnitsPerMajor) {
                da[i - 1] = dEach * (double)i;
                ++i;
            }
        } else {
            double dCount = iMinorUnitsPerMajor;
            double dMax = Math.log(dCount);
            int i = 0;
            while (i < iMinorUnitsPerMajor) {
                da[i] = Math.log(i + 1) * dUnit / dMax;
                ++i;
            }
        }
        da[iMinorUnitsPerMajor - 1] = dUnit;
        return da;
    }

    public final RunTimeContext getRunTimeContext() {
        return this.info.rtc;
    }

    public static void setNumberMinMaxToScale(AutoScale sc, Object oMinimum, Object oMaximum, RunTimeContext rtc, OneAxis ax) throws ChartException {
        BigDecimal bd;
        if (oMinimum instanceof NumberDataElement) {
            sc.setMinimum(new Double(((NumberDataElement)oMinimum).getValue()));
            sc.info.bMinimumFixed(true);
        } else if (oMinimum instanceof BigNumberDataElement) {
            bd = NumberUtil.asBigDecimal(((BigNumberDataElement)oMinimum).getValue());
            sc.setMinimum(new BigNumber(bd, sc.bigNumberDivisor));
            sc.info.bMinimumFixed(true);
        }
        if (oMaximum instanceof NumberDataElement) {
            sc.setMaximum(((NumberDataElement)oMaximum).getValue());
            sc.info.bMaximumFixed(true);
        } else if (oMaximum instanceof BigNumberDataElement) {
            bd = NumberUtil.asBigDecimal(((BigNumberDataElement)oMaximum).getValue());
            sc.setMaximum(new BigNumber(bd, sc.bigNumberDivisor));
            sc.info.bMaximumFixed(true);
        }
        if (sc.info.bMaximumFixed && sc.info.bMinimumFixed) {
            boolean bInValid = false;
            Object oMin = sc.getMinimum();
            Object oMax = sc.getMaximum();
            if (oMin instanceof Double && oMax instanceof Double) {
                bInValid = (Double)oMin > (Double)oMax;
            } else {
                boolean bl = bInValid = ((BigNumber)oMin).compareTo(oMax) > 0;
            }
            if (bInValid) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.getMinimum(), sc.getMaximum()}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
    }

    public static void setStepToScale(AutoScale sc, Object oStep, Integer oStepNumber, RunTimeContext rtc) throws ChartException {
        if (oStep != null) {
            sc.setStep(oStep);
            sc.info.bStepFixed(true);
            if ((Double)sc.getStep() <= 0.0) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.size", new Object[]{oStep}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
        if (oStepNumber != null) {
            sc.setStepNumber(oStepNumber);
            sc.info.bStepFixed(true);
            if (sc.getStepNumber() < 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.number", new Object[]{oStepNumber}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
    }

    public final DecimalFormat computeDefaultDecimalFormat(Number number) {
        return (DecimalFormat)this.info.cacheNumFormat.get(ValueFormatter.getNumericPattern(number));
    }

    public final DecimalFormat computeDecimalFormat(BigDecimal bdAxisValue, BigDecimal bdAxisStep) {
        if (bdAxisValue.abs().compareTo(UPER_LIMIT) >= 0 || bdAxisStep.abs().compareTo(UPER_LIMIT) >= 0) {
            return (DecimalFormat)this.info.cacheNumFormat.get("0.0E0");
        }
        boolean bValuePrecise = false;
        boolean bStepPrecise = false;
        String valuePattern = ValueFormatter.getNumericPattern((Number)bdAxisValue);
        String stepPattern = ValueFormatter.getNumericPattern((Number)bdAxisStep);
        bValuePrecise = ChartUtil.checkBigNumberPrecise(bdAxisValue);
        bStepPrecise = ChartUtil.checkBigNumberPrecise(bdAxisStep);
        if (bValuePrecise ? bStepPrecise && valuePattern.length() < stepPattern.length() : bStepPrecise) {
            return (DecimalFormat)this.info.cacheNumFormat.get(stepPattern);
        }
        return (DecimalFormat)this.info.cacheNumFormat.get(valuePattern);
    }

    public final DecimalFormat computeDecimalFormat(double dAxisValue, double dAxisStep) {
        String stepPattern;
        String valuePattern;
        boolean bValuePrecise = false;
        boolean bStepPrecise = false;
        if (this.isBigNumber()) {
            BigDecimal bdAxisValue = this.getBigNumberDivisor().multiply(new BigDecimal(dAxisValue), NumberUtil.DEFAULT_MATHCONTEXT);
            BigDecimal bdAxisStep = this.getBigNumberDivisor().multiply(new BigDecimal(dAxisStep), NumberUtil.DEFAULT_MATHCONTEXT);
            valuePattern = ValueFormatter.getNumericPattern((Number)bdAxisValue);
            stepPattern = ValueFormatter.getNumericPattern((Number)bdAxisStep);
            bValuePrecise = ChartUtil.checkBigNumberPrecise(bdAxisValue);
            bStepPrecise = ChartUtil.checkBigNumberPrecise(bdAxisStep);
        } else {
            valuePattern = ValueFormatter.getNumericPattern(dAxisValue);
            dAxisStep = ValueFormatter.normalizeDouble(dAxisStep).doubleValue();
            stepPattern = ValueFormatter.getNumericPattern(dAxisStep);
            bValuePrecise = ChartUtil.checkDoublePrecise(dAxisValue);
            bStepPrecise = ChartUtil.checkDoublePrecise(dAxisStep);
        }
        if (bValuePrecise ? bStepPrecise && valuePattern.length() < stepPattern.length() : bStepPrecise) {
            return (DecimalFormat)this.info.cacheNumFormat.get(stepPattern);
        }
        return (DecimalFormat)this.info.cacheNumFormat.get(valuePattern);
    }

    private static void updateSharedScaleContext(RunTimeContext rtc, int iType, ScaleContext sct) {
        if (rtc.getSharedScale() != null && !rtc.getSharedScale().isShared()) {
            rtc.getSharedScale().setScaleContext(sct);
        }
    }

    public void setBigNubmerDivisor(BigDecimal divisor) {
        if (divisor == null) {
            this.bIsBigNumber = false;
            this.bigNumberDivisor = null;
        } else {
            this.bIsBigNumber = true;
            this.bigNumberDivisor = divisor;
        }
    }

    public boolean isBigNumber() {
        return this.bIsBigNumber;
    }

    public BigDecimal getBigNumberDivisor() {
        return this.bigNumberDivisor;
    }

    static class AxisLabelInfo {
        double dActualSize = -1.0;
        double dMaxSize = -1.0;

        AxisLabelInfo() {
        }

        double getValidSize(double refSize) {
            if (this.dActualSize >= 0.0 && this.dActualSize < refSize) {
                return this.dActualSize;
            }
            return refSize;
        }
    }

    private static class AxisValueProvider {
        double dAxisValue;
        double dAxisStep;
        BigDecimal bdAxisValue;
        BigDecimal bdAxisStep;
        DecimalFormat df = null;
        private AutoScale as;
        private BigDecimal bdStep;
        private ScaleInfo si;

        AxisValueProvider(double dAxisValue, double dAxisStep, AutoScale as, ScaleInfo si) {
            this.dAxisValue = dAxisValue;
            this.dAxisStep = dAxisStep;
            this.as = as;
            this.si = si;
            if (as.isBigNumber()) {
                this.bdAxisValue = BigDecimal.valueOf((double)dAxisValue).multiply(as.getBigNumberDivisor(), NumberUtil.DEFAULT_MATHCONTEXT);
                this.bdAxisStep = BigDecimal.valueOf((double)dAxisStep);
                this.bdStep = this.bdAxisStep.multiply(as.getBigNumberDivisor(), NumberUtil.DEFAULT_MATHCONTEXT);
            }
        }

        Object getValue(NumberDataElement nde) {
            if (this.as.isBigNumber()) {
                return this.bdAxisValue;
            }
            nde.setValue(this.dAxisValue);
            return nde;
        }

        void addStep() {
            if (!this.as.isBigNumber()) {
                this.dAxisValue += this.dAxisStep;
            } else {
                this.bdAxisValue = this.bdAxisValue.add(this.bdStep);
            }
        }

        void mutltiplyStep() {
            if (!this.as.isBigNumber()) {
                this.dAxisValue *= this.dAxisStep;
            } else {
                this.bdAxisValue = this.bdAxisValue.multiply(this.bdAxisStep, NumberUtil.DEFAULT_MATHCONTEXT);
            }
        }

        DecimalFormat getDecimalFormat() {
            if (this.si.fs == null) {
                this.df = !this.as.isBigNumber() ? this.as.computeDecimalFormat(this.dAxisValue, this.dAxisStep) : this.as.computeDecimalFormat(this.bdAxisValue.multiply(this.as.getBigNumberDivisor(), NumberUtil.DEFAULT_MATHCONTEXT), this.bdStep);
            }
            return this.df;
        }

        static String format(Object oValue, FormatSpecifier fs, ULocale lcl, Object oCachedJavaFormatter, ILogger logger) {
            String sText = NULL_STRING;
            try {
                sText = ValueFormatter.format(oValue, fs, lcl, oCachedJavaFormatter);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
            }
            return sText;
        }

        static Object getValue(Object originValue, BigDecimal divisor) {
            if (originValue instanceof Number) {
                if (divisor != null) {
                    return NumberUtil.asBigDecimal((Number)originValue).multiply(divisor, NumberUtil.DEFAULT_MATHCONTEXT);
                }
                return ((Number)originValue).doubleValue();
            }
            if (originValue instanceof NumberDataElement) {
                Double d = new Double(((NumberDataElement)originValue).getValue());
                if (divisor != null) {
                    return NumberUtil.asBigDecimal(d).multiply(divisor, NumberUtil.DEFAULT_MATHCONTEXT);
                }
                return d;
            }
            if (originValue instanceof BigNumberDataElementImpl) {
                return ((BigNumberDataElementImpl)originValue).getValue();
            }
            return originValue;
        }
    }

    private class CateLabVisTester
    implements EllipsisHelper.ITester {
        private RotatedRectangle rrPrev;
        private RotatedRectangle rrCurr;
        private int iLabelLocation;
        private double x;
        private double y;
        private int iNewPointToCheck;
        private int iPrevPointToCheck;
        private Label la;
        private IDisplayServer xs;
        private Double fontHeight = null;

        CateLabVisTester(int iLabelLocation, int iNewPointToCheck, int iPrevPointToCheck, Label la, IDisplayServer xs) throws ChartException {
            this.iLabelLocation = iLabelLocation;
            this.iNewPointToCheck = iNewPointToCheck;
            this.iPrevPointToCheck = iPrevPointToCheck;
            this.la = la;
            this.xs = xs;
            this.fontHeight = AutoScale.this.info.cComp.computeFontHeight(xs, la);
        }

        private void setFPara(RotatedRectangle rrPrev, double x, double y) {
            this.rrPrev = rrPrev;
            this.x = x;
            this.y = y;
        }

        private RotatedRectangle getCurrentRR() {
            return this.rrCurr;
        }

        public boolean testLabelVisible(String sText, Object oPara) throws ChartException {
            this.la.getCaption().setValue(sText);
            Point previousPoint = this.rrPrev.getPoint(this.iPrevPointToCheck);
            if (AutoScale.this.quickCheckVisibility(this.iLabelLocation, previousPoint, this.x, this.y)) {
                boolean visible;
                this.rrCurr = AutoScale.this.info.cComp.computePolygon(this.xs, this.iLabelLocation, this.la, this.x, this.y, this.fontHeight);
                Point p = this.rrCurr.getPoint(this.iNewPointToCheck);
                boolean bl = visible = !this.rrPrev.contains(p) && !ChartUtil.intersects(this.rrCurr, this.rrPrev);
                if (visible) {
                    return true;
                }
            }
            return false;
        }

        public double getHeight() {
            return 0.0;
        }

        public double getWidth() {
            return 0.0;
        }
    }

    private static abstract class LabelVisibleHelper {
        protected Set<Integer> idsVis = new HashSet<Integer>();
        protected final int iTickCount;
        protected final int iShowIterval;
        protected final CommonRule commonRule;
        private int iFirstVisibleIndex = -1;
        private int iLastVisibleIndex = -1;

        private LabelVisibleHelper(int iTickCount, int iShowIterval) {
            this.iTickCount = iTickCount;
            this.iShowIterval = iShowIterval;
            this.commonRule = iShowIterval < 2 ? CommonRule.SHOW_INTERVAL_1 : CommonRule.SHOW_INTEVAL_2UP;
        }

        public abstract boolean isTickLabelVisible(int var1);

        public boolean shouldTickLabelVisible(int index) {
            return this.commonRule.shouldVisible(index, this.iTickCount, this.iShowIterval);
        }

        public void addVisible(int index) {
            this.idsVis.add(index);
            if (this.iFirstVisibleIndex == -1 || index < this.iFirstVisibleIndex) {
                this.iFirstVisibleIndex = index;
            }
            if (this.iLastVisibleIndex == -1 || index > this.iLastVisibleIndex) {
                this.iLastVisibleIndex = index;
            }
        }

        int getLastVisibleIndex() {
            return this.iLastVisibleIndex;
        }

        public static LabelVisibleHelper createInstance(boolean bLabelVisible, boolean bCategory, int iTickCount, int iShowIterval) {
            if (!bLabelVisible) {
                return new LabelVisibleHelper(iTickCount, iShowIterval){

                    public boolean isTickLabelVisible(int index) {
                        return false;
                    }

                    public boolean shouldTickLabelVisible(int index) {
                        return false;
                    }
                };
            }
            if (bCategory) {
                return new LabelVisibleHelper(iTickCount, iShowIterval){

                    public boolean isTickLabelVisible(int index) {
                        return this.idsVis.contains(index);
                    }
                };
            }
            return new LabelVisibleHelper(iTickCount, iShowIterval){

                public boolean isTickLabelVisible(int index) {
                    return this.commonRule.shouldVisible(index, this.iTickCount, this.iShowIterval);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum CommonRule {
            SHOW_INTERVAL_1{

                public boolean shouldVisible(int index, int iTickCount, int iShowIterval) {
                    return !CommonRule.isIndexOutOfBound(index, iTickCount);
                }
            }
            ,
            SHOW_INTEVAL_2UP{

                public boolean shouldVisible(int index, int iTickCount, int iShowIterval) {
                    return !CommonRule.isIndexOutOfBound(index, iTickCount) && index % iShowIterval == 0;
                }
            };


            public abstract boolean shouldVisible(int var1, int var2, int var3);

            private static boolean isIndexOutOfBound(int index, int iTickCount) {
                return index < 0 || index > iTickCount - 1;
            }
        }
    }

    public static class ScaleInfo {
        public final PlotComputation plotComp;
        public final OneAxis oax;
        public final int type;
        private final RunTimeContext rtc;
        private final ChartUtil.CacheDecimalFormat cacheNumFormat;
        private final ChartUtil.CacheDateFormat cacheDateFormat;
        private final IChartComputation cComp;
        private final FormatSpecifier fs;
        private final boolean bAxisLabelStaggered;
        private final int iLabelShowingInterval;
        private final boolean bTickBetweenCategories;
        private final boolean bAlignZero;
        private final boolean bLabelWithinAxes;
        private final boolean bCategoryScale;
        public final int iScaleDirection;
        private final boolean bExpandMinMax;
        private int iMarginPercent = 0;
        private double dZoomFactor = 1.0;
        private double dPrecision = 0.0;
        private int iMinUnit = 0;
        private double dFactor = -1.0;
        private DataSetIterator dsiData;
        private boolean bStepFixed = false;
        public boolean bMaximumFixed = false;
        private boolean bMinimumFixed = false;
        private Object oMinimumFixed;
        private Object oMaximumFixed;

        public ScaleInfo(PlotComputation plotComp, int iType, RunTimeContext rtc, FormatSpecifier fs, OneAxis ax, int iScaleDirection, boolean bExpandMinMax) {
            this.plotComp = plotComp;
            this.oax = ax;
            this.type = iType;
            this.rtc = rtc;
            this.fs = fs;
            this.iScaleDirection = iScaleDirection;
            this.bExpandMinMax = bExpandMinMax;
            this.cacheNumFormat = new ChartUtil.CacheDecimalFormat(rtc.getULocale());
            this.cacheDateFormat = new ChartUtil.CacheDateFormat(rtc.getULocale());
            this.cComp = rtc.getState(RunTimeContext.StateKey.CHART_COMPUTATION_KEY);
            if (ax != null) {
                this.bAxisLabelStaggered = ax.isAxisLabelStaggered();
                this.iLabelShowingInterval = ax.getLableShowingInterval();
                this.bTickBetweenCategories = ax.isTickBwtweenCategories();
                this.bAlignZero = ax.getModelAxis().isAligned();
                this.bLabelWithinAxes = ax.getModelAxis().isLabelWithinAxes();
                this.bCategoryScale = (iType & 0x10) == 16 || ax.isCategoryScale();
            } else {
                this.bAxisLabelStaggered = false;
                this.iLabelShowingInterval = 0;
                this.bTickBetweenCategories = true;
                this.bAlignZero = false;
                this.bLabelWithinAxes = false;
                this.bCategoryScale = false;
            }
        }

        public ScaleInfo iMarginPercent(int iMarginPercent) {
            this.iMarginPercent = iMarginPercent;
            return this;
        }

        public ScaleInfo dZoomFactor(double dZoomFactor) {
            this.dZoomFactor = dZoomFactor;
            return this;
        }

        public ScaleInfo dPrecision(double dPrecision) {
            this.dPrecision = dPrecision;
            return this;
        }

        public ScaleInfo iMinUnit(int iMinUnit) {
            this.iMinUnit = iMinUnit;
            return this;
        }

        public ScaleInfo dFactor(double dFactor) {
            this.dFactor = dFactor;
            return this;
        }

        public ScaleInfo dsiData(DataSetIterator dsiData) {
            this.dsiData = dsiData;
            return this;
        }

        public ScaleInfo bMaximumFixed(boolean bMaximumFixed) {
            this.bMaximumFixed = bMaximumFixed;
            return this;
        }

        public ScaleInfo bMinimumFixed(boolean bMinimumFixed) {
            this.bMinimumFixed = bMinimumFixed;
            return this;
        }

        public ScaleInfo oMinimumFixed(Object oMinimumFixed) {
            this.oMinimumFixed = oMinimumFixed;
            return this;
        }

        public ScaleInfo oMaximumFixed(Object oMaximumFixed) {
            this.oMaximumFixed = oMaximumFixed;
            return this;
        }

        public ScaleInfo bStepFixed(boolean bStepFixed) {
            this.bStepFixed = bStepFixed;
            return this;
        }
    }

    private static abstract class StaggeredHelper {
        private StaggeredHelper() {
        }

        public static StaggeredHelper createInstance(boolean staggerEnabled, final int iTickCount, final int iLabelShowingInterval) {
            if (!staggerEnabled) {
                return new StaggeredHelper(){

                    public boolean isTickLabelStaggered(int index) {
                        return false;
                    }
                };
            }
            if (iLabelShowingInterval < 2) {
                return new StaggeredHelper(){

                    public boolean isTickLabelStaggered(int index) {
                        if (StaggeredHelper.isIndexOutOfBound(index, iTickCount)) {
                            return false;
                        }
                        return index % 2 != 0;
                    }
                };
            }
            return new StaggeredHelper(){

                public boolean isTickLabelStaggered(int index) {
                    if (StaggeredHelper.isIndexOutOfBound(index, iTickCount)) {
                        return false;
                    }
                    return index % iLabelShowingInterval == 0 && index / iLabelShowingInterval % 2 != 0;
                }
            };
        }

        private static boolean isIndexOutOfBound(int index, int iTickCount) {
            return index < 0 || index > iTickCount - 1;
        }

        public abstract boolean isTickLabelStaggered(int var1);
    }
}

