/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ems.core.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.ems.core.managers.AbstractEnvManager;
import org.eclipse.ptp.internal.ems.core.messages.Messages;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;

public final class SoftEnvManager
extends AbstractEnvManager {
    private static final Pattern SOFTENV_COMMAND_PATTERN = Pattern.compile("[@+][A-Za-z0-9-_/.]+");

    @Override
    public String getName() {
        return "SoftEnv";
    }

    @Override
    public boolean checkForCompatibleInstallation(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        return this.getDescription(pm) != null;
    }

    @Override
    public String getDescription(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        Pattern pattern = Pattern.compile("^softenv is part of SoftEnv version ([^ \t\r\n]+).*");
        List<String> output = this.runCommand(pm, true, "bash", "--login", "-c", "softenv -v");
        if (output == null) {
            return null;
        }
        for (String line : output) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return "SoftEnv " + matcher.group(1);
        }
        return null;
    }

    @Override
    public String getInstructions() {
        return Messages.SoftEnvEnvManager_SelectSoftEnvCommands;
    }

    @Override
    public List<String> determineAvailableElements(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        List<String> output = this.runCommand(pm, false, "bash", "--login", "-c", "softenv -x; exit");
        if (output == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.collectModuleNamesFrom(output));
    }

    private List<String> collectModuleNamesFrom(List<String> output) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : output) {
            String key;
            if (!(line = line.trim()).startsWith("<key>") || !line.endsWith("</key>") || !SOFTENV_COMMAND_PATTERN.matcher(key = line.substring("<key>".length(), line.lastIndexOf("</key>"))).matches() || result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public List<String> determineDefaultElements(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        return Collections.emptyList();
    }

    @Override
    protected List<String> getInitialBashCommands(boolean echo) {
        if (echo) {
            return Arrays.asList("echo resoft", "resoft");
        }
        return Arrays.asList("resoft");
    }

    @Override
    protected List<String> getBashCommand(boolean echo, String softEnvCommand) {
        if (echo) {
            return Arrays.asList(String.format("echo 'soft add %s'", softEnvCommand), String.format("soft add %s", softEnvCommand));
        }
        return Arrays.asList(String.format("soft add %s", softEnvCommand));
    }
}

