/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.core.services.local;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.ptp.internal.remote.core.services.local.LocalConnection;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;

public class LocalConnectionManager
implements IRemoteConnectionManager {
    private final IRemoteConnection fLocalConnection;

    public LocalConnectionManager(IRemoteServices services) {
        this.fLocalConnection = new LocalConnection(services);
    }

    @Override
    public IRemoteConnection getConnection(String name) {
        if (name.equals(this.fLocalConnection.getName())) {
            return this.fLocalConnection;
        }
        return null;
    }

    @Override
    public IRemoteConnection getConnection(URI uri) {
        if (uri.getScheme().equals(EFS.getLocalFileSystem().getScheme())) {
            return this.fLocalConnection;
        }
        return null;
    }

    @Override
    public IRemoteConnection[] getConnections() {
        return new IRemoteConnection[]{this.fLocalConnection};
    }

    @Override
    public IRemoteConnection newConnection(String name) throws RemoteConnectionException {
        return this.fLocalConnection;
    }

    @Override
    public void removeConnection(IRemoteConnection connection) {
    }
}

