/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.remote.connection.ConnectionEditorDelegate;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RemoteConnectionCombo {
    private final ComboViewer connectionCombo;
    private ConnectionEditorDelegate delegate;

    public RemoteConnectionCombo(Composite parent) {
        this(parent, null);
    }

    public RemoteConnectionCombo(Composite parent, ConnectionEditorDelegate delegate) {
        this.delegate = delegate == null ? new DefaultDelegate() : delegate;
        this.connectionCombo = new ComboViewer(parent, 2056);
        this.connectionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.connectionCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IRemoteConnection)element).getName();
            }
        });
        this.connectionCombo.setSorter(new ViewerSorter(){

            public int category(Object element) {
                return ((IRemoteConnection)element).isLocalSystem() ? 0 : 1;
            }
        });
        try {
            IRemoteConnection[] connections = (IRemoteConnection[])CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, IRemoteConnection[]>(){

                public IRemoteConnection[] runWithService(IRemoteConnectionsService service) throws CoreException {
                    return service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
                }
            });
            this.connectionCombo.setInput((Object)connections);
            IRemoteConnection[] iRemoteConnectionArray = connections;
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteConnection connection = iRemoteConnectionArray[n2];
                if (connection.isLocalSystem()) {
                    this.connectionCombo.setSelection((ISelection)new StructuredSelection((Object)connection));
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.connectionCombo.addSelectionChangedListener(listener);
    }

    public Control getControl() {
        return this.connectionCombo.getControl();
    }

    public IRemoteConnection getSelection() {
        return (IRemoteConnection)CoreUtil.getSelectedObject((ISelectionProvider)this.connectionCombo, IRemoteConnection.class);
    }

    public IRemoteConnection manage() {
        try {
            IRemoteConnection selection = (IRemoteConnection)CoreUtil.getSelectedObject((ISelectionProvider)this.connectionCombo, IRemoteConnection.class);
            Tuple newConnection = (Tuple)CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new NewConnectionAction(this.getControl().getShell(), this.delegate, selection));
            this.connectionCombo.setInput(newConnection.getObject2());
            IRemoteConnection connection = (IRemoteConnection)newConnection.getObject1();
            this.connectionCombo.setSelection((ISelection)new StructuredSelection((Object)connection));
            return connection;
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public IObservableValue observeSelection() {
        return ViewersObservables.observeSingleSelection((Viewer)this.connectionCombo);
    }

    public void setSelection(IRemoteConnection remoteConnection) {
        this.connectionCombo.setSelection((ISelection)(remoteConnection == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)remoteConnection)));
    }

    public void setFilter(ViewerFilter viewerFilter) {
        this.connectionCombo.setFilters(new ViewerFilter[]{viewerFilter});
    }

    private final class DefaultDelegate
    extends ConnectionEditorDelegate {
        private DefaultDelegate() {
        }

        @Override
        public IRemoteConnection getSelectedConnection() {
            return RemoteConnectionCombo.this.getSelection();
        }
    }

    public static class DelegateDecorator
    extends ConnectionEditorDelegate {
        private final ConnectionEditorDelegate decorated;
        private final String oldName;
        private IRemoteConnection connection;

        public DelegateDecorator(ConnectionEditorDelegate delegate) {
            this.decorated = delegate;
            this.connection = delegate.getSelectedConnection();
            this.oldName = this.connection != null ? this.connection.getName() : null;
        }

        @Override
        public boolean canDelete(IRemoteConnection connection) {
            return this.decorated.canDelete(connection);
        }

        @Override
        public void removed(IRemoteConnection connection) {
            if (this.connection.equals(connection)) {
                this.connection = null;
            }
            this.decorated.removed(connection);
        }

        @Override
        public void renamed(String name, IRemoteConnection connection) {
            if (CoreUtil.equals((Object)this.oldName, (Object)name)) {
                this.connection = connection;
            }
            this.decorated.renamed(name, connection);
        }

        @Override
        public IRemoteConnection getSelectedConnection() {
            return this.decorated.getSelectedConnection();
        }

        public IRemoteConnection newSelection() {
            return this.connection;
        }
    }

    private static final class NewConnectionAction
    implements IOSGIServiceAccess<IRemoteConnectionsService, Tuple<IRemoteConnection, IRemoteConnection[], ?>> {
        private final Shell shell;
        private final ConnectionEditorDelegate delegate;

        public NewConnectionAction(Shell shell, ConnectionEditorDelegate delegate, IRemoteConnection selected) {
            this.shell = shell;
            this.delegate = delegate;
        }

        public Tuple<IRemoteConnection, IRemoteConnection[], ?> runWithService(IRemoteConnectionsService service) {
            DelegateDecorator decorator = new DelegateDecorator(this.delegate);
            IRemoteConnection connection = service.manage(this.shell, decorator);
            IRemoteConnection[] allConnections = service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
            if (connection == null) {
                IRemoteConnection[] iRemoteConnectionArray = allConnections;
                int n = allConnections.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteConnection c = iRemoteConnectionArray[n2];
                    if (c.isLocalSystem()) {
                        connection = c;
                        break;
                    }
                    ++n2;
                }
            }
            return Tuple.pair((Object)connection, (Object)allConnections);
        }
    }
}

