/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.plugin;

import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.plugin.ODAChoice;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.oda.util.manifest.PropertyChoice;

public class ODAPropertyDefn
extends SystemPropertyDefn {
    protected Property property = null;
    protected String displayName;

    ODAPropertyDefn(Property property) {
        assert (property != null);
        this.property = property;
        this.name = property.getName();
        this.displayName = property.getDisplayName();
        if (this.displayName != null && this.displayName.indexOf(38) != -1) {
            this.displayName = property.getDisplayName().replace("&", "");
        }
        this.type = MetaDataDictionary.getInstance().getPropertyType(property.getType());
    }

    public boolean isList() {
        return false;
    }

    public String getName() {
        return this.property.getName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameID() {
        return null;
    }

    public IChoiceSet getChoices() {
        PropertyChoice[] propertyChoices = this.property.getChoices();
        ChoiceSet choiceSet = null;
        if (propertyChoices != null && propertyChoices.length > 0) {
            choiceSet = new ChoiceSet();
            IChoice[] choices = new ODAChoice[propertyChoices.length];
            int i = 0;
            while (i < propertyChoices.length) {
                choices[i] = new ODAChoice(propertyChoices[i]);
                ++i;
            }
            choiceSet.setChoices(choices);
        }
        return choiceSet;
    }

    public boolean hasChoices() {
        return this.property.getChoices() != null && this.property.getChoices().length > 0;
    }

    public IStructureDefn getStructDefn() {
        return null;
    }

    public Object getDefault() {
        return this.property.getDefaultValue();
    }

    public IElementDefn getTargetElementType() {
        return null;
    }

    public IChoiceSet getAllowedChoices() {
        return this.getChoices();
    }

    public boolean isEncryptable() {
        return this.property.isEncryptable();
    }

    public int getValueType() {
        return 4;
    }

    public void build() throws MetaDataException {
        PropertyType tmpType = MetaDataDictionary.getInstance().getPropertyType(this.property.getType());
        if (tmpType == null) {
            return;
        }
        if (tmpType.getTypeCode() == 0 && !this.property.allowsEmptyValueAsNull()) {
            this.setType(MetaDataDictionary.getInstance().getPropertyType(21));
        }
        super.build();
    }
}

