/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class TableRowPropSearchStrategy
extends PropertySearchStrategy {
    private static final TableRowPropSearchStrategy instance = new TableRowPropSearchStrategy();

    protected TableRowPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    protected Object getNonIntrinsicPropertyFromElement(Module module, DesignElement element, ElementPropertyDefn prop) {
        if ("textAlign".equalsIgnoreCase(prop.getName())) {
            Object value = super.getNonIntrinsicPropertyFromElement(module, element, prop);
            if (value != null) {
                return value;
            }
            DesignElement container = element.getContainer();
            if (container instanceof TableItem && element.getContainerInfo().getSlotID() == 0 && (value = this.getPropertyExceptRomDefault(module, container, prop)) == null) {
                return "center";
            }
            return null;
        }
        return super.getNonIntrinsicPropertyFromElement(module, element, prop);
    }

    public Object getPropertyFromSlotSelector(Module module, DesignElement element, ElementPropertyDefn prop, PropertySearchStrategy.PropertyValueInfo valueInfo) {
        Object value = super.getPropertyFromSlotSelector(module, element, prop, valueInfo);
        if (value != null) {
            return value;
        }
        DesignElement rowContainer = element.getContainer();
        if (rowContainer == null) {
            return null;
        }
        String selector = null;
        if (rowContainer instanceof TableItem) {
            selector = "table-row";
        }
        return super.getPropertyFromSelector(module, element, prop, selector, valueInfo);
    }
}

