/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IModuleOption;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.impl.SimpleElementFactory;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.simpleapi.ReportDesign;

public class DesignEngineImpl
implements IDesignEngine {
    private static boolean initialized = false;
    private DesignConfig designConfig;

    public DesignEngineImpl(DesignConfig config) {
        this.designConfig = config;
        DesignEngineImpl.ensureInitialized();
    }

    public SessionHandle newSessionHandle(ULocale locale) {
        IResourceLocator locator;
        DesignEngineImpl.ensureInitialized();
        SessionHandle session = new SessionHandle(locale);
        if (this.designConfig != null && (locator = this.designConfig.getResourceLocator()) != null) {
            session.setResourceLocator(locator);
        }
        return session;
    }

    static synchronized void ensureInitialized() {
        MetaDataDictionary.initialize();
        if (!initialized) {
            org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory.setInstance(new SimpleElementFactory());
            initialized = true;
        }
    }

    public IMetaDataDictionary getMetaData() {
        DesignEngineImpl.ensureInitialized();
        return MetaDataDictionary.getInstance();
    }

    public void registerMetaLogger(IMetaLogger newLogger) {
        MetaLogManager.registerLogger(newLogger);
    }

    public boolean removeMetaLogger(IMetaLogger logger) {
        return MetaLogManager.removeLogger(logger);
    }

    public IReportDesign openDesign(String fileName, InputStream ins, IModuleOption options) throws DesignFileException {
        SessionHandle tmpSession = this.newSessionHandle(null);
        return new ReportDesign(tmpSession.openDesign(fileName, ins, (ModuleOption)options));
    }
}

