/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.chart.ui;

import com.nvidia.viper.chart.IColorDefinitionsManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SWTColorsManager
implements IColorDefinitionsManager {
    private static final float MIN_PALETTE_COLOR_SATURATION = 0.5f;
    private static final float MIN_LIGHT_GREY_LUMINOUSITY = 0.95f;
    private final Map<IColorDefinitionsManager.ChartColor, RGB> colors = new HashMap<IColorDefinitionsManager.ChartColor, RGB>(IColorDefinitionsManager.ChartColor.values().length);
    private final RGB colorPaletteSeed;

    public SWTColorsManager(Display display) {
        this.colorPaletteSeed = display.getSystemColor(26).getRGB();
        this.addColor(IColorDefinitionsManager.ChartColor.AXIS, display, 16);
        this.addColor(IColorDefinitionsManager.ChartColor.BACKGROUND, display, 25);
        this.addColor(IColorDefinitionsManager.ChartColor.HIGHLIGHTED_BACKGROUND, display, 31, 0.2f);
        this.addColor(IColorDefinitionsManager.ChartColor.V_GUIDES, display, 9);
        this.addColor(IColorDefinitionsManager.ChartColor.MINOR_GRID_TICKS, 0.0f, 0.0f, 0.8f);
        RGB newRGB = this.lightSystemGrey(display);
        this.colors.put(IColorDefinitionsManager.ChartColor.H_GUIDES, newRGB);
        if (this.colors.size() < IColorDefinitionsManager.ChartColor.values().length) {
            StringBuilder message = new StringBuilder("Following chart colors were not set: ");
            boolean first = true;
            IColorDefinitionsManager.ChartColor[] chartColorArray = IColorDefinitionsManager.ChartColor.values();
            int n = chartColorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IColorDefinitionsManager.ChartColor chartColor = chartColorArray[n2];
                if (!this.colors.containsKey((Object)chartColor)) {
                    message.append(!first ? ", " : "").append(chartColor.name());
                    first = false;
                }
                ++n2;
            }
            throw new IllegalStateException(message.toString());
        }
    }

    protected SWTColorsManager(Display display, RGB colorPaletteSeed) {
        this.colorPaletteSeed = colorPaletteSeed;
        this.addColor(IColorDefinitionsManager.ChartColor.AXIS, display, 16);
        this.addColor(IColorDefinitionsManager.ChartColor.BACKGROUND, display, 1);
        this.addColor(IColorDefinitionsManager.ChartColor.HIGHLIGHTED_BACKGROUND, display, 1, 0.2f);
        this.addColor(IColorDefinitionsManager.ChartColor.V_GUIDES, display, 9);
        this.addColor(IColorDefinitionsManager.ChartColor.MINOR_GRID_TICKS, 0.0f, 0.0f, 0.8f);
        this.addColor(IColorDefinitionsManager.ChartColor.H_GUIDES, 0.0f, 0.0f, 0.91f);
    }

    RGB lightSystemGrey(Display display) {
        RGB rgb = this.colorToRgb(display, 15);
        float[] hsb = rgb.getHSB();
        float luminousity = Math.max(hsb[2], 0.95f);
        RGB newRGB = new RGB(hsb[0], hsb[1], luminousity);
        return newRGB;
    }

    private void addColor(IColorDefinitionsManager.ChartColor constant, float h, float s, float b) {
        this.colors.put(constant, new RGB(h, s, b));
    }

    private void addColor(IColorDefinitionsManager.ChartColor constant, Display display, int systemColor, float saturation) {
        this.colors.put(constant, this.adjustSaturation(this.colorToRgb(display, systemColor), saturation));
    }

    private RGB adjustSaturation(RGB rgb, float saturation) {
        float[] hsb = rgb.getHSB();
        return new RGB(hsb[0], hsb[1] * saturation, hsb[2]);
    }

    private void addColor(IColorDefinitionsManager.ChartColor constant, Display display, int systemColor) {
        this.colors.put(constant, this.colorToRgb(display, systemColor));
    }

    private RGB colorToRgb(Display display, int systemColor) {
        Color color = display.getSystemColor(systemColor);
        return color.getRGB();
    }

    @Override
    public ColorDefinition getColor(IColorDefinitionsManager.ChartColor color) {
        RGB rgb = this.colors.get((Object)color);
        return ColorDefinitionImpl.create((int)rgb.red, (int)rgb.green, (int)rgb.blue);
    }

    @Override
    public ColorDefinition getPaletteColor(int index) {
        if (index < 0) {
            return null;
        }
        int colorSegment = (index + 1) / 2;
        int direction = (index & 1) == 1 ? 1 : -1;
        float[] hsb = this.colorPaletteSeed.getHSB();
        int hue = (int)hsb[0];
        hue += 375;
        hue += direction * colorSegment * 30;
        float saturation = Math.max(hsb[1], 0.5f);
        RGB newColor = new RGB((float)(hue %= 360), saturation, hsb[2]);
        return ColorDefinitionImpl.create((int)newColor.red, (int)newColor.green, (int)newColor.blue);
    }

    public static synchronized IColorDefinitionsManager forDisplay(Display display) {
        return new SWTColorsManager(display);
    }

    public static synchronized IColorDefinitionsManager forReport(Display display) {
        RGB colorPaletteSeed = display.getSystemColor(26).getRGB();
        return new SWTColorsManager(display, colorPaletteSeed);
    }
}

