/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc.document;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.toc.ITOCConstants;
import org.eclipse.birt.report.engine.toc.ITOCReader;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TreeNode;
import org.eclipse.birt.report.engine.toc.document.MemTreeNode;

public class TOCReaderV2
implements ITOCReader,
ITOCConstants {
    TreeNode root;

    public TOCReaderV2(InputStream in, ClassLoader loader) throws IOException {
        this(in, loader, false);
    }

    public TOCReaderV2(InputStream in, ClassLoader loader, boolean checkVersion) throws IOException {
        String version;
        DataInputStream input = new DataInputStream(in);
        if (checkVersion && !"__Version : 2.0".equals(version = IOUtil.readString((DataInputStream)input))) {
            throw new IOException("Unsupported version:" + version);
        }
        this.root = this.readNode(input, loader);
    }

    public void close() throws IOException {
    }

    public ITreeNode readTree() throws IOException {
        return this.root;
    }

    public MemTreeNode readNode(DataInputStream input, ClassLoader loader) throws IOException {
        MemTreeNode node = new MemTreeNode();
        String nodeId = IOUtil.readString((DataInputStream)input);
        IOUtil.readString((DataInputStream)input);
        String bookmark = IOUtil.readString((DataInputStream)input);
        String hiddenFormats = IOUtil.readString((DataInputStream)input);
        boolean isGroupRoot = IOUtil.readBool((InputStream)input);
        Object tocValue = IOUtil.readObject((DataInputStream)input, (ClassLoader)loader);
        long elementId = IOUtil.readLong((DataInputStream)input);
        node.setNodeId(nodeId);
        node.setBookmark(bookmark);
        node.setHiddenFormats(hiddenFormats);
        node.setGroup(isGroupRoot);
        node.setTOCValue(tocValue);
        node.setElementId(elementId);
        int size = IOUtil.readInt((InputStream)input);
        int i = 0;
        while (i < size) {
            MemTreeNode child = this.readNode(input, loader);
            node.addChild(child);
            ++i;
        }
        return node;
    }
}

