/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.toc.ITreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeNode
implements ITreeNode {
    private String nodeId;
    private String bookmark;
    private boolean isGroup;
    private String hiddenFormats;
    private Object tocValue;
    private long elementId = -1L;
    protected static final short FIELD_NONE = -1;
    protected static final short FIELD_NODE_ID = 1;
    protected static final short FIELD_BOOKMARK = 2;
    protected static final short FIELD_TOC_VALUE = 3;
    protected static final short FIELD_HIDDEN_FORMATS = 4;
    protected static final short FIELD_ELEMENT_ID = 5;
    protected static final short FIELD_GROUP = 6;

    public TreeNode() {
    }

    public TreeNode(TreeNode node) {
        this.nodeId = node.nodeId;
        this.bookmark = node.bookmark;
        this.isGroup = node.isGroup;
        this.hiddenFormats = node.hiddenFormats;
        this.tocValue = node.tocValue;
        this.elementId = node.elementId;
    }

    @Override
    public abstract Collection<ITreeNode> getChildren();

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getBookmark() {
        return this.bookmark;
    }

    @Override
    public boolean isGroup() {
        return this.isGroup;
    }

    @Override
    public String getHiddenFormats() {
        return this.hiddenFormats;
    }

    @Override
    public Object getTOCValue() {
        return this.tocValue;
    }

    @Override
    public long getElementId() {
        return this.elementId;
    }

    public void setNodeId(String id) {
        this.nodeId = id;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public void setGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public void setHiddenFormats(String format) {
        this.hiddenFormats = format;
    }

    public void setTOCValue(Object value) {
        this.tocValue = value;
    }

    public void setElementId(long elementId) {
        this.elementId = elementId;
    }

    public void readNode(DataInputStream in, ClassLoader loader) throws IOException {
        short field = IOUtil.readShort((InputStream)in);
        while (field != -1) {
            switch (field) {
                case 1: {
                    this.bookmark = this.nodeId = IOUtil.readString((DataInputStream)in);
                    break;
                }
                case 2: {
                    this.bookmark = IOUtil.readString((DataInputStream)in);
                    break;
                }
                case 3: {
                    this.tocValue = IOUtil.readObject((DataInputStream)in, (ClassLoader)loader);
                    break;
                }
                case 4: {
                    this.hiddenFormats = IOUtil.readString((DataInputStream)in);
                    break;
                }
                case 5: {
                    this.elementId = IOUtil.readLong((DataInputStream)in);
                    break;
                }
                case 6: {
                    this.isGroup = IOUtil.readBool((InputStream)in);
                    break;
                }
                default: {
                    throw new IOException("undefined toc filed:" + field);
                }
            }
            field = IOUtil.readShort((InputStream)in);
        }
    }

    public void writeNode(DataOutputStream out) throws IOException {
        IOUtil.writeShort((OutputStream)out, (short)1);
        IOUtil.writeString((DataOutputStream)out, (String)this.nodeId);
        if (!this.nodeId.equals(this.bookmark)) {
            IOUtil.writeShort((OutputStream)out, (short)2);
            IOUtil.writeString((DataOutputStream)out, (String)this.bookmark);
        }
        if (this.tocValue != null) {
            IOUtil.writeShort((OutputStream)out, (short)3);
            IOUtil.writeObject((DataOutputStream)out, (Object)this.tocValue);
        }
        if (this.hiddenFormats != null) {
            IOUtil.writeShort((OutputStream)out, (short)4);
            IOUtil.writeString((DataOutputStream)out, (String)this.hiddenFormats);
        }
        if (this.isGroup) {
            IOUtil.writeShort((OutputStream)out, (short)6);
            IOUtil.writeBool((OutputStream)out, (boolean)this.isGroup);
        }
        IOUtil.writeShort((OutputStream)out, (short)5);
        IOUtil.writeLong((DataOutputStream)out, (long)this.elementId);
        IOUtil.writeShort((OutputStream)out, (short)-1);
    }
}

