/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractLengthManager;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class BorderWidthManager
extends AbstractLengthManager {
    protected static final StringMap values = new StringMap();
    protected static final StringMap computedValues;
    String propertyName;

    static {
        values.put("thin", CSSValueConstants.THIN_VALUE);
        values.put("medium", CSSValueConstants.MEDIUM_VALUE);
        values.put("thick", CSSValueConstants.THICK_VALUE);
        computedValues = new StringMap();
        computedValues.put("thin", new FloatValue(5, 1.0f));
        computedValues.put("medium", new FloatValue(5, 3.0f));
        computedValues.put("thick", new FloatValue(5, 5.0f));
    }

    public BorderWidthManager(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isInheritedProperty() {
        return false;
    }

    public Value getDefaultValue() {
        return CSSValueConstants.MEDIUM_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                String s = lu.getStringValue().toLowerCase().intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return (Value)v;
            }
        }
        return super.createValue(lu, engine);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        String ident;
        Value cv;
        IStyle cs = elt.getComputedStyle();
        CSSValue borderStyle = null;
        switch (idx) {
            case 41: {
                borderStyle = cs.getProperty(49);
                break;
            }
            case 11: {
                borderStyle = cs.getProperty(22);
                break;
            }
            case 42: {
                borderStyle = cs.getProperty(52);
                break;
            }
            case 10: {
                borderStyle = cs.getProperty(21);
            }
        }
        if (borderStyle == CSSValueConstants.NONE_VALUE || borderStyle == CSSValueConstants.HIDDEN_VALUE) {
            return CSSValueConstants.NUMBER_0;
        }
        if (value.getCssValueType() == 1 && value.getPrimitiveType() == 21 && (cv = (Value)computedValues.get(ident = value.getStringValue())) != null) {
            value = cv;
        }
        return super.computeValue(elt, engine, idx, value);
    }
}

