/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractValueManager;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class AbstractLengthManager
extends AbstractValueManager {
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 15: {
                return new FloatValue(3, lu.getFloatValue());
            }
            case 16: {
                return new FloatValue(4, lu.getFloatValue());
            }
            case 17: {
                return new FloatValue(5, lu.getFloatValue());
            }
            case 19: {
                return new FloatValue(6, lu.getFloatValue());
            }
            case 20: {
                return new FloatValue(7, lu.getFloatValue());
            }
            case 18: {
                return new FloatValue(8, lu.getFloatValue());
            }
            case 21: {
                return new FloatValue(9, lu.getFloatValue());
            }
            case 22: {
                return new FloatValue(10, lu.getFloatValue());
            }
            case 13: {
                return new FloatValue(1, lu.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lu.getFloatValue());
            }
            case 23: {
                return new FloatValue(2, lu.getFloatValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return value;
                }
                case 3: {
                    float v = value.getFloatValue();
                    Value fontSize = (Value)elt.getComputedStyle().getProperty(39);
                    float fs = fontSize.getFloatValue();
                    return new FloatValue(fontSize.getPrimitiveType(), v * fs);
                }
                case 4: {
                    float v = value.getFloatValue();
                    Value fontSize = (Value)elt.getComputedStyle().getProperty(39);
                    float fs = fontSize.getFloatValue();
                    return new FloatValue(fontSize.getPrimitiveType(), v * fs * 0.5f);
                }
            }
        }
        return value;
    }
}

