/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.device.ImageWriterFactory;
import org.eclipse.birt.chart.util.SecurityUtil;

public class SVGImage
extends Image {
    protected Image image;
    protected URL url;
    protected byte[] data;
    public static final String BASE64 = "data:;base64,";

    public byte[] getData() {
        return this.data;
    }

    public SVGImage(Image image, URL url) {
        this(image, url, null);
    }

    public SVGImage(Image image, URL url, byte[] data) {
        this.image = image;
        this.url = url;
        this.data = data;
        if (url == null && data == null && image instanceof BufferedImage) {
            ImageWriter iw = ImageWriterFactory.instance().createImageWriter("png", "html");
            try {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
                    ImageOutputStream ios = SecurityUtil.newImageOutputStream((Object)baos);
                    ImageWriteParam iwp = iw.getDefaultWriteParam();
                    iw.setOutput(ios);
                    iw.write(null, new IIOImage((BufferedImage)image, null, null), iwp);
                    ios.close();
                    this.data = baos.toByteArray();
                    baos.close();
                }
                catch (IOException iOException) {
                    iw.dispose();
                }
            }
            finally {
                iw.dispose();
            }
        }
    }

    public void flush() {
        this.image.flush();
    }

    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    public int getHeight(ImageObserver arg0) {
        return this.image.getHeight(arg0);
    }

    public Object getProperty(String arg0, ImageObserver arg1) {
        return this.image.getProperty(arg0, arg1);
    }

    public Image getScaledInstance(int arg0, int arg1, int arg2) {
        return new SVGImage(this.image.getScaledInstance(arg0, arg1, arg2), this.url, this.data);
    }

    public ImageProducer getSource() {
        return this.image.getSource();
    }

    public int getWidth(ImageObserver arg0) {
        return this.image.getWidth(arg0);
    }

    public String getUrl() {
        if (this.url == null) {
            if (this.data != null) {
                return BASE64 + new String(Base64.encodeBase64((byte[])this.data));
            }
            return "";
        }
        return this.url.toExternalForm();
    }

    public void setUrl(URL url) {
        this.url = url;
    }
}

