/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.toolkit;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.build.core.Activator;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;

public final class CudaToolkitVariableResolver
implements IDynamicVariableResolver {
    protected static ICudaToolkit getCUDAToolkit(final String name) {
        try {
            return (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                    return name != null && service.isInitialized() ? service.getToolkit(name) : service.getDefaultToolkit();
                }
            });
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    protected String getProjectConnectionName(IProject project) {
        SyncConfig config;
        SyncConfig syncConfig = config = project != null ? SyncConfigManager.getActive((IProject)project) : null;
        if (config == null || SyncConfigManager.isLocal((SyncConfig)config)) {
            return null;
        }
        return config.getConnectionName();
    }

    protected String getProjectConnectionName(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = projectName != null ? root.getProject(projectName) : null;
        return this.getProjectConnectionName(project);
    }

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        if ("cuda_bin".equals(variable.getName())) {
            ICudaToolkit toolkit = CudaToolkitVariableResolver.getCUDAToolkit(argument);
            return toolkit != null ? toolkit.getBinDirectory() : null;
        }
        if ("cuda_samples_dir".equals(variable.getName())) {
            String connectionName = this.getProjectConnectionName(argument);
            ICudaToolkit toolkit = CudaToolkitVariableResolver.getCUDAToolkit(connectionName);
            String bindir = toolkit != null ? toolkit.getBinDirectory() : null;
            try {
                File bindirParentFile = new File(bindir).getParentFile();
                return new File(bindirParentFile, "samples").getCanonicalPath();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

