/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.nvccsupport;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.build.core.Activator;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.make.internal.core.scannerconfig2.GCCSpecsRunSIProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class GccNvccRunSpecsProvider
extends GCCSpecsRunSIProvider
implements IOSGIServiceAccess<IToolkitManager, IPath> {
    private final AtomicReference<IPath> path = new AtomicReference();

    protected IPath getCommandToLaunch() {
        if (this.path.get() == null) {
            this.path.set(this.getNvccPath(super.getCommandToLaunch()));
        }
        return this.path.get();
    }

    private IPath getNvccPath(IPath commandToLaunch) {
        try {
            IPath nvcc = (IPath)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)this);
            return nvcc != null ? nvcc : commandToLaunch;
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return commandToLaunch;
        }
    }

    public IPath runWithService(IToolkitManager service) {
        String toolPath;
        ICudaToolkit toolkit = service.getDefaultToolkit();
        if (toolkit != null && (toolPath = toolkit.getToolPath(ICudaToolkit.Tool.Nvcc)) != null) {
            return new Path(toolPath);
        }
        return null;
    }
}

