/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.breakpoints;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.breakpoints.BreakpointsMessages;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointContext;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

class CBreakpointContextWorkbenchAdapter
implements IWorkbenchAdapter {
    CBreakpointContextWorkbenchAdapter() {
    }

    public String getLabel(Object o) {
        if (o instanceof ICBreakpointContext) {
            ICBreakpoint bp = ((ICBreakpointContext)o).getBreakpoint();
            return this.getBreakpointMainLabel(bp);
        }
        return "";
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    private String getBreakpointMainLabel(ICBreakpoint breakpoint) {
        if (breakpoint instanceof ICFunctionBreakpoint) {
            return BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_function_label");
        }
        if (breakpoint instanceof ICAddressBreakpoint) {
            return BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_address_label");
        }
        if (breakpoint instanceof ICLineBreakpoint) {
            return BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_line_label");
        }
        if (breakpoint instanceof ICEventBreakpoint) {
            return BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_event_label");
        }
        if (breakpoint instanceof ICWatchpoint) {
            return BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_watchpoint_label");
        }
        return CDIDebugModel.calculateMarkerType((IBreakpoint)breakpoint);
    }
}

