/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugElementStatus;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.IEnableDisableTarget;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.disassembly.rendering.DisassemblyEditorInput;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.CBreakpointPropertyDialogAction;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class CDebugUIUtils {
    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static ICStackFrame getCurrentStackFrame() {
        IAdaptable context = DebugUITools.getDebugContext();
        return context != null ? (ICStackFrame)context.getAdapter(ICStackFrame.class) : null;
    }

    public static String getValueText(IValue value) {
        StringBuffer label = new StringBuffer();
        if (value instanceof ICDebugElementStatus && !((ICDebugElementStatus)value).isOK()) {
            label.append(MessageFormat.format((String)CDebugUIMessages.getString("CDTDebugModelPresentation.4"), (Object[])new String[]{((ICDebugElementStatus)value).getMessage()}));
        } else if (value instanceof ICValue) {
            ICType type = null;
            try {
                type = ((ICValue)value).getType();
            }
            catch (DebugException debugException) {}
            try {
                String valueString = value.getValueString();
                if (valueString != null) {
                    valueString = valueString.trim();
                    if (type != null && type.isCharacter()) {
                        if (valueString.length() == 0) {
                            valueString = ".";
                        }
                        label.append(valueString);
                    } else if (type != null && type.isFloatingPointType()) {
                        Number floatingPointValue = CDebugUtils.getFloatingPointValue((ICValue)((ICValue)value));
                        if (CDebugUtils.isNaN((Number)floatingPointValue)) {
                            valueString = "NAN";
                        }
                        if (CDebugUtils.isPositiveInfinity((Number)floatingPointValue)) {
                            valueString = CDebugUIMessages.getString("CDTDebugModelPresentation.23");
                        }
                        if (CDebugUtils.isNegativeInfinity((Number)floatingPointValue)) {
                            valueString = CDebugUIMessages.getString("CDTDebugModelPresentation.24");
                        }
                        label.append(valueString);
                    } else if (valueString.length() > 0) {
                        label.append(valueString);
                    }
                }
            }
            catch (DebugException debugException) {}
        }
        return label.toString();
    }

    public static String getVariableTypeName(ICType type) {
        StringBuffer result = new StringBuffer();
        if (type != null) {
            int index;
            String typeName = type.getName();
            if (typeName != null) {
                typeName = typeName.trim();
            }
            if (type.isArray() && typeName != null && (index = typeName.indexOf(91)) != -1) {
                typeName = typeName.substring(0, index).trim();
            }
            if (typeName != null && typeName.length() > 0) {
                result.append(typeName);
                if (type.isArray()) {
                    int[] dims = type.getArrayDimensions();
                    int i = 0;
                    while (i < dims.length) {
                        result.append('[');
                        result.append(dims[i]);
                        result.append(']');
                        ++i;
                    }
                }
            }
        }
        return result.toString();
    }

    public static String getVariableName(IVariable variable) throws DebugException {
        return CDebugUIUtils.decorateText(variable, variable.getName());
    }

    public static String getEditorFilePath(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocation().toOSString();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getFullPath().toOSString();
        }
        if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath().toOSString();
        }
        if (input instanceof DisassemblyEditorInput) {
            String sourceFile = ((DisassemblyEditorInput)input).getSourceFile();
            if (sourceFile != null) {
                return sourceFile;
            }
            return ((DisassemblyEditorInput)input).getModuleFile();
        }
        if (input instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)input).getURI();
            if (uri.getScheme() == null || "file".equals(uri.getScheme())) {
                IPath uriPath = URIUtil.toPath((URI)uri);
                if (uriPath != null) {
                    return uriPath.toOSString();
                }
            } else {
                return uri.toASCIIString();
            }
        }
        return "";
    }

    public static String decorateText(Object element, String text) {
        IEnableDisableTarget target;
        if (text == null) {
            return null;
        }
        StringBuffer baseText = new StringBuffer(text);
        if (element instanceof ICDebugElementStatus && !((ICDebugElementStatus)element).isOK()) {
            baseText.append(MessageFormat.format((String)" <{0}>", (Object[])new Object[]{((ICDebugElementStatus)element).getMessage()}));
        }
        if (element instanceof IAdaptable && (target = (IEnableDisableTarget)((IAdaptable)element).getAdapter(IEnableDisableTarget.class)) != null && !target.isEnabled()) {
            baseText.append(' ');
            baseText.append(CDebugUIMessages.getString("CDTDebugModelPresentation.25"));
        }
        return baseText.toString();
    }

    public static void openError(final String title, final String message, final Exception e) {
        UIJob uiJob = new UIJob("open error"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String detail = "";
                if (e != null) {
                    detail = e.getMessage();
                }
                Shell shell = CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(message) + "\n" + detail));
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    public static IBreakpoint getBreakpointFromEditor(ITextEditor editor, IVerticalRulerInfo info) {
        IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != info.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    public static void editBreakpointProperties(IWorkbenchPart part, final ICBreakpoint bp) {
        final ISelection debugContext = DebugUITools.getDebugContextForPart((IWorkbenchPart)part);
        CBreakpointPropertyDialogAction propertiesAction = new CBreakpointPropertyDialogAction((IShellProvider)part.getSite(), new ISelectionProvider(){

            public ISelection getSelection() {
                return new StructuredSelection((Object)bp);
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        }, new IDebugContextProvider(){

            public ISelection getActiveContext() {
                return debugContext;
            }

            public void addDebugContextListener(IDebugContextListener listener) {
            }

            public void removeDebugContextListener(IDebugContextListener listener) {
            }

            public IWorkbenchPart getPart() {
                return null;
            }
        });
        propertiesAction.run();
        propertiesAction.dispose();
    }

    public static final String formatKeyBindingString(int modifierKeys, String keyOrClick) {
        return String.valueOf(KeyStroke.getInstance((int)modifierKeys, (int)0).format()) + keyOrClick;
    }
}

