/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCrosstabModelTask
implements ICrosstabConstants {
    protected CrosstabReportItemHandle crosstab = null;

    public AbstractCrosstabModelTask(AbstractCrosstabItemHandle focus) {
        if (focus == null) {
            throw new IllegalArgumentException("The focus for the task can not be null");
        }
        this.crosstab = focus.getCrosstab();
    }

    protected AggregationInfo getAggregationInfo(LevelViewHandle leftLevelView, LevelViewHandle rightLevelView) {
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        if (leftLevelView == null) {
            if (rightLevelView != null) {
                if (rightLevelView.getCrosstab() != this.crosstab || rightLevelView.getCubeLevelName() == null || rightLevelView.getCubeLevelName().length() == 0) {
                    return null;
                }
                int axisType = rightLevelView.getAxisType();
                if (axisType == 1) {
                    colDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    colLevel = rightLevelView.getCubeLevelName();
                } else {
                    rowDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = rightLevelView.getCubeLevelName();
                }
            }
        } else {
            if (leftLevelView.getCrosstab() != this.crosstab || leftLevelView.getCubeLevelName() == null || leftLevelView.getCubeLevelName().length() == 0) {
                return null;
            }
            if (rightLevelView == null) {
                int axisType = leftLevelView.getAxisType();
                if (axisType == 1) {
                    colDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    colLevel = leftLevelView.getCubeLevelName();
                } else {
                    rowDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = leftLevelView.getCubeLevelName();
                }
            } else {
                if (rightLevelView.getCrosstab() != this.crosstab || rightLevelView.getCubeLevelName() == null || rightLevelView.getCubeLevelName().length() == 0) {
                    return null;
                }
                int axisType = leftLevelView.getAxisType();
                if (rightLevelView.getAxisType() != CrosstabModelUtil.getOppositeAxisType(axisType)) {
                    return null;
                }
                if (axisType == 1) {
                    colDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    colLevel = leftLevelView.getCubeLevelName();
                    rowDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = rightLevelView.getCubeLevelName();
                } else {
                    rowDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = leftLevelView.getCubeLevelName();
                    colDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    colLevel = rightLevelView.getCubeLevelName();
                }
            }
        }
        return new AggregationInfo(rowDimension, rowLevel, colDimension, colLevel);
    }

    protected boolean isValidParameters(List<String> functions, List<MeasureViewHandle> measures) {
        if (functions == null || measures == null) {
            return false;
        }
        if (measures.size() == 0 || functions.size() == 0) {
            return false;
        }
        return measures.size() == functions.size();
    }

    protected void verifyTotalMeasureFunctions(int axisType, List<String> functions, List<MeasureViewHandle> measures) {
        if (functions == null || measures == null || functions.size() == 0 || measures.size() == 0) {
            return;
        }
        boolean isVerticalMeasure = "vertical".equals(this.crosstab.getMeasureDirection());
        if (isVerticalMeasure && axisType == 1 || !isVerticalMeasure && axisType == 0) {
            String defaultFunction = functions.get(0);
            int i = 0;
            while (i < this.crosstab.getMeasureCount()) {
                MeasureViewHandle mv = this.crosstab.getMeasure(i);
                if (!measures.contains(mv)) {
                    measures.add(mv);
                    functions.add(defaultFunction);
                }
                ++i;
            }
        }
    }

    protected void addMeasureAggregations(LevelViewHandle theLevelView, List<MeasureViewHandle> measureList, List<String> functionList, boolean checkCounterAxis) throws SemanticException {
        if (this.crosstab == null || theLevelView.getCrosstab() != this.crosstab) {
            return;
        }
        if (measureList == null || measureList.isEmpty()) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(theLevelView.getAxisType());
        String dimensionName = ((DimensionViewHandle)theLevelView.getContainer()).getCubeDimensionName();
        String levelName = theLevelView.getCubeLevelName();
        if (levelName == null || dimensionName == null) {
            return;
        }
        boolean isInnerMost = theLevelView.isInnerMost();
        boolean isCounterAxisEmpty = true;
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle dimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < dimensionView.getLevelCount()) {
                isCounterAxisEmpty = false;
                LevelViewHandle levelView = dimensionView.getLevel(level);
                String rowDimension = null;
                String rowLevel = null;
                String colDimension = null;
                String colLevel = null;
                if (counterAxisType == 0) {
                    rowDimension = dimensionView.getCubeDimensionName();
                    rowLevel = levelView.getCubeLevelName();
                    colDimension = dimensionName;
                    colLevel = levelName;
                } else if (counterAxisType == 1) {
                    rowDimension = dimensionName;
                    rowLevel = levelName;
                    colDimension = dimensionView.getCubeDimensionName();
                    colLevel = levelView.getCubeLevelName();
                }
                if (isInnerMost && !levelView.isInnerMost() && levelView.getAggregationHeader() != null || !isInnerMost && theLevelView.getAggregationHeader() != null && (levelView.isInnerMost() || levelView.getAggregationHeader() != null)) {
                    int i = 0;
                    while (i < measureList.size()) {
                        MeasureViewHandle measureView = measureList.get(i);
                        if (measureView.getCrosstab() == this.crosstab) {
                            String function;
                            String string = function = functionList == null ? CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView) : functionList.get(i);
                            if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, levelView.getCubeLevelName(), counterAxisType)) {
                                this.validateSingleMeasureAggregation(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                            }
                        }
                        ++i;
                    }
                }
                ++level;
            }
            ++dimension;
        }
        if (this.crosstab.getGrandTotal(counterAxisType) != null || isCounterAxisEmpty && theLevelView.getAggregationHeader() != null) {
            String rowDimension = null;
            String rowLevel = null;
            String colDimension = null;
            String colLevel = null;
            if (counterAxisType == 0) {
                colDimension = dimensionName;
                colLevel = levelName;
            } else if (counterAxisType == 1) {
                rowDimension = dimensionName;
                rowLevel = levelName;
            }
            int i = 0;
            while (i < measureList.size()) {
                MeasureViewHandle measureView = measureList.get(i);
                if (measureView.getCrosstab() == this.crosstab) {
                    String function;
                    String string = function = functionList == null ? CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView) : functionList.get(i);
                    if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, null, counterAxisType)) {
                        this.validateSingleMeasureAggregation(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                    }
                }
                ++i;
            }
        }
    }

    protected void addMeasureAggregations(int axisType, List<MeasureViewHandle> measureList, List<String> functionList, boolean checkCounterAxis) throws SemanticException {
        if (this.crosstab == null || measureList == null || measureList.isEmpty() || this.crosstab.getGrandTotal(axisType) == null) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
        String dimensionName = null;
        String levelName = null;
        boolean isCounterAxisEmpty = true;
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle dimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < dimensionView.getLevelCount()) {
                isCounterAxisEmpty = false;
                LevelViewHandle levelView = dimensionView.getLevel(level);
                String rowDimension = null;
                String rowLevel = null;
                String colDimension = null;
                String colLevel = null;
                if (counterAxisType == 0) {
                    rowDimension = dimensionView.getCubeDimensionName();
                    rowLevel = levelView.getCubeLevelName();
                    colDimension = dimensionName;
                    colLevel = levelName;
                } else if (counterAxisType == 1) {
                    rowDimension = dimensionName;
                    rowLevel = levelName;
                    colDimension = dimensionView.getCubeDimensionName();
                    colLevel = levelView.getCubeLevelName();
                }
                if (levelView.isInnerMost() || levelView.getAggregationHeader() != null) {
                    int i = 0;
                    while (i < measureList.size()) {
                        MeasureViewHandle measureView = measureList.get(i);
                        if (measureView.getCrosstab() == this.crosstab) {
                            String function;
                            String string = function = functionList == null ? CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView) : functionList.get(i);
                            if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, levelView.getCubeLevelName(), counterAxisType)) {
                                this.validateSingleMeasureAggregation(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                            }
                        }
                        ++i;
                    }
                }
                ++level;
            }
            ++dimension;
        }
        if (this.crosstab.getGrandTotal(counterAxisType) != null || isCounterAxisEmpty) {
            String rowDimension = null;
            String rowLevel = null;
            String colDimension = null;
            String colLevel = null;
            int i = 0;
            while (i < measureList.size()) {
                MeasureViewHandle measureView = measureList.get(i);
                if (measureView.getCrosstab() == this.crosstab) {
                    String function;
                    String string = function = functionList == null ? CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView) : functionList.get(i);
                    if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, null, counterAxisType)) {
                        this.validateSingleMeasureAggregation(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                    }
                }
                ++i;
            }
        }
    }

    protected void removeMeasureAggregations(LevelViewHandle levelView) throws SemanticException {
        if (levelView == null || levelView.getCrosstab() != this.crosstab) {
            return;
        }
        String dimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
        String levelName = levelView.getCubeLevelName();
        if (dimensionName == null || levelName == null) {
            return;
        }
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(dimensionName, levelName, levelView.getAxisType(), i);
            ++i;
        }
    }

    protected void removeMeasureAggregations(LevelViewHandle levelView, int measureIndex) throws SemanticException {
        if (levelView == null || levelView.getCrosstab() != this.crosstab) {
            return;
        }
        String dimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
        String levelName = levelView.getCubeLevelName();
        if (dimensionName == null || levelName == null) {
            return;
        }
        if (measureIndex >= 0 && measureIndex < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(dimensionName, levelName, levelView.getAxisType(), measureIndex);
        }
    }

    protected void removeMeasureAggregations(int axisType) throws SemanticException {
        if (this.crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return;
        }
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(null, null, axisType, i);
            ++i;
        }
    }

    protected void removeMeasureAggregations(int axisType, int measureIndex) throws SemanticException {
        if (this.crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return;
        }
        if (measureIndex >= 0 && measureIndex < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(null, null, axisType, measureIndex);
        }
    }

    private void removeMeasureAggregations(String dimensionName, String levelName, int axisType, int measureIndex) throws SemanticException {
        ArrayList<AggregationCellHandle> dropList = new ArrayList<AggregationCellHandle>();
        MeasureViewHandle measureView = this.crosstab.getMeasure(measureIndex);
        int j = 0;
        while (j < measureView.getAggregationCount()) {
            AggregationCellHandle aggregationCell = measureView.getAggregationCell(j);
            String propName = CrosstabModelUtil.getAggregationOnPropName(axisType);
            String value = aggregationCell.getModelHandle().getStringProperty(propName);
            if (value == null && levelName == null || value != null && value.equals(levelName)) {
                dropList.add(aggregationCell);
            }
            ++j;
        }
        int i = 0;
        while (i < dropList.size()) {
            ((AggregationCellHandle)dropList.get(i)).getModelHandle().drop();
            ++i;
        }
    }

    private boolean isAggregationNeeded(MeasureViewHandle measureView, LevelViewHandle levelView, int axisType, List<LevelViewHandle> counterAggregationLevels) {
        if (measureView != null) {
            int totalCounterDimensions;
            String checkDimensionName = null;
            String checkLevelName = null;
            if (levelView != null) {
                checkDimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
                checkLevelName = levelView.getCubeLevelName();
            }
            int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
            boolean isInnerMost = levelView != null ? levelView.isInnerMost() : false;
            int totalDimensions = this.crosstab.getDimensionCount(axisType);
            if (isInnerMost || totalDimensions == 0) {
                if (counterAggregationLevels.size() > 0) {
                    return true;
                }
                if (this.crosstab.getGrandTotal(counterAxisType) != null) {
                    return true;
                }
            }
            if ((totalCounterDimensions = this.crosstab.getDimensionCount(counterAxisType)) > 0) {
                int i = 0;
                while (i < totalCounterDimensions) {
                    DimensionViewHandle dv = this.crosstab.getDimension(counterAxisType, i);
                    int totalLevels = dv.getLevelCount();
                    int j = 0;
                    while (j < totalLevels) {
                        LevelViewHandle lv = dv.getLevel(j);
                        if (i == totalCounterDimensions - 1 && j == totalLevels - 1 || lv.getAggregationHeader() != null) {
                            AggregationCellHandle cell = null;
                            cell = axisType == 0 ? measureView.getAggregationCell(checkDimensionName, checkLevelName, dv.getCubeDimensionName(), lv.getCubeLevelName()) : measureView.getAggregationCell(dv.getCubeDimensionName(), lv.getCubeLevelName(), checkDimensionName, checkLevelName);
                            if (cell != null) {
                                return true;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (totalCounterDimensions == 0 || this.crosstab.getGrandTotal(counterAxisType) != null) {
                AggregationCellHandle cell = null;
                cell = axisType == 0 ? measureView.getAggregationCell(checkDimensionName, checkLevelName, null, null) : measureView.getAggregationCell(null, null, checkDimensionName, checkLevelName);
                if (cell != null) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void validateMeasure(MeasureViewHandle measureView, LevelViewHandle toValidateLevelView, int toValidateAxisType, List<LevelViewHandle> aggregationLevels) throws SemanticException {
        if (measureView == null || aggregationLevels == null || toValidateLevelView != null && measureView.getCrosstab() != toValidateLevelView.getCrosstab()) {
            return;
        }
        if (toValidateLevelView != null && toValidateLevelView.getCubeLevelName() == null) {
            return;
        }
        if (toValidateLevelView != null && toValidateAxisType != toValidateLevelView.getAxisType()) {
            return;
        }
        boolean isInnerMost = toValidateLevelView == null ? false : toValidateLevelView.isInnerMost();
        ArrayList<LevelViewHandle> unAggregationLevels = new ArrayList<LevelViewHandle>();
        int unAggregationCount = 0;
        boolean needAggregation = this.isAggregationNeeded(measureView, toValidateLevelView, toValidateAxisType, aggregationLevels);
        int toValidataDimCount = this.crosstab.getDimensionCount(toValidateAxisType);
        if (aggregationLevels.size() > 0 && needAggregation) {
            int i = 0;
            while (i < aggregationLevels.size()) {
                LevelViewHandle levelView = aggregationLevels.get(i);
                if (isInnerMost) {
                    if (!levelView.isInnerMost()) {
                        assert (levelView.getAggregationHeader() != null);
                        if (this.getAggregation(measureView, toValidateLevelView, levelView) == null) {
                            unAggregationLevels.add(levelView);
                            ++unAggregationCount;
                        }
                    }
                } else if (!(toValidataDimCount <= 0 && levelView.isInnerMost() || this.getAggregation(measureView, toValidateLevelView, levelView) != null)) {
                    unAggregationLevels.add(levelView);
                    ++unAggregationCount;
                }
                ++i;
            }
        }
        int maxAggregationCount = aggregationLevels.size();
        if (needAggregation && (maxAggregationCount == 0 || this.crosstab.getGrandTotal(CrosstabModelUtil.getOppositeAxisType(toValidateAxisType)) != null) && this.getAggregation(measureView, toValidateLevelView, null) == null) {
            ++maxAggregationCount;
            ++unAggregationCount;
        }
        if (unAggregationCount > 0) {
            int i = 0;
            while (i < unAggregationLevels.size() && unAggregationCount > 0) {
                LevelViewHandle levelView = (LevelViewHandle)unAggregationLevels.get(i);
                String function = this.getAggregationFunction(measureView, levelView, CrosstabModelUtil.getOppositeAxisType(toValidateAxisType), toValidateLevelView, toValidateAxisType);
                this.addAggregation(measureView, toValidateLevelView, levelView, function);
                --unAggregationCount;
                ++i;
            }
            if (unAggregationCount != 0) {
                String function = this.getAggregationFunction(measureView, null, CrosstabModelUtil.getOppositeAxisType(toValidateAxisType), toValidateLevelView, toValidateAxisType);
                this.addAggregation(measureView, toValidateLevelView, null, function);
            }
        }
        boolean needCheckRedundantAggregations = false;
        if (measureView instanceof ComputedMeasureViewHandle) {
            int bypassAxis;
            int n = bypassAxis = "vertical".equals(this.crosstab.getMeasureDirection()) ? 0 : 1;
            if (toValidateAxisType == bypassAxis) {
                needCheckRedundantAggregations = true;
            }
        }
        if (needCheckRedundantAggregations) {
            AggregationCellHandle aggCell;
            int i = 0;
            while (i < aggregationLevels.size()) {
                AggregationCellHandle aggCell2;
                LevelViewHandle levelView = aggregationLevels.get(i);
                if (!isInnerMost && toValidataDimCount > 0 && (aggCell2 = this.getAggregation(measureView, toValidateLevelView, levelView)) != null) {
                    aggCell2.getModelHandle().drop();
                }
                ++i;
            }
            if (!(maxAggregationCount != 0 && this.crosstab.getGrandTotal(CrosstabModelUtil.getOppositeAxisType(toValidateAxisType)) == null || isInnerMost || toValidataDimCount <= 0 || (aggCell = this.getAggregation(measureView, toValidateLevelView, null)) == null)) {
                aggCell.getModelHandle().drop();
            }
        }
    }

    private AggregationCellHandle getAggregation(MeasureViewHandle measureView, LevelViewHandle leftLevelView, LevelViewHandle rightLevelView) {
        if (measureView == null || measureView.getCrosstab() != this.crosstab) {
            return null;
        }
        AggregationInfo infor = this.getAggregationInfo(leftLevelView, rightLevelView);
        if (infor == null) {
            return null;
        }
        return measureView.getAggregationCell(infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
    }

    private void addAggregation(MeasureViewHandle measureView, LevelViewHandle leftLevelView, LevelViewHandle rightLevelView, String function) throws SemanticException {
        if (measureView == null || measureView.getCrosstab() != this.crosstab) {
            return;
        }
        AggregationInfo infor = this.getAggregationInfo(leftLevelView, rightLevelView);
        if (infor == null) {
            return;
        }
        this.validateSingleMeasureAggregation(measureView.getCrosstab(), measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
    }

    private String getAggregationFunction(MeasureViewHandle measureView, LevelViewHandle leftLevelView, int leftAxisType, LevelViewHandle rightLevelView, int rightAxisType) {
        if (measureView == null || measureView.getCrosstab() != this.crosstab) {
            return null;
        }
        if (!CrosstabModelUtil.isValidAxisType(leftAxisType) || !CrosstabModelUtil.isValidAxisType(rightAxisType)) {
            return null;
        }
        if (leftAxisType != CrosstabModelUtil.getOppositeAxisType(rightAxisType)) {
            return null;
        }
        if (1 == leftAxisType) {
            String function = null;
            function = this.getAggregationFunction(measureView, leftLevelView, leftAxisType);
            if (function != null) {
                return function;
            }
            return this.getAggregationFunction(measureView, rightLevelView, rightAxisType);
        }
        String function = null;
        function = this.getAggregationFunction(measureView, rightLevelView, rightAxisType);
        if (function != null) {
            return function;
        }
        return this.getAggregationFunction(measureView, leftLevelView, leftAxisType);
    }

    private String getAggregationFunction(MeasureViewHandle measureView, LevelViewHandle levelView, int axisType) {
        if (levelView == null) {
            return this.crosstab.getAggregationFunction(axisType, measureView);
        }
        return levelView.getAggregationFunction(measureView);
    }

    protected void removeMeasureAggregation(LevelViewHandle leftLevelView, LevelViewHandle rightLevelView) throws SemanticException {
        AggregationInfo infor = this.getAggregationInfo(leftLevelView, rightLevelView);
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            measureView.removeAggregation(infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
            ++i;
        }
    }

    public void validateCrosstab() throws SemanticException {
        if (this.crosstab == null) {
            return;
        }
        String measureDirection = this.crosstab.getMeasureDirection();
        int axisType = 1;
        axisType = "horizontal".equals(measureDirection) ? 1 : 0;
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
        List<LevelViewHandle> counterAxisAggregationLevels = CrosstabModelUtil.getAllAggregationLevels(this.crosstab, counterAxisType);
        List<LevelViewHandle> toValidateLevelViews = CrosstabModelUtil.getAllAggregationLevels(this.crosstab, axisType);
        int count = toValidateLevelViews.size();
        int i = 0;
        while (i < count) {
            LevelViewHandle levelView = toValidateLevelViews.get(i);
            assert (levelView.isInnerMost() || levelView.getAggregationHeader() != null);
            int j = 0;
            while (j < this.crosstab.getMeasureCount()) {
                MeasureViewHandle measureView = this.crosstab.getMeasure(j);
                this.validateMeasure(measureView, levelView, axisType, counterAxisAggregationLevels);
                ++j;
            }
            ++i;
        }
        if (this.crosstab.getGrandTotal(axisType) != null || this.crosstab.getDimensionCount(axisType) == 0) {
            int j = 0;
            while (j < this.crosstab.getMeasureCount()) {
                MeasureViewHandle measureView = this.crosstab.getMeasure(j);
                this.validateMeasure(measureView, null, axisType, counterAxisAggregationLevels);
                ++j;
            }
        }
        LevelViewHandle innerestRowLevel = CrosstabModelUtil.getInnerMostLevel(this.crosstab, 0);
        LevelViewHandle innerestColLevel = CrosstabModelUtil.getInnerMostLevel(this.crosstab, 1);
        this.validateMeasureDetails(innerestRowLevel, innerestColLevel);
        this.validateMeasureHeaders();
    }

    protected void validateMeasureDetails(LevelViewHandle innerestRowLevel, LevelViewHandle innerestColLevel) throws SemanticException {
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            this.validateSingleMeasureDetail(measureView, innerestRowLevel, innerestColLevel);
            ++i;
        }
    }

    private void validateSingleMeasureDetail(MeasureViewHandle measureView, LevelViewHandle rowLevelView, LevelViewHandle colLevelView) throws SemanticException {
        AggregationCellHandle detailCell = measureView.getCell();
        LevelHandle rowLevel = detailCell.getAggregationOnRow();
        LevelHandle colLevel = detailCell.getAggregationOnColumn();
        if (rowLevelView == null) {
            detailCell.setAggregationOnRow(null);
        } else if (rowLevel == null || !rowLevel.equals(rowLevelView.getCubeLevel())) {
            detailCell.setAggregationOnRow(rowLevelView.getCubeLevel());
        }
        if (colLevelView == null) {
            detailCell.setAggregationOnColumn(null);
        } else if (colLevel == null || !colLevel.equals(colLevelView.getCubeLevel())) {
            detailCell.setAggregationOnColumn(colLevelView.getCubeLevel());
        }
        String function = CrosstabModelUtil.getAggregationFunction(this.crosstab, detailCell);
        HashMap<String, Object> extras = null;
        if (function != null) {
            extras = new HashMap<String, Object>();
            extras.put("function.hint", function);
        }
        CrosstabModelUtil.notifyValidate(2, detailCell, extras);
    }

    protected void addTotalMeasureHeader(int axisType, LevelViewHandle levelView) throws SemanticException {
        if (this.crosstab == null || levelView != null && axisType != levelView.getAxisType()) {
            return;
        }
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            this.addTotalMeasureHeader(axisType, levelView, this.crosstab.getMeasure(i));
            ++i;
        }
    }

    protected void addTotalMeasureHeader(int axisType, LevelViewHandle levelView, List<MeasureViewHandle> measureList) throws SemanticException {
        if (this.crosstab == null || measureList == null || measureList.size() == 0 || levelView != null && axisType != levelView.getAxisType()) {
            return;
        }
        int i = 0;
        while (i < measureList.size()) {
            this.addTotalMeasureHeader(axisType, levelView, measureList.get(i));
            ++i;
        }
    }

    private void addTotalMeasureHeader(int axisType, LevelViewHandle levelView, MeasureViewHandle mv) throws SemanticException {
        int targetAxis;
        if (mv == null) {
            return;
        }
        int n = targetAxis = "vertical".equals(this.crosstab.getMeasureDirection()) ? 0 : 1;
        if (targetAxis != axisType) {
            return;
        }
        if (levelView == null) {
            ExtendedItemHandle newHeader = CrosstabExtendedItemFactory.createCrosstabCell(mv.getModuleHandle());
            mv.getHeaderProperty().add((DesignElementHandle)newHeader);
            CrosstabModelUtil.notifyCreation(1, CrosstabUtil.getReportItem((DesignElementHandle)newHeader), null);
        } else {
            List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(this.crosstab, targetAxis);
            Collections.reverse(levels);
            int i = 0;
            while (i < levels.size()) {
                if (levelView == levels.get(i)) {
                    ExtendedItemHandle newHeader = CrosstabExtendedItemFactory.createCrosstabCell(mv.getModuleHandle());
                    mv.getHeaderProperty().add((DesignElementHandle)newHeader, i);
                    CrosstabModelUtil.notifyCreation(1, CrosstabUtil.getReportItem((DesignElementHandle)newHeader), null);
                    break;
                }
                ++i;
            }
        }
    }

    protected void removeTotalMeasureHeader(int axisType, LevelViewHandle levelView) throws SemanticException {
        if (this.crosstab == null || levelView != null && axisType != levelView.getAxisType()) {
            return;
        }
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            this.removeTotalMeasureHeader(axisType, levelView, i);
            ++i;
        }
    }

    protected void removeTotalMeasureHeader(int axisType, LevelViewHandle levelView, int measureIndex) throws SemanticException {
        int targetAxis;
        if (this.crosstab == null || levelView != null && axisType != levelView.getAxisType()) {
            return;
        }
        MeasureViewHandle mv = this.crosstab.getMeasure(measureIndex);
        int n = targetAxis = "vertical".equals(this.crosstab.getMeasureDirection()) ? 0 : 1;
        if (targetAxis != axisType || mv == null) {
            return;
        }
        if (levelView == null) {
            CrosstabCellHandle header;
            if (CrosstabModelUtil.isAggregationOn(mv, null, targetAxis) && (header = mv.getHeader(mv.getHeaderCount() - 1)) != null) {
                header.getModelHandle().drop();
            }
        } else {
            LevelViewHandle innerMost = CrosstabModelUtil.getInnerMostLevel(this.crosstab, targetAxis);
            if (levelView == innerMost) {
                assert (false);
            } else {
                List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(this.crosstab, targetAxis);
                Collections.reverse(levels);
                int realIndex = 0;
                int i = 0;
                while (i < levels.size()) {
                    LevelViewHandle lv = levels.get(i);
                    if (lv == innerMost || CrosstabModelUtil.isAggregationOn(mv, lv.getCubeLevelName(), targetAxis)) {
                        if (levelView == lv) {
                            CrosstabCellHandle header = mv.getHeader(realIndex);
                            if (header == null) break;
                            header.getModelHandle().drop();
                            break;
                        }
                        ++realIndex;
                    }
                    ++i;
                }
            }
        }
    }

    private void validateMeasureHeaders() throws SemanticException {
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            this.validateSingleMeasureHeader(measureView);
            ++i;
        }
    }

    private void validateSingleMeasureHeader(MeasureViewHandle measureView) throws SemanticException {
        block4: {
            int availableHeaders;
            int expectHeaders;
            block3: {
                if (measureView == null) {
                    return;
                }
                expectHeaders = CrosstabModelUtil.computeAllMeasureHeaderCount(this.crosstab, measureView);
                availableHeaders = measureView.getHeaderCount();
                if (availableHeaders >= expectHeaders) break block3;
                PropertyHandle propHandle = measureView.getHeaderProperty();
                int i = 0;
                while (i < expectHeaders - availableHeaders) {
                    ExtendedItemHandle headerCell = CrosstabExtendedItemFactory.createCrosstabCell(measureView.getModuleHandle());
                    propHandle.add((DesignElementHandle)headerCell);
                    CrosstabModelUtil.notifyCreation(1, CrosstabUtil.getReportItem((DesignElementHandle)headerCell), null);
                    ++i;
                }
                break block4;
            }
            if (availableHeaders <= expectHeaders) break block4;
            PropertyHandle propHandle = measureView.getHeaderProperty();
            List contents = propHandle.getContents();
            int i = 0;
            while (i < availableHeaders - expectHeaders) {
                ((DesignElementHandle)contents.get(contents.size() - i - 1)).drop();
                ++i;
            }
        }
    }

    protected void validateSingleMeasureAggregation(CrosstabReportItemHandle crosstab, MeasureViewHandle measureView, String function, String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        if (crosstab == null || measureView == null) {
            return;
        }
        AggregationCellHandle cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        if (cell == null) {
            cell = measureView.addAggregation(rowDimension, rowLevel, colDimension, colLevel);
        }
        HashMap<String, Object> extras = null;
        if (function != null) {
            extras = new HashMap<String, Object>();
            extras.put("function.hint", function);
        }
        CrosstabModelUtil.notifyValidate(3, cell, extras);
    }

    static class AggregationInfo {
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;

        public AggregationInfo(String rowDimension, String rowLevel, String colDimension, String colLevel) {
            this.rowDimension = rowDimension;
            this.rowLevel = rowLevel;
            this.colDimension = colDimension;
            this.colLevel = colLevel;
        }

        public String getRowDimension() {
            return this.rowDimension;
        }

        public String getRowLevel() {
            return this.rowLevel;
        }

        public String getColDimension() {
            return this.colDimension;
        }

        public String getColLevel() {
            return this.colLevel;
        }
    }
}

