/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.view;

import com.nvidia.cuda.ide.debug.model.query.ElementQuery;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.view.CudaDebugActionFactory;
import com.nvidia.cuda.ide.debug.view.FilterFieldHarness;
import com.nvidia.cuda.ide.util.ColumnsDragSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.actions.CollapseAllAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputRequestor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ViewerInputService;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.SelectionDragAdapter;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.IUpdate;

public final class CudaInformationView
extends AbstractDebugView
implements IDebugContextListener,
IPropertyChangeListener,
IDebugExceptionHandler,
IViewerUpdateListener,
FilterFieldHarness.Filterable {
    public static String ID = "com.nvidia.cuda.ide.debug.cudastate";
    protected DelegatingModelPresentation fModelPresentation;
    private SelectionProviderWrapper fSelectionProvider;
    private IPresentationContext fPresentationContext;
    private Composite composite;
    private Text search;
    private ToolBarManager localToolbar;
    private ViewerInputService fInputService;
    private final IViewerInputRequestor fRequester = new IViewerInputRequestor(){

        public void viewerInputComplete(IViewerInputUpdate update) {
            if (!update.isCanceled()) {
                CudaInformationView.this.viewerInputUpdateComplete(update);
            }
        }
    };

    public void dispose() {
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        TreeModelViewer viewer = this.getVariablesViewer();
        if (viewer != null) {
            viewer.removeViewerUpdateListener((IViewerUpdateListener)this);
        }
        if (this.fPresentationContext != null) {
            this.fPresentationContext.dispose();
            this.fPresentationContext = null;
        }
        this.fInputService.dispose();
        this.fSelectionProvider.dispose();
        super.dispose();
    }

    protected void viewerInputUpdateComplete(IViewerInputUpdate update) {
        this.setViewerInput(update.getInputElement());
        this.updateAction(FIND_ACTION);
    }

    protected void setViewerInput(Object context) {
        Object current = this.getViewer().getInput();
        if (current == null && context == null) {
            return;
        }
        if (current != null && current.equals(context)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(context);
        Tree tree = (Tree)this.getViewer().getControl();
        tree.setHeaderVisible(false);
        tree.setDragDetect(false);
        tree.setLinesVisible(true);
        this.setEnablement(this.getViewer().getControl(), context != null);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.changedDebugElement") || propertyName.equals("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND") || propertyName.equals("org.eclipse.debug.ui.VariableTextFont")) {
            this.getViewer().refresh();
        }
    }

    protected Control getControl() {
        return this.composite;
    }

    protected Control getDefaultControl() {
        return this.composite;
    }

    public Viewer createViewer(Composite parent) {
        this.getModelPresentation();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.localToolbar = new ToolBarManager(0x800000);
        this.localToolbar.createControl(this.composite);
        GridData labelData = new GridData(1, 4, false, false);
        labelData.heightHint = 8;
        new Label(this.composite, 514).setLayoutData((Object)labelData);
        this.search = new Text(this.composite, 896);
        this.search.setLayoutData((Object)new GridData(768));
        new FilterFieldHarness(this.search, this);
        TreeModelViewer variablesViewer = this.createTreeViewer(this.composite);
        this.fInputService = new ViewerInputService((ITreeModelViewer)variablesViewer, this.fRequester);
        variablesViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.setEnablement(variablesViewer.getControl(), false);
        this.fSelectionProvider = new SelectionProviderWrapper((ISelectionProvider)variablesViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        IMemento memento = this.getMemento();
        if (memento != null) {
            variablesViewer.initState(memento);
        }
        this.createOrientationActions(variablesViewer);
        variablesViewer.addViewerUpdateListener((IViewerUpdateListener)this);
        this.initDragAndDrop(variablesViewer);
        return variablesViewer;
    }

    private void setEnablement(Control tree, boolean enabled) {
        this.search.setEnabled(enabled);
        this.localToolbar.getControl().setEnabled(enabled);
        tree.setEnabled(enabled);
    }

    protected void initDragAndDrop(TreeModelViewer viewer) {
        viewer.addDragSupport(1, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SelectionDragAdapter(viewer));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        block12: {
            super.init(site, memento);
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String string = store.getString(this.getMementoId());
            if (string.length() > 0) {
                ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
                InputStreamReader reader = new InputStreamReader(bin);
                try {
                    try {
                        XMLMemento stateMemento = XMLMemento.createReadRoot((Reader)reader);
                        this.setMemento((IMemento)stateMemento);
                    }
                    catch (WorkbenchException workbenchException) {
                        try {
                            reader.close();
                            bin.close();
                        }
                        catch (IOException iOException) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        bin.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    reader.close();
                    bin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        block12: {
            String id = part.getSite().getId();
            if (id.equals(this.getSite().getId())) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(bout);
                try {
                    try {
                        XMLMemento memento = XMLMemento.createWriteRoot((String)"CudaObjectsViewMemento");
                        this.saveViewerState((IMemento)memento);
                        memento.save((Writer)writer);
                        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                        String xmlString = bout.toString();
                        store.putValue(this.getMementoId(), xmlString);
                    }
                    catch (IOException iOException) {
                        try {
                            writer.close();
                            bout.close();
                        }
                        catch (IOException iOException2) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                        bout.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    writer.close();
                    bout.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.partDeactivated(part);
    }

    public void saveViewerState(IMemento memento) {
        this.getVariablesViewer().saveState(memento);
    }

    protected TreeModelViewer createTreeViewer(Composite parent) {
        this.fPresentationContext = new DebugModelPresentationContext(this.getPresentationContextId(), (IWorkbenchPart)this, (IDebugModelPresentation)this.fModelPresentation);
        this.fPresentationContext.setProperty(ElementQuery.PROPERTY, (Object)ElementQuery.ALL_ELEMENTS);
        this.fPresentationContext.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("view.mode".equals(event.getProperty())) {
                    CudaInformationView.this.contextActivated(CudaInformationView.this.getDebugContext());
                }
            }
        });
        int style = this.getViewerStyle();
        TreeModelViewer variablesViewer = new TreeModelViewer(parent, style, this.fPresentationContext);
        new ColumnsDragSupport(variablesViewer.getTree());
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
        return variablesViewer;
    }

    protected ISelection getDebugContext() {
        IViewSite site = (IViewSite)this.getSite();
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        return contextService.getActiveContext(site.getId(), site.getSecondaryId());
    }

    protected String getPresentationContextId() {
        return ID;
    }

    protected String getPresentationContextSecondaryId() {
        return ((IViewSite)this.getSite()).getSecondaryId();
    }

    protected int getViewerStyle() {
        return 268503810;
    }

    protected String getHelpContextId() {
        return "com.nvidia.cuda.ide.debug.cuda-view-context";
    }

    protected void revealTreeSelection() {
        Object selected;
        ISelection selection;
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            viewer.reveal(selected);
        }
    }

    protected void createActions() {
        CollapseAllAction action = new CollapseAllAction((TreeModelViewer)this.getViewer()){

            public void update() {
            }
        };
        this.setAction("CollapseAll", (IAction)action);
        IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (hs != null) {
            hs.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)action));
        }
    }

    private void createOrientationActions(TreeModelViewer viewer) {
        this.setAction("actions.toggle.logical.view", CudaDebugActionFactory.createToggleLogicalViewAction(viewer));
        this.setAction("actions.toggle.hardware.view", CudaDebugActionFactory.createToggleHarwareViewAction(viewer));
        this.setAction("actions.toggle.coalescing", CudaDebugActionFactory.createToggleCoalescingAction(viewer.getPresentationContext()));
        this.setAction("actions.toggle.link.selection", CudaDebugActionFactory.createToggleLinkSelection(viewer.getPresentationContext()));
        this.setAction("actions.open.view", CudaDebugActionFactory.createOpenNewView(viewer.getPresentationContext().getPart().getSite().getPage()));
        this.localToolbar.add(this.getAction("actions.toggle.logical.view"));
        this.localToolbar.add(this.getAction("actions.toggle.hardware.view"));
        this.localToolbar.add((IContributionItem)new Separator());
        this.localToolbar.update(true);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add(this.getAction("actions.open.view"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add(this.getAction("actions.toggle.coalescing"));
        viewMenu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("edit"));
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("CollapseAll"));
        tbm.add(this.getAction("actions.toggle.link.selection"));
        tbm.add((IContributionItem)new Separator("additions"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new DelegatingModelPresentation();
        }
        return this.fModelPresentation;
    }

    public Object getAdapter(Class required) {
        if (IDebugModelPresentation.class.equals((Object)required)) {
            return this.getModelPresentation();
        }
        return super.getAdapter(required);
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        Widget item;
        TreeSelection ss;
        ISelection selection = this.getVariablesViewer().getSelection();
        if (selection instanceof TreeSelection && (ss = (TreeSelection)selection).size() == 1 && (item = this.getVariablesViewer().findItem(ss.getPaths()[0])) instanceof TreeItem) {
            TreeItem ti = (TreeItem)item;
            if (ti.getExpanded()) {
                ti.setExpanded(false);
            } else {
                this.getVariablesViewer().expandToLevel((Object)ss.getPaths()[0], 1);
            }
        }
    }

    public IDebugModelPresentation getPresentation(String id) {
        if (this.getViewer() instanceof StructuredViewer) {
            IDebugModelPresentation lp = this.getModelPresentation();
            if (lp instanceof DelegatingModelPresentation) {
                return ((DelegatingModelPresentation)lp).getPresentation(id);
            }
            if (lp instanceof LazyModelPresentation && ((LazyModelPresentation)lp).getDebugModelIdentifier().equals(id)) {
                return lp;
            }
        }
        return null;
    }

    protected IPresentationContext getPresentationContext() {
        return this.getVariablesViewer().getPresentationContext();
    }

    protected void becomesHidden() {
        this.fInputService.resolveViewerInput(ViewerInputService.NULL_INPUT);
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        ISelection selection = this.getDebugContext();
        this.contextActivated(selection);
    }

    protected TreeModelViewer getVariablesViewer() {
        return (TreeModelViewer)this.getViewer();
    }

    protected void clearStatusLine() {
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.setErrorMessage(null);
        manager.setMessage(null);
    }

    public void updateComplete(IViewerUpdate update) {
        IStatus status = update.getStatus();
        if (!update.isCanceled()) {
            if (status != null && !status.isOK()) {
                this.showMessage(status.getMessage());
            } else {
                this.showViewer();
            }
        }
    }

    protected void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Object source = ((IStructuredSelection)selection).getFirstElement();
            this.fInputService.resolveViewerInput(source);
        }
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public synchronized void viewerUpdatesBegin() {
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.incrementBusy();
        }
    }

    public synchronized void viewerUpdatesComplete() {
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.decrementBusy();
        }
    }

    public void setFocus() {
        if (this.search.isEnabled()) {
            this.search.setFocus();
        } else {
            this.composite.getParent().setFocus();
        }
    }

    @Override
    public void setFilter(IElementQuery query) {
        IElementQuery old = (IElementQuery)this.getPresentationContext().getProperty(ElementQuery.PROPERTY);
        if (!query.equals(old)) {
            this.getPresentationContext().setProperty(ElementQuery.PROPERTY, (Object)query);
        }
    }

    @Override
    public void moveFocus() {
        this.getVariablesViewer().getControl().setFocus();
    }

    public String getMementoId() {
        IViewSite viewSite = this.getViewSite();
        String primary = viewSite.getId();
        String secondary = viewSite.getSecondaryId();
        return String.format("pref_state_memento.%s.%s", primary, secondary);
    }

    private static class SelectionProviderWrapper
    implements ISelectionProvider {
        private final ListenerList fListenerList = new ListenerList(1);
        private final ISelectionChangedListener fListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectionProviderWrapper.this.fireSelectionChanged(event);
            }
        };
        private ISelectionProvider fActiveProvider;

        private SelectionProviderWrapper(ISelectionProvider provider) {
            this.setActiveProvider(provider);
        }

        private void setActiveProvider(ISelectionProvider provider) {
            if (this.fActiveProvider == provider || this == provider) {
                return;
            }
            if (this.fActiveProvider != null) {
                this.fActiveProvider.removeSelectionChangedListener(this.fListener);
            }
            if (provider != null) {
                provider.addSelectionChangedListener(this.fListener);
            }
            this.fActiveProvider = provider;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void dispose() {
            this.fListenerList.clear();
            this.setActiveProvider(null);
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fActiveProvider != null) {
                return this.fActiveProvider.getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListenerList.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (this.fActiveProvider != null) {
                this.fActiveProvider.setSelection(selection);
            }
        }
    }
}

