/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.launch.CudaBackend;
import com.nvidia.cuda.ide.debug.launch.CudaLaunch;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.IFocus;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.service.ICudaProcesses;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.devices.CudaDevice;
import com.nvidia.cuda.ide.sdk.CudaSDKCore;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public final class DebugUtil {
    private static final byte[] counts;
    private static final String DELEGATE_LOCAL_CUDA = "com.nvidia.cuda.ide.debug.launchApplicationDelegate";
    private static final Pattern number;
    private static final String[] ZERO_LENGTH_ARRAY;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 3;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 3;
        byArray[12] = 2;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 4;
        counts = byArray;
        number = Pattern.compile("^\\d+$");
        ZERO_LENGTH_ARRAY = new String[0];
    }

    public static <T> T adapt(Object adaptable, Class<T> clazz) {
        return clazz.cast(DebugPlugin.getAdapter((Object)adaptable, clazz));
    }

    public static String[] addDevicesEnvironmentVariable(String[] env, ILaunchConfiguration configuration) {
        if (env != null) {
            String devicesIdList;
            if (DebugUtil.needsDevicesEntry() && (devicesIdList = DebugUtil.getDevicesIdList(configuration)) != null) {
                env = DebugUtil.addVariableIfNeeded(env, "CUDA_VISIBLE_DEVICES", devicesIdList);
            }
            if (Activator.GDB_TRACE > 0) {
                env = DebugUtil.addVariableIfNeeded(env, "CUDA_GDB_TRACE_LEVEL", String.valueOf(Activator.GDB_TRACE));
                env = DebugUtil.addVariableIfNeeded(env, CudaBackend.CUDA_ERROR_LEVEL, String.valueOf(100));
            }
        }
        return env;
    }

    private static String[] addVariableIfNeeded(String[] env, String variable, String value) {
        if (value == null) {
            return env;
        }
        boolean hasDevicesEntry = false;
        if (env != null) {
            String[] stringArray = env;
            int n = env.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                if (var.startsWith(variable)) {
                    hasDevicesEntry = true;
                    break;
                }
                ++n2;
            }
        } else {
            env = ZERO_LENGTH_ARRAY;
        }
        if (!hasDevicesEntry) {
            String[] newEnv = new String[env.length + 1];
            System.arraycopy(env, 0, newEnv, 1, env.length);
            newEnv[0] = String.valueOf(variable) + "=" + value;
            return newEnv;
        }
        return env;
    }

    private static void append(StringBuilder focusString, String field, CudaCoord value) {
        if (value != null) {
            focusString.append(field).append(value);
        }
    }

    private static void append(StringBuilder focusString, String field, long value) {
        if (value >= 0L) {
            focusString.append(field).append(value);
        }
    }

    public static byte bitCount(long l) {
        byte count = 0;
        int i = 0;
        while (i < 16) {
            count = (byte)(count + counts[(int)(l & 0xFL)]);
            l >>= 4;
            i = (byte)(i + 1);
        }
        return count;
    }

    public static byte[] bitmaskToArray(long flags) {
        byte[] ids = new byte[DebugUtil.bitCount(flags)];
        int j = 0;
        int i = 0;
        while (i < 64) {
            if ((flags & 1L) == 1L) {
                ids[j++] = i;
            }
            flags >>= 1;
            i = (byte)(i + 1);
        }
        return ids;
    }

    public static boolean compare(CudaCoord value, IMemento memento, String property) {
        return value.equals(CudaCoord.parse(memento.getString(property)));
    }

    public static boolean compare(long value, IMemento memento, String property) {
        return Long.valueOf(value).equals(memento.getInteger(property));
    }

    public static final LabelColumnInfo createStateColumn() {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0}", new String[]{"cuda_state_label_long"}), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false)});
    }

    public static String cudaFocusString(IFocus focus) {
        StringBuilder focusString = new StringBuilder();
        DebugUtil.append(focusString, " kernel ", focus.getKernelId());
        DebugUtil.append(focusString, " block ", focus.getBlockIdx());
        DebugUtil.append(focusString, " thread ", focus.getThreadIdx());
        return focusString.toString();
    }

    public static String[] ensureContains(String[] classes, String ... names) {
        int growCount = 0;
        BitSet set = new BitSet(names.length);
        List<String> list = Arrays.asList(classes);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (!list.contains(name)) {
                ++growCount;
                set.set(i);
            }
            ++i;
        }
        if (growCount > 0) {
            int count = classes.length;
            String[] newClasses = new String[count + growCount];
            System.arraycopy(classes, 0, newClasses, 0, count);
            int i2 = 0;
            while (i2 < names.length) {
                if (set.get(i2)) {
                    newClasses[i2 + count] = names[i2];
                }
                ++i2;
            }
            return newClasses;
        }
        return classes;
    }

    public static CudaCoord extractCoordValue(MIValue miValue) {
        return CudaCoord.parse(DebugUtil.extractValue(miValue));
    }

    public static int extractIntValue(MIValue miValue) {
        return Integer.parseInt(DebugUtil.extractValue(miValue));
    }

    public static long extractLongValue(MIValue miValue) {
        return Long.parseLong(DebugUtil.extractValue(miValue));
    }

    public static short extractShortValue(MIValue miValue) {
        return Short.parseShort(DebugUtil.extractValue(miValue));
    }

    public static String extractValue(MIValue value) {
        MIConst miConst = (MIConst)value;
        return miConst.getCString();
    }

    public static short findFirstBit(Long activeLanes) {
        short i = 0;
        while (i < 64) {
            if ((activeLanes & 1L) > 0L) {
                return i;
            }
            activeLanes = activeLanes >> 1;
            i = (byte)(i + 1);
        }
        return 65;
    }

    public static Collection<ILaunch> findRunningCudaGdb() {
        ILaunch[] launches;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        HashSet<ILaunch> activeCudaGdb = new HashSet<ILaunch>();
        ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            if (!l.isTerminated() && "debug".equals(l.getLaunchMode()) && l.getAdapter(CudaLaunch.class) != null) {
                activeCudaGdb.add(l);
            }
            ++n2;
        }
        return activeCudaGdb;
    }

    public static VMDelta getAncestorDelta(IModelDelta delta, IDMContext object) {
        DeltaAncestorSearchVisitor visitor = new DeltaAncestorSearchVisitor(object);
        delta.accept((IModelDeltaVisitor)visitor);
        return visitor.getDelta();
    }

    public static String getDevicesIdList(ILaunchConfiguration configuration) {
        String ids;
        block7: {
            Object[] devices;
            block8: {
                Object[] allDevices = CudaDevice.getDevices(null);
                ids = configuration.getAttribute("lc.devices", null);
                if (!CoreUtil.isNullOrEmpty((String)ids)) break block7;
                devices = CudaSDKCore.getDefault().getSDKPreferences().getEnabledDevices();
                if (devices != null && allDevices != null && !CoreUtil.equalsIgnoringOrder((Object[])devices, (Object[])allDevices)) break block8;
                return null;
            }
            try {
                if (!CoreUtil.isNullOrEmpty((Object[])devices)) {
                    StringBuilder builder = new StringBuilder();
                    Object[] objectArray = devices;
                    int n = devices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object cudaDevice = objectArray[n2];
                        if (builder.length() > 0) {
                            builder.append(',');
                        }
                        builder.append(cudaDevice.getOrdinal());
                        ++n2;
                    }
                    return builder.toString();
                }
                return null;
            }
            catch (CoreException e) {
                Activator.log(e);
                return null;
            }
        }
        return ids;
    }

    public static FontData getItalicFontData() {
        FontDescriptor descriptor = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.dialogfont");
        FontData[] fontData = descriptor.getFontData();
        if (fontData != null && fontData.length > 0) {
            return new FontData(fontData[0].getName(), fontData[0].getHeight(), 2);
        }
        return null;
    }

    public static <K extends IDMContext> K getObject(Object element, Class<K> clazz, DsfServicesTracker tracker) {
        ICudaProcesses processes;
        if (clazz.isInstance(element)) {
            return (K)((IDMContext)clazz.cast(element));
        }
        if (element instanceof IViewerUpdate) {
            return DebugUtil.getObject(((IViewerUpdate)element).getElement(), clazz, tracker);
        }
        if (element instanceof IModelDelta) {
            return DebugUtil.getObject(((IModelDelta)element).getElement(), clazz, tracker);
        }
        if (element instanceof IDMVMContext) {
            return DebugUtil.getObject(((IDMVMContext)element).getDMContext(), clazz, tracker);
        }
        if (element instanceof IDMContext) {
            if (element instanceof RangeContext) {
                return null;
            }
            return (K)DMContexts.getAncestorOfType((IDMContext)((IDMContext)element), clazz);
        }
        if (element instanceof IDMEvent) {
            IDMContext context = ((IDMEvent)element).getDMContext();
            return DebugUtil.getObject(context, clazz, tracker);
        }
        if (clazz.equals(ICudaRuntimeObject.class) && tracker != null && (processes = (ICudaProcesses)tracker.getService(ICudaProcesses.class)) != null) {
            return (K)((IDMContext)clazz.cast(processes.getApplication()));
        }
        return null;
    }

    public static RGB getRGBColor(int colorId) {
        Display current = Display.getCurrent();
        if (current == null) {
            throw new IllegalStateException("Should be called from display thread");
        }
        return current.getSystemColor(colorId).getRGB();
    }

    public static IStack.IFrameDMContext getTopFrame(final IRunControl.IExecutionDMContext dmc) {
        final DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session != null && session.isActive()) {
            Query<IStack.IFrameDMContext> query = new Query<IStack.IFrameDMContext>(){

                protected void execute(DataRequestMonitor<IStack.IFrameDMContext> rm) {
                    if (session.isActive()) {
                        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), session.getId());
                        try {
                            IStack stack = (IStack)tracker.getService(IStack.class);
                            if (stack != null) {
                                stack.getTopFrame((IDMContext)dmc, rm);
                                return;
                            }
                        }
                        finally {
                            tracker.dispose();
                        }
                    }
                    rm.setData(null);
                    rm.done();
                }
            };
            session.getExecutor().execute((Runnable)query);
            try {
                return (IStack.IFrameDMContext)query.get();
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
            catch (ExecutionException executionException) {}
        }
        return null;
    }

    private static IResource[] getWorkspaceResources(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        URI uri = path.toFile().toURI();
        IContainer[] containers = workspace.getRoot().findContainersForLocationURI(uri);
        if (containers.length == 0) {
            IFile[] files = workspace.getRoot().findFilesForLocationURI(uri);
            return files;
        }
        return containers;
    }

    public static boolean has35Device(ICudaDevice[] devices) {
        ICudaDevice[] iCudaDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            ICudaDevice cudaDevice = iCudaDeviceArray[n2];
            if (cudaDevice.getVersionMajor() > 3 || cudaDevice.getVersionMajor() == 3 && cudaDevice.getVersionMinor() >= 5) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDebugView(IVMProvider provider) {
        return "org.eclipse.debug.ui.DebugView".equals(provider.getPresentationContext().getId());
    }

    public static boolean isInError(IRunControl.IExecutionDMData data) {
        switch (data.getStateChangeReason()) {
            case EXCEPTION: 
            case SIGNAL: 
            case ERROR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLocalCudaGdbLaunch(ILaunch launch) throws CoreException {
        ILaunchConfiguration lc;
        if (!launch.isTerminated() && "debug".equals(launch.getLaunchMode()) && "org.eclipse.cdt.launch.applicationLaunchType".equals((lc = launch.getLaunchConfiguration()).getType().getIdentifier())) {
            Set<String> modeSingleton = Collections.singleton(launch.getLaunchMode());
            ILaunchDelegate delegate = lc.getPreferredDelegate(Collections.singleton(launch.getLaunchMode()));
            if (delegate == null) {
                delegate = lc.getType().getPreferredDelegate(modeSingleton);
            }
            if (delegate != null && DELEGATE_LOCAL_CUDA.equals(delegate.getId())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object[] data) {
        return data == null || data.length == 0;
    }

    public static boolean isNullOrEmpty(String queryString) {
        return queryString == null || queryString.trim().length() == 0;
    }

    public static boolean isNumber(String relExpr) {
        return number.matcher(relExpr).matches();
    }

    public static boolean isParent(VMDelta parent, IDMContext dmc) {
        ICudaRuntimeObject adm;
        Object parentdm;
        Object element = parent.getElement();
        return element instanceof IAdaptable && (parentdm = ((IAdaptable)element).getAdapter(IDMContext.class)) instanceof IDMContext && DMContexts.isAncestorOf((IDMContext)dmc, (IDMContext)(adm = (ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)((IDMContext)parentdm), ICudaRuntimeObject.class)));
    }

    public static boolean isPinned(DeviceThread element) {
        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), element.getSessionId());
        try {
            IDebuggerUIState state = (IDebuggerUIState)tracker.getService(IDebuggerUIState.class);
            if (state != null) {
                boolean bl = state.isPinned(element);
                return bl;
            }
        }
        finally {
            tracker.dispose();
        }
        return false;
    }

    public static boolean isPinnedOrRemembered(DeviceThread element) {
        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), element.getSessionId());
        try {
            IDebuggerUIState state = (IDebuggerUIState)tracker.getService(IDebuggerUIState.class);
            if (state != null) {
                boolean bl = state.isPinned(element) || state.isRemembered(element);
                return bl;
            }
        }
        finally {
            tracker.dispose();
        }
        return false;
    }

    public static boolean isPreemptionEnabled(String filter) {
        return CudaSDKCore.getDefault().getPreferenceStore().getBoolean("enablePreemption") && (!CudaDevice.areDevicesRead() || CudaDevice.devicesFilteredExternally() || DebugUtil.has35Device(CudaDevice.getDevices((String)filter)));
    }

    public static boolean isSameProject(IPath path1, IPath path2) {
        IResource[] r1 = DebugUtil.getWorkspaceResources(path1);
        IResource[] r2 = DebugUtil.getWorkspaceResources(path2);
        IResource[] iResourceArray = r1;
        int n = r1.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res1 = iResourceArray[n2];
            IProject project1 = res1.getProject();
            IResource[] iResourceArray2 = r2;
            int n3 = r2.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource res2 = iResourceArray2[n4];
                if (res2.getProject().equals((Object)project1)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSameRange(IDMContext dmc, IMemento memento) {
        if (dmc instanceof RangeContext) {
            boolean sameRange = false;
            String start = memento.getString("MEMENTO_RANGE_START");
            String end = memento.getString("MEMENTO_RANGE_END");
            if (start != null && end != null) {
                sameRange = ((RangeContext)dmc).getStart() == Long.parseLong(start);
                sameRange &= ((RangeContext)dmc).getEnd() == Long.parseLong(end);
            }
            return sameRange;
        }
        return false;
    }

    public static boolean isSameWarp(IFocusDMContext focus1, IFocusDMContext focus2) {
        Kernel kernel2;
        if (focus1 == null || focus2 == null) {
            return false;
        }
        if (focus1.equals(focus2)) {
            return true;
        }
        Kernel kernel1 = focus1.getKernel();
        if (kernel1.equals(kernel2 = focus2.getKernel()) && focus1.getBlockIdx().equals(focus2.getBlockIdx())) {
            long ordinal2;
            CudaDim blockDim = kernel1.getBlockDim();
            long ordinal1 = blockDim.getOrdinal(focus1.getThreadIdx());
            return ordinal1 >> 5 == (ordinal2 = blockDim.getOrdinal(focus2.getThreadIdx())) >> 5;
        }
        return false;
    }

    private static boolean needsDevicesEntry() {
        return System.getenv("CUDA_VISIBLE_DEVICES") == null;
    }

    public static long parseHex(String val) {
        if (val == null || val.trim().length() == 0) {
            return 0L;
        }
        String clean = val.trim().intern();
        if (clean.startsWith("0x")) {
            String high;
            String low;
            if ((clean = clean.substring(2)).length() > 8) {
                int split = clean.length() - 8;
                low = clean.substring(split);
                high = clean.substring(0, split);
            } else {
                low = clean;
                high = "0";
            }
            long l = Long.parseLong(low, 16);
            long h = Long.parseLong(high, 16);
            return h << 32 | l;
        }
        return Long.parseLong(val, 10);
    }

    public static void pin(DeviceThread element) {
        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), element.getSessionId());
        try {
            IDebuggerUIState state = (IDebuggerUIState)tracker.getService(IDebuggerUIState.class);
            if (state != null) {
                state.pin(element);
            }
        }
        finally {
            tracker.dispose();
        }
    }

    public static void preemptionPrompt(String filter) {
        if (!CudaSDKCore.getDefault().getPreferenceStore().getBoolean("enablePreemption")) {
            final ICudaDevice[] devices = CudaDevice.devicesFilteredExternally() ? null : CudaDevice.getDevices((String)filter);
            String shouldPrompt = Activator.getDefault().getPreferenceStore().getString("prompt.preemption");
            if ((CoreUtil.isNullOrEmpty((String)shouldPrompt) || "prompt".equals(shouldPrompt.trim())) && (devices == null || DebugUtil.has35Device(devices))) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DebugUtil.promptForSingleGpuDebugging(devices);
                    }
                });
            }
        }
    }

    protected static void promptForSingleGpuDebugging(ICudaDevice[] devices) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(SWTUtil.getShell(), "Single GPU Debugging", null, MessageFormat.format("{0,choice,0#|1<Your system contains at least one device that supports software preemption debugging.\n\n}Software preemption debugging is a BETA feature introduced in CUDA toolkit 5.5 and is only supported on SM 3.5 devices. It enables single-GPU debugging and simultaneous debugging of multiple CUDA applications on the same device.\n\nSoftware preemption debugging can be enabled from Nsight preferences.", devices == null ? 0 : 1), 2, new String[]{"Open Preferences", "Ok"}, 0, "Do not show this message", false);
        dialog.setPrefStore(Activator.getDefault().getPreferenceStore());
        dialog.setPrefKey("prompt.preemption");
        int button = dialog.open();
        if (dialog.getToggleState()) {
            Activator.getDefault().getPreferenceStore().setValue("prompt.preemption", "never");
        }
        if (button == 256) {
            CudaSDKCore.openPreferences();
        }
    }

    public static void select(Collection<? extends IDMContext> path, VMDelta delta, boolean select, boolean collapseTheRest, IVMProvider provider, RequestMonitor rm) {
        if (delta == null || CoreUtil.isNullOrEmpty(path)) {
            rm.done();
        }
        DebugUtil.selectPath(path.iterator(), delta, rm, select, collapseTheRest, provider);
    }

    public static void select(IDMContext ctx, VMDelta delta, boolean select, boolean collapseTheRest, IVMProvider provider, RequestMonitor rm) {
        DebugUtil.select(Collections.singleton(ctx), delta, select, collapseTheRest, provider, rm);
    }

    private static void selectPath(Iterator<? extends IDMContext> path, VMDelta delta, RequestMonitor rm, boolean select, boolean collapseTheRest, IVMProvider provider) {
        provider.update(new IChildrenUpdate[]{new VMChildrenUpdate((IModelDelta)delta, provider.getPresentationContext(), 0, -1, (DataRequestMonitor)new RecursiveSelectionDeltaBuilder(ImmediateExecutor.getInstance(), rm, delta, path, provider, select, collapseTheRest, rm))});
    }

    public static void storeRange(IDMContext dmc, IMemento memento) {
        if (dmc instanceof RangeContext) {
            RangeContext range = (RangeContext)dmc;
            memento.putString("MEMENTO_RANGE_START", String.valueOf(range.getStart()));
            memento.putString("MEMENTO_RANGE_END", String.valueOf(range.getEnd()));
        }
    }

    private static void togglePinned(DeviceThread dmContext, DsfServicesTracker tracker) {
        IDebuggerUIState service = (IDebuggerUIState)tracker.getService(IDebuggerUIState.class);
        if (service != null) {
            if (service.isPinned(dmContext)) {
                service.unpin(dmContext);
            } else {
                service.pin(dmContext);
            }
        }
    }

    public static void togglePinOnDoubleclick(ISelection selection, IVMNode node, DsfServicesTracker tracker) {
        IDMVMContext ctx;
        IStructuredSelection ss;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ss.getFirstElement() instanceof IDMVMContext && (ctx = (IDMVMContext)ss.getFirstElement()).getVMNode() == node && ctx.getDMContext() instanceof DeviceThread) {
            DebugUtil.togglePinned((DeviceThread)ctx.getDMContext(), tracker);
        }
    }

    public static void unpin(DeviceThread element) {
        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), element.getSessionId());
        try {
            IDebuggerUIState state = (IDebuggerUIState)tracker.getService(IDebuggerUIState.class);
            if (state != null) {
                state.unpin(element);
            }
        }
        finally {
            tracker.dispose();
        }
    }

    private DebugUtil() {
    }

    private static final class DeltaAncestorSearchVisitor
    implements IModelDeltaVisitor {
        private VMDelta found;
        private final IDMContext target;

        public DeltaAncestorSearchVisitor(IDMContext target) {
            this.target = target;
        }

        public VMDelta getDelta() {
            return this.found;
        }

        public boolean visit(IModelDelta delta, int depth) {
            if (this.found == null) {
                IDMContext object = DebugUtil.getObject(delta, IDMContext.class, null);
                if (object != null && (object.equals(this.target) || DMContexts.isAncestorOf((IDMContext)this.target, (IDMContext)object))) {
                    this.found = (VMDelta)delta;
                } else {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class RecursiveSelectionDeltaBuilder
    extends DataRequestMonitor<List<Object>> {
        private final boolean collapseTheRest;
        private final VMDelta delta;
        private final Iterator<? extends IDMContext> path;
        private final IVMProvider provider;
        private final RequestMonitor rm;
        private final boolean select;

        private RecursiveSelectionDeltaBuilder(Executor executor, RequestMonitor parentRequestMonitor, VMDelta delta, Iterator<? extends IDMContext> path, IVMProvider provider, boolean select, boolean collapseTheRest, RequestMonitor rm) {
            super(executor, parentRequestMonitor);
            this.delta = delta;
            this.path = path;
            this.select = select;
            this.provider = provider;
            this.collapseTheRest = collapseTheRest;
            this.rm = rm;
        }

        @ConfinedToDsfExecutor(value="fExecutor")
        protected void handleSuccess() {
            VMDelta d = null;
            IDMContext object = this.path.next();
            if (this.getData() != null) {
                this.delta.setChildCount(((List)this.getData()).size());
                int i = 0;
                for (Object context : (List)this.getData()) {
                    VMDelta childDelta;
                    if ((childDelta = this.processChild(object, i++, context)) == null) continue;
                    d = childDelta;
                }
            }
            if (d != null) {
                DebugUtil.selectPath(this.path, d, this.rm, this.select, this.collapseTheRest, this.provider);
            } else {
                this.rm.done();
            }
        }

        private VMDelta processChild(IDMContext object, int i, Object context) {
            if (context instanceof IDMVMContext) {
                IDMContext dmc = ((IDMVMContext)context).getDMContext();
                if (dmc.equals(object)) {
                    boolean isLast = !this.path.hasNext();
                    int flags = isLast && this.select ? 0x5200000 : 0x100000;
                    VMDelta d = this.delta.addNode(context, i, flags);
                    if (!isLast) {
                        return d;
                    }
                } else if (this.collapseTheRest) {
                    this.delta.addNode(context, i, 0x2000000);
                }
            }
            return null;
        }
    }
}

