/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.util.NsightUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class DebugPerspectiveListener
implements IWindowListener,
IPerspectiveListener {
    private static boolean hasDebugWindows = false;
    private static boolean shownWarningThisSession = false;
    private static AtomicReference<DebugPerspectiveListener> singleton = new AtomicReference();

    private static void checkPerspectives(Shell shell) {
        boolean debug = DebugPerspectiveListener.isDebugPerspectiveOpen();
        if (DebugPerspectiveListener.shoudWarn() && hasDebugWindows && !debug && !DebugUtil.findRunningCudaGdb().isEmpty()) {
            hasDebugWindows = false;
            MessageDialogWithToggle.openWarning((Shell)(shell != null ? shell : NsightUtil.getDefaultParentShell()), (String)"Leaving Debug Perspective", (String)"The CUDA debugger is still running. To stop or continue debugging, open the Debug perspective using the Window menu.", (String)"Do not show this message", (boolean)false, (IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"warn.leaving.debugperspective");
            shownWarningThisSession = true;
        } else if (!hasDebugWindows && debug) {
            hasDebugWindows = true;
        }
    }

    private static boolean shoudWarn() {
        return !shownWarningThisSession && !"always".equals(Activator.getDefault().getPreferenceStore().getString("warn.leaving.debugperspective"));
    }

    public static void install() {
        if (singleton.get() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DebugPerspectiveListener.installListener();
                }
            });
        }
    }

    protected static void installListener() {
        DebugPerspectiveListener listener = new DebugPerspectiveListener();
        if (singleton.compareAndSet(null, listener)) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.addWindowListener((IWindowListener)listener);
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.addPerspectiveListener((IPerspectiveListener)listener);
                ++n2;
            }
            DebugPerspectiveListener.checkPerspectives(null);
        }
    }

    private static boolean isDebugPerspectiveOpen() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if ("org.eclipse.debug.ui.DebugPerspective".equals(page.getPerspective().getId())) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        DebugPerspectiveListener.checkPerspectives(page.getWorkbenchWindow().getShell());
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePerspectiveListener((IPerspectiveListener)this);
        window.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformUI.getWorkbench().isClosing()) {
                    DebugPerspectiveListener.checkPerspectives(NsightUtil.getDefaultParentShell());
                }
            }
        });
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        DebugPerspectiveListener.checkPerspectives(window.getShell());
        window.addPerspectiveListener((IPerspectiveListener)this);
    }
}

