/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.launch.CudaControl;
import com.nvidia.cuda.ide.debug.launch.CudaFocus;
import com.nvidia.cuda.ide.debug.launch.CudaGdbFatalErrorEvent;
import com.nvidia.cuda.ide.debug.model.CudaApplicationState;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaStateContext;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.state.MIQueries;
import com.nvidia.cuda.ide.debug.service.CudaCommandFactory;
import com.nvidia.cuda.ide.debug.service.ICudaProcesses;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_2_1;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class CudaProcesses
extends GDBProcesses_7_2_1
implements ICudaProcesses {
    public static final String SINGLE_PROCESS_GROUP_ID = "i1";
    private CudaStateContext context;
    private ICudaApplication cudaDebugObjectsProvider;
    private CudaControl fCommandControl;
    private boolean fConnected;
    private CommandCache fContainerCommandCache;

    public CudaProcesses(DsfSession session) {
        super(session);
    }

    protected void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (CudaControl)((Object)this.getServicesTracker().getService(CudaControl.class));
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)this.fCommandControl, this.getExecutor(), 2);
        this.fContainerCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        CudaCommandFactory commandFactory = (CudaCommandFactory)((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        MIQueries queries = new MIQueries(this.fContainerCommandCache, commandFactory, this.getSession(), this.getServicesTracker());
        this.cudaDebugObjectsProvider = new CudaApplicationState(this.getSession(), (IDMContext)this.fCommandControl.getContext(), queries);
        requestMonitor.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IContainerSuspendedDMEvent e) {
        this.cudaDebugObjectsProvider.invalidate();
        this.fContainerCommandCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            this.fConnected = false;
        }
        this.cudaDebugObjectsProvider.invalidate();
        super.eventDispatched(e);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            this.fConnected = true;
        }
        this.cudaDebugObjectsProvider.invalidate();
        super.eventDispatched(e);
    }

    @Override
    public ICudaApplication getApplication() {
        return this.cudaDebugObjectsProvider;
    }

    @Override
    public CudaStateContext getCudaContext(IDMContext dmc) {
        if (this.fConnected && this.cudaDebugObjectsProvider.hasKernels()) {
            if (this.context == null) {
                ICommandControlService.ICommandControlDMContext command = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
                this.context = new CudaStateContext(this.getSession().getId(), (IDMContext)this.createContainerContextFromGroupId(command, ""), this.getApplication());
            }
            return this.context;
        }
        return null;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleSuccess() {
                CudaProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    protected void register(String[] classes, Dictionary properties) {
        if (!Arrays.asList(classes).contains(ICudaProcesses.class)) {
            String[] newClasses = new String[classes.length + 1];
            newClasses[0] = ICudaProcesses.class.getName();
            System.arraycopy(classes, 0, newClasses, 1, classes.length);
            classes = newClasses;
        }
        super.register(classes, properties);
    }

    public String toString() {
        return "CudaGdbProcesses#" + this.getSession().getId();
    }

    @Override
    public IRunControl.IExecutionDMContext getExecutionContext(ICommandControlService.ICommandControlDMContext dmc, CudaFocus focus) {
        IMIContainerDMContext containerDmc = this.createContainerContextFromGroupId(dmc, SINGLE_PROCESS_GROUP_ID);
        if (containerDmc != null) {
            try {
                return this.cudaDebugObjectsProvider.getExecutionContext(containerDmc, focus);
            }
            catch (CudaException e) {
                Activator.log(e);
                return null;
            }
        }
        return null;
    }

    @DsfServiceEventHandler
    public void eventDispatched(final CudaGdbFatalErrorEvent e) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Nsight Debugger", null, e.getError(), 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                }
            });
        }
        this.terminateAllProcesses();
    }

    private void terminateAllProcesses() {
        MIControlDMContext controlDMContext = this.fCommandControl.getControlDMContext();
        this.getProcessesBeingDebugged((IDMContext)controlDMContext, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)this.getExecutor(), null){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                IDMContext[] iDMContextArray = (IDMContext[])this.getData();
                int n = iDMContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDMContext context = iDMContextArray[n2];
                    CudaProcesses.this.properlyTerminate(context);
                    ++n2;
                }
            }
        });
    }

    protected void properlyTerminate(IDMContext context) {
        final IProcesses.IThreadDMContext thread = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)context, IProcesses.IThreadDMContext.class);
        if (thread != null) {
            this.canTerminate(thread, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), null){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    if (((Boolean)this.getData()).booleanValue()) {
                        CudaProcesses.this.terminate(thread, new RequestMonitor((Executor)CudaProcesses.this.getExecutor(), null));
                    }
                }
            });
        }
    }

    public static interface ICudaDMKernelContext
    extends IDMContext {
        public String getName();
    }

    public static final class KernelDMData
    implements ICudaProcesses.IKernelDMData {
        private final int deviceId;
        private final int id;
        private final String name;

        public KernelDMData(String name, int id, int deviceId) {
            this.name = name;
            this.id = id;
            this.deviceId = deviceId;
        }

        @Override
        public int getDeviceId() {
            return this.deviceId;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

