/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.memory.DeviceMemoryType;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlock;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.MIMemory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.MemoryByte;

public final class CudaMemory
extends MIMemory
implements IMemorySpaces {
    public CudaMemory(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            public void handleSuccess() {
                CudaMemory.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{MIMemory.class.getName(), IMemory.class.getName(), CudaMemory.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    protected void readMemoryBlock(IDMContext dmc, IAddress address, long offset, int word_size, int count, DataRequestMonitor<MemoryByte[]> drm) {
        IDMContext threadOrMemoryDmc = this.adjustMemoryContext(dmc);
        super.readMemoryBlock(threadOrMemoryDmc, address, offset, word_size, count, drm);
    }

    private IDMContext adjustMemoryContext(IDMContext dmc) {
        IMemory.IMemoryDMContext memoryDM = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
        ICudaRuntimeObject cudaRuntimeObject = (ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)dmc, ICudaRuntimeObject.class);
        if (memoryDM != null && cudaRuntimeObject != null) {
            return memoryDM;
        }
        IDMContext threadOrMemoryDmc = dmc;
        IMIContainerDMContext containerCtx = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (containerCtx != null) {
            IMIExecutionDMContext[] execCtxs;
            IGDBProcesses procService = (IGDBProcesses)this.getServicesTracker().getService(IGDBProcesses.class);
            IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
            if (procService != null && runControl != null && (execCtxs = procService.getExecutionContexts(containerCtx)) != null && execCtxs.length > 0) {
                IMIExecutionDMContext[] iMIExecutionDMContextArray = execCtxs;
                int n = execCtxs.length;
                int n2 = 0;
                while (n2 < n) {
                    IMIExecutionDMContext execCtx = iMIExecutionDMContextArray[n2];
                    if (runControl.isSuspended((IRunControl.IExecutionDMContext)execCtx)) {
                        threadOrMemoryDmc = execCtx;
                        if (!(dmc instanceof IMemorySpaces.IMemorySpaceDMContext)) break;
                        threadOrMemoryDmc = new GdbMemoryBlock.MemorySpaceDMContext(this.getSession().getId(), ((IMemorySpaces.IMemorySpaceDMContext)dmc).getMemorySpaceId(), threadOrMemoryDmc);
                        break;
                    }
                    ++n2;
                }
            }
        }
        return threadOrMemoryDmc;
    }

    protected void writeMemoryBlock(IDMContext dmc, IAddress address, long offset, int word_size, int count, byte[] buffer, RequestMonitor rm) {
        IDMContext threadOrMemoryDmc = this.adjustMemoryContext(dmc);
        super.writeMemoryBlock(threadOrMemoryDmc, address, offset, word_size, count, buffer, rm);
    }

    public String encodeAddress(String expression, String memorySpaceID) {
        if (!CoreUtil.isNullOrEmpty((String)memorySpaceID)) {
            return String.format("%s (@%s)", expression, memorySpaceID);
        }
        return expression;
    }

    public IMemorySpaces.DecodeResult decodeAddress(String str) throws CoreException {
        Pattern compile = Pattern.compile("^(.*) \\(@(\\w*)\\)$");
        Matcher matcher = compile.matcher(str);
        if (matcher.matches()) {
            String group = matcher.group(2);
            try {
                DeviceMemoryType memoryType = DeviceMemoryType.valueOf(group);
                return new DecodedMemoryLocation(matcher.group(1), memoryType);
            }
            catch (IllegalArgumentException e) {
                Activator.log(e);
            }
        }
        return new DecodedMemoryLocation(str, null);
    }

    public void getMemorySpaces(IDMContext context, DataRequestMonitor<String[]> rm) {
        ICudaApplication application = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)context, ICudaApplication.class);
        if (application != null) {
            rm.done((Object)DeviceMemoryType.names());
        } else {
            rm.done((Object)new String[0]);
        }
    }

    public boolean creatingBlockRequiresMemorySpaceID() {
        return true;
    }

    protected void register(String[] classes, Dictionary properties) {
        super.register((String[])CoreUtil.append((Object[])classes, (Object[])new String[]{IMemorySpaces.class.getName()}), properties);
    }

    private static final class DecodedMemoryLocation
    implements IMemorySpaces.DecodeResult {
        private final DeviceMemoryType memoryType;
        private final String location;

        private DecodedMemoryLocation(String location, DeviceMemoryType memoryType) {
            this.location = location;
            this.memoryType = memoryType;
        }

        public String getMemorySpaceId() {
            return this.memoryType.name();
        }

        public String getExpression() {
            return this.location;
        }

        public int hashCode() {
            return this.location.hashCode() + (this.memoryType != null ? 31 * this.memoryType.ordinal() : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DecodedMemoryLocation)) {
                return false;
            }
            DecodedMemoryLocation other = (DecodedMemoryLocation)obj;
            return this.location.equals(other.location) && CoreUtil.equals((Object)((Object)this.memoryType), (Object)((Object)other.memoryType));
        }

        public String toString() {
            if (this.memoryType == null) {
                return this.location;
            }
            return String.format("%s (@%s)", new Object[]{this.location, this.memoryType});
        }
    }
}

