/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.internal.ui.editor.SemanticToken;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.cdt.ui.text.IHighlightConfiguration;
import org.eclipse.cdt.ui.text.ISemanticHighlighting;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractConfigurableHighlighting
implements IHighlightConfiguration,
ISemanticHighlighting {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.cdt.ui/debug/SemanticHighlighting"));
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private AtomicReference<TextAttribute> fTextAttribute = new AtomicReference();

    public AbstractConfigurableHighlighting() {
        this.fColorManager = CUIPlugin.getDefault().getTextTools().getColorManager();
        this.fPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
    }

    private void adaptToTextForegroundChange(PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if (color == null || !rgb.equals((Object)color.getRGB())) {
                this.fColorManager.unbindColor(property);
                this.fColorManager.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = this.getTextAttribute();
            this.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = this.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            this.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void addColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            this.fColorManager.unbindColor(colorKey);
            this.fColorManager.bindColor(colorKey, rgb);
        }
    }

    @Override
    public final boolean affectsEnablement(PropertyChangeEvent event) {
        return event.getProperty().equals(this.getEnabledPreferenceKey());
    }

    @Override
    public abstract boolean consumes(SemanticToken var1);

    private TextAttribute createInitialTextAttribute() {
        String underlineKey;
        String strikethroughKey;
        String colorKey = this.getColorPreferenceKey();
        this.addColor(colorKey);
        String boldKey = this.getBoldPreferenceKey();
        int style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        String italicKey = this.getItalicPreferenceKey();
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.fPreferenceStore.getBoolean(strikethroughKey = this.getStrikethroughPreferenceKey())) {
            style |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(underlineKey = this.getUnderlinePreferenceKey())) {
            style |= 0x40000000;
        }
        TextAttribute textAttribute = new TextAttribute(this.fColorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey)), null, style);
        return textAttribute;
    }

    @Override
    public final void dispose() {
        this.removeColor(this.getColorPreferenceKey());
    }

    @Override
    public final String getBoldPreferenceKey() {
        return "semanticHighlighting." + this.getPreferenceKey() + ".bold";
    }

    @Override
    public String getCategory() {
        return PreferencesMessages.CEditorColoringConfigurationBlock_coloring_category_code;
    }

    @Override
    public final String getColorPreferenceKey() {
        return "semanticHighlighting." + this.getPreferenceKey() + ".color";
    }

    protected abstract RGB getDefaultTextColor();

    @Override
    public abstract String getDisplayName();

    @Override
    public final String getEnabledPreferenceKey() {
        return "semanticHighlighting." + this.getPreferenceKey() + ".enabled";
    }

    @Override
    public final String getId() {
        return this.getPreferenceKey();
    }

    @Override
    public final String getItalicPreferenceKey() {
        return "semanticHighlighting." + this.getPreferenceKey() + ".italic";
    }

    protected abstract String getPreferenceKey();

    public final IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    @Override
    public final String getStrikethroughPreferenceKey() {
        return "semanticHighlighting." + this.getPreferenceKey() + ".strikethrough";
    }

    @Override
    public final TextAttribute getTextAttribute() {
        TextAttribute textAttribute = this.fTextAttribute.get();
        if (textAttribute == null) {
            textAttribute = this.createInitialTextAttribute();
            this.fTextAttribute.compareAndSet(null, textAttribute);
            return this.fTextAttribute.get();
        }
        return textAttribute;
    }

    @Override
    public final String getUnderlinePreferenceKey() {
        return "semanticHighlighting." + this.getPreferenceKey() + ".underline";
    }

    @Override
    public final boolean isEnabled() {
        return this.fPreferenceStore.getBoolean(this.getEnabledPreferenceKey());
    }

    @Override
    public boolean isStrikethroughByDefault() {
        return false;
    }

    @Override
    public boolean isUnderlineByDefault() {
        return false;
    }

    private void removeColor(String colorKey) {
        this.fColorManager.unbindColor(colorKey);
    }

    @Override
    public RGB getDefaultColor() {
        return this.getDefaultTextColor();
    }

    @Override
    public boolean requiresImplicitNames() {
        return false;
    }

    private void setTextAttribute(TextAttribute textAttribute) {
        this.fTextAttribute.set(textAttribute);
    }

    @Override
    public final boolean styleUpdated(PropertyChangeEvent event) {
        if (this.getColorPreferenceKey().equals(event.getProperty())) {
            this.adaptToTextForegroundChange(event);
        } else if (this.getBoldPreferenceKey().equals(event.getProperty())) {
            this.adaptToTextStyleChange(event, 1);
        } else if (this.getItalicPreferenceKey().equals(event.getProperty())) {
            this.adaptToTextStyleChange(event, 2);
        } else if (this.getStrikethroughPreferenceKey().equals(event.getProperty())) {
            this.adaptToTextStyleChange(event, 0x20000000);
        } else if (this.getUnderlinePreferenceKey().equals(event.getProperty())) {
            this.adaptToTextStyleChange(event, 0x40000000);
        } else if (!this.getEnabledPreferenceKey().equals(event.getProperty())) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSemanticHighlighting() {
        return true;
    }
}

