/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.typehierarchy.THGraphEdge;
import org.eclipse.cdt.internal.ui.typehierarchy.THGraphNode;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

class THGraph {
    private static final ICElement[] NO_MEMBERS = new ICElement[0];
    private THGraphNode fInputNode = null;
    private HashSet<THGraphNode> fRootNodes = new HashSet();
    private HashSet<THGraphNode> fLeaveNodes = new HashSet();
    private HashMap<ICElement, THGraphNode> fNodes = new HashMap();
    private boolean fFileIsIndexed;

    public THGraphNode getInputNode() {
        return this.fInputNode;
    }

    public THGraphNode getNode(ICElement elem) {
        return this.fNodes.get(elem);
    }

    private THGraphNode addNode(ICElement input) {
        THGraphNode node = this.fNodes.get(input);
        if (node == null) {
            node = new THGraphNode(input);
            this.fNodes.put(input, node);
            this.fRootNodes.add(node);
            this.fLeaveNodes.add(node);
        }
        return node;
    }

    private THGraphEdge addEdge(THGraphNode from, THGraphNode to) {
        if (this.createsLoopOrIsDuplicate(from, to)) {
            return null;
        }
        THGraphEdge edge = new THGraphEdge(from, to);
        from.startEdge(edge);
        to.endEdge(edge);
        this.fRootNodes.remove(to);
        this.fLeaveNodes.remove(from);
        return edge;
    }

    private boolean createsLoopOrIsDuplicate(THGraphNode from, THGraphNode to) {
        if (from == to) {
            return true;
        }
        if (to.getOutgoing().isEmpty() || from.getIncoming().isEmpty()) {
            return false;
        }
        HashSet<THGraphNode> checked = new HashSet<THGraphNode>();
        ArrayList<THGraphNode> stack = new ArrayList<THGraphNode>();
        stack.add(to);
        while (!stack.isEmpty()) {
            THGraphNode node = (THGraphNode)stack.remove(stack.size() - 1);
            List<THGraphEdge> out = node.getOutgoing();
            for (THGraphEdge edge : out) {
                node = edge.getEndNode();
                if (node == from) {
                    return true;
                }
                if (!checked.add(node)) continue;
                stack.add(node);
            }
        }
        List<THGraphEdge> out = from.getOutgoing();
        for (THGraphEdge edge : out) {
            if (edge.getEndNode() != to) continue;
            return true;
        }
        return false;
    }

    public Collection<THGraphNode> getRootNodes() {
        return this.fRootNodes;
    }

    public Collection<THGraphNode> getLeaveNodes() {
        return this.fLeaveNodes;
    }

    public void defineInputNode(IIndex index, ICElement input) {
        if (input != null) {
            try {
                if (IndexUI.isIndexed(index, input)) {
                    this.fFileIsIndexed = true;
                    input = IndexUI.attemptConvertionToHandle(index, input);
                    this.fInputNode = this.addNode(input);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
    }

    public void addSuperClasses(IIndex index, IProgressMonitor monitor) {
        if (this.fInputNode == null) {
            return;
        }
        HashSet<Object> handled = new HashSet<Object>();
        ArrayList<Object> stack = new ArrayList<Object>();
        stack.add(this.fInputNode.getElement());
        handled.add(this.fInputNode.getElement());
        while (!stack.isEmpty()) {
            if (monitor.isCanceled()) {
                return;
            }
            ICElement elem = (ICElement)stack.remove(stack.size() - 1);
            THGraphNode graphNode = this.addNode(elem);
            try {
                IBinding basecl;
                ICElementHandle[] baseElems;
                IType type;
                ICPPClassType ct;
                IIndexBinding binding = IndexUI.elementToBinding(index, elem);
                if (binding != null) {
                    this.addMembers(index, graphNode, (IBinding)binding);
                }
                if (binding instanceof ICPPClassType) {
                    ICPPBase[] bases;
                    ct = (ICPPClassType)binding;
                    ICPPBase[] iCPPBaseArray = bases = ct.getBases();
                    int n = bases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPBase base = iCPPBaseArray[n2];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        IType baseType = base.getBaseClassType();
                        if (baseType instanceof IBinding) {
                            ICElementHandle[] baseElems2;
                            IBinding baseBinding = (IBinding)baseType;
                            ICElementHandle[] iCElementHandleArray = baseElems2 = IndexUI.findRepresentative(index, baseBinding);
                            int n3 = baseElems2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ICElementHandle baseElem = iCElementHandleArray[n4];
                                THGraphNode baseGraphNode = this.addNode((ICElement)baseElem);
                                this.addMembers(index, baseGraphNode, baseBinding);
                                this.addEdge(graphNode, baseGraphNode);
                                if (handled.add(baseElem)) {
                                    stack.add(baseElem);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    continue;
                }
                if (!(binding instanceof ITypedef) || !((type = (ct = (ITypedef)binding).getType()) instanceof IBinding) || (baseElems = IndexUI.findRepresentative(index, basecl = (IBinding)type)).length <= 0) continue;
                ICElementHandle baseElem = baseElems[0];
                THGraphNode baseGraphNode = this.addNode((ICElement)baseElem);
                this.addMembers(index, baseGraphNode, basecl);
                this.addEdge(graphNode, baseGraphNode);
                if (!handled.add(baseElem)) continue;
                stack.add(baseElem);
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
    }

    public void addSubClasses(IIndex index, IProgressMonitor monitor) {
        if (this.fInputNode == null) {
            return;
        }
        HashSet<Object> handled = new HashSet<Object>();
        ArrayList<Object> stack = new ArrayList<Object>();
        ICElement element = this.fInputNode.getElement();
        stack.add(element);
        handled.add(element);
        while (!stack.isEmpty()) {
            if (monitor.isCanceled()) {
                return;
            }
            ICElement elem = (ICElement)stack.remove(stack.size() - 1);
            THGraphNode graphNode = this.addNode(elem);
            try {
                IIndexName[] names;
                IIndexBinding binding = IndexUI.elementToBinding(index, elem);
                if (binding == null) continue;
                IIndexName[] iIndexNameArray = names = index.findNames((IBinding)binding, 6);
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexBinding subClass;
                    ICElementHandle[] subClassElems;
                    IIndexName subClassDef;
                    IIndexName indexName = iIndexNameArray[n2];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (indexName.isBaseSpecifier() && (subClassDef = indexName.getEnclosingDefinition()) != null && (subClassElems = IndexUI.findRepresentative(index, (IBinding)(subClass = index.findBinding((IName)subClassDef)))).length > 0) {
                        ICElementHandle subClassElem = subClassElems[0];
                        THGraphNode subGraphNode = this.addNode((ICElement)subClassElem);
                        this.addMembers(index, subGraphNode, (IBinding)subClass);
                        this.addEdge(subGraphNode, graphNode);
                        if (handled.add(subClassElem)) {
                            stack.add(subClassElem);
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
    }

    private void addMembers(IIndex index, THGraphNode graphNode, IBinding binding) throws CoreException {
        if (graphNode.getMembers(false) == null) {
            ArrayList<ICElement> memberList = new ArrayList<ICElement>();
            if (binding instanceof ICPPClassType) {
                ICPPClassType ct = (ICPPClassType)binding;
                ICPPField[] members = ct.getDeclaredFields();
                this.addMemberElements(index, (IBinding[])members, memberList);
                members = ct.getDeclaredMethods();
                this.addMemberElements(index, (IBinding[])members, memberList);
            } else if (binding instanceof ICompositeType) {
                ICompositeType ct = (ICompositeType)binding;
                IField[] members = ct.getFields();
                this.addMemberElements(index, (IBinding[])members, memberList);
            } else if (binding instanceof IEnumeration) {
                IEnumeration ct = (IEnumeration)binding;
                IEnumerator[] members = ct.getEnumerators();
                this.addMemberElements(index, (IBinding[])members, memberList);
            }
            if (memberList.isEmpty()) {
                graphNode.setMembers(NO_MEMBERS);
            } else {
                graphNode.setMembers(memberList.toArray(new ICElement[memberList.size()]));
            }
        }
    }

    private void addMemberElements(IIndex index, IBinding[] members, List<ICElement> memberList) throws CoreException {
        IBinding[] iBindingArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            ICElementHandle[] elems = IndexUI.findRepresentative(index, binding);
            if (elems.length > 0) {
                memberList.add((ICElement)elems[0]);
            }
            ++n2;
        }
    }

    public boolean isTrivial() {
        return this.fNodes.size() < 2;
    }

    public boolean isFileIndexed() {
        return this.fFileIsIndexed;
    }
}

