/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.AbstractConfigurableHighlighting;
import org.eclipse.cdt.ui.text.IHighlightConfiguration;
import org.eclipse.cdt.ui.text.ISemanticHighlighting;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class SemanticHighlightingRegistry {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_LANGUAGE_ID = "languageId";
    private static final String ELEMENT_HIGHLIGHT_CONFIGURATION = "highlightConfiguration";
    private static final String ELEMENT_HIGHLIGHTING = "highlighting";
    public static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.semanticHighlighting";
    private ISemanticHighlighting[] allHighlighters;
    private IHighlightConfiguration[] configurableHighlighters;
    private Map<ILanguage, ISemanticHighlighting[]> table;

    private void createConfigurable(IConfigurationElement element, Collection<IHighlightConfiguration> configurables) throws CoreException {
        IHighlightConfiguration highlighting = (IHighlightConfiguration)element.createExecutableExtension(ATTR_CLASS);
        configurables.add(highlighting);
    }

    private void createHighlighting(IConfigurationElement element, Map<ILanguage, Collection<ISemanticHighlighting>> perLanguage, Collection<ISemanticHighlighting> allLanguages) throws CoreException {
        Collection<ISemanticHighlighting> collection;
        String languageId = element.getAttribute(ATTR_LANGUAGE_ID);
        if (languageId != null) {
            ILanguage language = this.getLanguage(element, languageId);
            collection = perLanguage.get(language);
            if (collection == null) {
                collection = new LinkedList<ISemanticHighlighting>();
                perLanguage.put(language, collection);
            }
        } else {
            collection = allLanguages;
        }
        ISemanticHighlighting highlighting = (ISemanticHighlighting)element.createExecutableExtension(ATTR_CLASS);
        collection.add(highlighting);
    }

    private void fillMap(Map<ILanguage, Collection<ISemanticHighlighting>> cache, Collection<ISemanticHighlighting> defaults, Collection<IHighlightConfiguration> configurables) {
        this.table = new HashMap<ILanguage, ISemanticHighlighting[]>(cache.size() + 1);
        Set<Map.Entry<ILanguage, Collection<ISemanticHighlighting>>> set = cache.entrySet();
        List<AbstractConfigurableHighlighting> builtins = Arrays.asList(SemanticHighlightings.getBuiltinSemanticHighlightings());
        HashSet<ISemanticHighlighting> all = new HashSet<ISemanticHighlighting>();
        int defaultsCount = defaults.size();
        int builtinsCount = builtins.size();
        for (Map.Entry<ILanguage, Collection<ISemanticHighlighting>> entry : set) {
            Collection<ISemanticHighlighting> collection = entry.getValue();
            ArrayList<ISemanticHighlighting> list = new ArrayList<ISemanticHighlighting>(collection.size() + defaultsCount + builtinsCount);
            list.addAll(collection);
            list.addAll(defaults);
            list.addAll(builtins);
            ISemanticHighlighting[] array = list.toArray(new ISemanticHighlighting[list.size()]);
            this.table.put(entry.getKey(), array);
            all.addAll(collection);
        }
        ArrayList<ISemanticHighlighting> list = new ArrayList<ISemanticHighlighting>(defaultsCount + builtinsCount);
        list.addAll(defaults);
        list.addAll(builtins);
        ISemanticHighlighting[] highlightings = list.toArray(new ISemanticHighlighting[list.size()]);
        this.table.put(null, highlightings);
        all.addAll(defaults);
        all.addAll(builtins);
        this.allHighlighters = all.toArray(new ISemanticHighlighting[all.size()]);
        for (ISemanticHighlighting highlighting : all) {
            if (!(highlighting instanceof IHighlightConfiguration)) continue;
            configurables.add((IHighlightConfiguration)((Object)highlighting));
        }
        this.configurableHighlighters = configurables.toArray(new IHighlightConfiguration[configurables.size()]);
    }

    public ISemanticHighlighting[] getAllHighlighters() {
        if (this.allHighlighters == null) {
            this.readExtensions();
        }
        return this.allHighlighters;
    }

    public IHighlightConfiguration[] getConfigurableHighlighters() {
        if (this.configurableHighlighters == null) {
            this.readExtensions();
        }
        return this.configurableHighlighters;
    }

    public ISemanticHighlighting[] getHighlighters(ILanguage language) {
        if (this.table == null) {
            this.readExtensions();
        }
        if (language != null && this.table.containsKey(language.getId())) {
            return this.table.get(language);
        }
        return this.table.get(null);
    }

    private ILanguage getLanguage(IConfigurationElement element, String languageId) throws CoreException {
        ILanguage language = LanguageManager.getInstance().getLanguage(languageId);
        if (language == null) {
            throw new CoreException((IStatus)new Status(4, String.format("Language %s not found when reading extensions from plugin %s", languageId, element.getContributor().getName()), element.getContributor().getName()));
        }
        return language;
    }

    private synchronized void readExtensions() {
        if (this.table == null) {
            IConfigurationElement[] elements;
            HashMap<ILanguage, Collection<ISemanticHighlighting>> cache = new HashMap<ILanguage, Collection<ISemanticHighlighting>>();
            LinkedList<ISemanticHighlighting> highlightings = new LinkedList<ISemanticHighlighting>();
            LinkedList<IHighlightConfiguration> configurables = new LinkedList<IHighlightConfiguration>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    if (ELEMENT_HIGHLIGHTING.equals(element.getName())) {
                        this.createHighlighting(element, cache, highlightings);
                    } else if (ELEMENT_HIGHLIGHT_CONFIGURATION.equals(element.getName())) {
                        this.createConfigurable(element, configurables);
                    }
                }
                catch (Exception e) {
                    String pluginName = element.getContributor().getName();
                    CUIPlugin.log(String.format("Failed to read extension from plugin %s", pluginName), e);
                }
                ++n2;
            }
            this.fillMap(cache, highlightings, configurables);
        }
    }
}

