/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.IMIBackend2;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.osgi.framework.BundleContext;

public class GDBBackend
extends AbstractDsfService
implements IGDBBackend,
IMIBackend2 {
    private final ILaunchConfiguration fLaunchConfiguration;
    private IPath fProgramPath;
    private IPath fGDBWorkingDirectory;
    private String fGDBInitFile;
    private List<String> fSharedLibPaths;
    private String fProgramArguments;
    private Properties fEnvVariables;
    private SessionType fSessionType;
    private Boolean fAttach;
    private IMIBackend.State fBackendState = IMIBackend.State.NOT_INITIALIZED;
    private final String fBackendId = "gdb[" + Integer.toString(fgInstanceCounter++) + "]";
    private static int fgInstanceCounter = 0;
    private MonitorJob fMonitorJob;
    private Process fProcess;
    private int fGDBExitValue;
    private int fGDBLaunchTimeout = 30;
    private MonitorInterruptJob fInterruptFailedJob;

    public GDBBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.fLaunchConfiguration = lc;
        try {
            ICProject cproject = LaunchUtils.getCProject(lc);
            this.fProgramPath = LaunchUtils.verifyProgramPath(lc, cproject);
        }
        catch (CoreException coreException) {
            this.fProgramPath = new Path("");
        }
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBBackend.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                GDBBackend.super.shutdown(requestMonitor);
            }
        }){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    protected IPath getGDBPath() {
        return LaunchUtils.getGDBPath(this.fLaunchConfiguration);
    }

    protected String getGDBCommandLine() {
        StringBuffer gdbCommandLine = new StringBuffer(this.getGDBPath().toOSString());
        gdbCommandLine.append(" --interpreter");
        gdbCommandLine.append(" mi2");
        gdbCommandLine.append(" --nx");
        return gdbCommandLine.toString();
    }

    @Override
    public String getGDBInitFile() throws CoreException {
        if (this.fGDBInitFile == null) {
            String defaultGdbInit = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbInit", ".gdbinit", null);
            this.fGDBInitFile = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", defaultGdbInit);
        }
        return this.fGDBInitFile;
    }

    @Override
    public IPath getGDBWorkingDirectory() throws CoreException {
        if (this.fGDBWorkingDirectory == null) {
            ICProject cp;
            String expandedLocation;
            Object path = null;
            String location = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            if (location != null && (expandedLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(location)).length() > 0) {
                path = new Path(expandedLocation);
            }
            if (path != null) {
                if (path.isAbsolute()) {
                    File dir = new File(path.toPortableString());
                    if (!dir.isDirectory()) {
                        path = null;
                    }
                } else {
                    IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    path = res instanceof IContainer && res.exists() ? res.getLocation() : null;
                }
            }
            if (path == null && (cp = LaunchUtils.getCProject(this.fLaunchConfiguration)) != null) {
                IProject p = cp.getProject();
                path = p.getLocation();
            }
            this.fGDBWorkingDirectory = path;
        }
        return this.fGDBWorkingDirectory;
    }

    @Override
    public String getProgramArguments() throws CoreException {
        if (this.fProgramArguments == null) {
            this.fProgramArguments = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
            if (this.fProgramArguments != null) {
                this.fProgramArguments = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fProgramArguments);
            }
        }
        return this.fProgramArguments;
    }

    @Override
    public IPath getProgramPath() {
        return this.fProgramPath;
    }

    @Override
    public List<String> getSharedLibraryPaths() throws CoreException {
        if (this.fSharedLibPaths == null) {
            this.fSharedLibPaths = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", new ArrayList(0));
        }
        return this.fSharedLibPaths;
    }

    @Override
    public Properties getEnvironmentVariables() throws CoreException {
        if (this.fEnvVariables == null) {
            String[] properties;
            this.fEnvVariables = new Properties();
            boolean append = this.fLaunchConfiguration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            if (append) {
                ILaunchConfigurationWorkingCopy wc = this.fLaunchConfiguration.copy("");
                wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                properties = DebugPlugin.getDefault().getLaunchManager().getEnvironment((ILaunchConfiguration)wc);
            } else {
                properties = DebugPlugin.getDefault().getLaunchManager().getEnvironment(this.fLaunchConfiguration);
            }
            if (properties == null) {
                properties = new String[]{};
            }
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                int idx = property.indexOf(61);
                if (idx != -1) {
                    String key = property.substring(0, idx);
                    String value = property.substring(idx + 1);
                    this.fEnvVariables.setProperty(key, value);
                } else {
                    this.fEnvVariables.setProperty(property, "");
                }
                ++n2;
            }
        }
        return this.fEnvVariables;
    }

    @Override
    public boolean getClearEnvironment() throws CoreException {
        return !this.fLaunchConfiguration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
    }

    @Override
    public boolean getUpdateThreadListOnSuspend() throws CoreException {
        return this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }

    protected Process launchGDBProcess(String commandLine) throws CoreException {
        Process proc = null;
        try {
            proc = ProcessFactory.getFactory().exec(commandLine, LaunchUtils.getLaunchEnvironment(this.fLaunchConfiguration));
        }
        catch (IOException e) {
            String message = "Error while launching command " + commandLine;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, message, (Throwable)e));
        }
        return proc;
    }

    public Process getProcess() {
        return this.fProcess;
    }

    @Override
    public OutputStream getMIOutputStream() {
        return this.fProcess.getOutputStream();
    }

    @Override
    public InputStream getMIInputStream() {
        return this.fProcess.getInputStream();
    }

    @Override
    public InputStream getMIErrorStream() {
        return this.fProcess.getErrorStream();
    }

    @Override
    public String getId() {
        return this.fBackendId;
    }

    @Override
    public void interrupt() {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            if (this.getSessionType() == SessionType.REMOTE) {
                gdbSpawner.interrupt();
            } else {
                gdbSpawner.interruptCTRLC();
            }
        }
    }

    @Override
    public void interruptAndWait(int timeout, RequestMonitor rm) {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            if (this.getSessionType() == SessionType.REMOTE) {
                gdbSpawner.interrupt();
            } else {
                gdbSpawner.interruptCTRLC();
            }
            this.fInterruptFailedJob = new MonitorInterruptJob(timeout, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot interrupt.", null));
            rm.done();
        }
    }

    @Override
    public void interruptInferiorAndWait(long pid, int timeout, RequestMonitor rm) {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            gdbSpawner.raise((int)pid, gdbSpawner.INT);
            this.fInterruptFailedJob = new MonitorInterruptJob(timeout, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot interrupt.", null));
            rm.done();
        }
    }

    @Override
    public void destroy() {
        if (this.getState() == IMIBackend.State.STARTED) {
            this.fProcess.destroy();
        }
    }

    @Override
    public IMIBackend.State getState() {
        return this.fBackendState;
    }

    @Override
    public int getExitCode() {
        return this.fGDBExitValue;
    }

    @Override
    public SessionType getSessionType() {
        if (this.fSessionType == null) {
            this.fSessionType = LaunchUtils.getSessionType(this.fLaunchConfiguration);
        }
        return this.fSessionType;
    }

    @Override
    public boolean getIsAttachSession() {
        if (this.fAttach == null) {
            this.fAttach = LaunchUtils.getIsAttach(this.fLaunchConfiguration);
        }
        return this.fAttach;
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        if (this.fInterruptFailedJob != null) {
            if (this.fInterruptFailedJob.cancel()) {
                this.fInterruptFailedJob.getRequestMonitor().done();
            }
            this.fInterruptFailedJob = null;
        }
    }

    protected void waitForGdbToStart() throws IOException {
        String line;
        InputStreamReader r = new InputStreamReader(this.getMIInputStream());
        BufferedReader reader = new BufferedReader(r);
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).endsWith("(gdb)")) break;
        }
    }

    protected class GDBProcessStep
    extends GDBControl.InitializationShutdownStep {
        GDBProcessStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(final RequestMonitor requestMonitor) {
            class GDBLaunchMonitor {
                boolean fLaunched = false;
                boolean fTimedOut = false;

                GDBLaunchMonitor() {
                }
            }
            final GDBLaunchMonitor fGDBLaunchMonitor = new GDBLaunchMonitor();
            final RequestMonitor gdbLaunchRequestMonitor = new RequestMonitor((Executor)GDBBackend.this.getExecutor(), requestMonitor){
                {
                    super($anonymous0, $anonymous1);
                }

                protected void handleCompleted() {
                    if (!fGDBLaunchMonitor.fTimedOut) {
                        fGDBLaunchMonitor.fLaunched = true;
                        if (!this.isSuccess()) {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                }
            };
            final Job startGdbJob = new Job("Start GDB Process Job"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (gdbLaunchRequestMonitor.isCanceled()) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.cdt.dsf.gdb", -1, "Canceled starting GDB", null));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    String commandLine = GDBBackend.this.getGDBCommandLine();
                    try {
                        GDBBackend.this.fProcess = GDBBackend.this.launchGDBProcess(commandLine);
                        GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                GDBBackend.this.fBackendState = IMIBackend.State.STARTED;
                            }
                        });
                    }
                    catch (CoreException e) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, e.getMessage(), (Throwable)e));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        GDBBackend.this.waitForGdbToStart();
                    }
                    catch (IOException e) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Error reading GDB STDOUT", (Throwable)e));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    gdbLaunchRequestMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            startGdbJob.schedule();
            GDBBackend.this.getExecutor().schedule(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (!fGDBLaunchMonitor.fLaunched) {
                        fGDBLaunchMonitor.fTimedOut = true;
                        Thread jobThread = startGdbJob.getThread();
                        if (jobThread != null) {
                            jobThread.interrupt();
                        }
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5010, "Timed out trying to launch GDB.", null));
                        requestMonitor.done();
                    }
                }
            }, (long)GDBBackend.this.fGDBLaunchTimeout, TimeUnit.SECONDS);
        }

        @Override
        protected void shutdown(final RequestMonitor requestMonitor) {
            if (GDBBackend.this.getState() != IMIBackend.State.STARTED) {
                requestMonitor.done();
                return;
            }
            new Job("Terminating GDB process."){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                GDBBackend.this.destroy();
                                if (((GDBBackend)((GDBProcessStep)(this).GDBProcessStep.this).GDBBackend.this).fMonitorJob.fMonitorExited) {
                                    GDBBackend.this.fBackendState = IMIBackend.State.TERMINATED;
                                    GDBBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GDBBackend.this.getSession().getId(), GDBBackend.this.getId(), IMIBackend.State.TERMINATED), GDBBackend.this.getProperties());
                                }
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                    int attempts = 0;
                    while (attempts < 10) {
                        try {
                            GDBBackend.this.fGDBExitValue = GDBBackend.this.fProcess.exitValue();
                            requestMonitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++attempts;
                        }
                    }
                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "GDB terminate failed", null));
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected class MonitorInterruptJob
    extends Job {
        private static final int TIMEOUT_DEFAULT_VALUE = 5000;
        private final RequestMonitor fRequestMonitor;

        public MonitorInterruptJob(int timeout, RequestMonitor rm) {
            super("Interrupt monitor job.");
            this.setSystem(true);
            this.fRequestMonitor = rm;
            if (timeout == 0 || timeout <= 0) {
                timeout = 5000;
            }
            this.schedule(timeout);
        }

        protected IStatus run(IProgressMonitor monitor) {
            GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    GDBBackend.this.fInterruptFailedJob = null;
                    MonitorInterruptJob.this.fRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Interrupt failed.", null));
                    MonitorInterruptJob.this.fRequestMonitor.done();
                }
            });
            return Status.OK_STATUS;
        }

        public RequestMonitor getRequestMonitor() {
            return this.fRequestMonitor;
        }
    }

    private class MonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fMonProcess;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fMonProcess;
            synchronized (process) {
                GDBBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                try {
                    this.fMonProcess.waitFor();
                    GDBBackend.this.fGDBExitValue = this.fMonProcess.exitValue();
                    GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            GDBBackend.this.destroy();
                            GDBBackend.this.fBackendState = IMIBackend.State.TERMINATED;
                            GDBBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GDBBackend.this.getSession().getId(), GDBBackend.this.getId(), IMIBackend.State.TERMINATED), GDBBackend.this.getProperties());
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                this.fMonitorExited = true;
            }
            return Status.OK_STATUS;
        }

        MonitorJob(Process process, DsfRunnable monitorStarted) {
            super("GDB process monitor job.");
            this.fMonitorExited = false;
            this.fMonProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fMonProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    this.getThread().interrupt();
                }
            }
        }
    }

    protected class MonitorJobStep
    extends GDBControl.InitializationShutdownStep {
        MonitorJobStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(final RequestMonitor requestMonitor) {
            GDBBackend.this.fMonitorJob = new MonitorJob(GDBBackend.this.fProcess, new DsfRunnable(){

                public void run() {
                    requestMonitor.done();
                }
            });
            GDBBackend.this.fMonitorJob.schedule();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            if (GDBBackend.this.fMonitorJob != null) {
                GDBBackend.this.fMonitorJob.kill();
            }
            requestMonitor.done();
        }
    }

    protected class RegisterStep
    extends GDBControl.InitializationShutdownStep {
        RegisterStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            GDBBackend.this.register(new String[]{IMIBackend.class.getName(), IMIBackend2.class.getName(), IGDBBackend.class.getName()}, new Hashtable());
            GDBBackend.this.getSession().addServiceEventListener((Object)GDBBackend.this, null);
            GDBBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GDBBackend.this.getSession().getId(), GDBBackend.this.getId(), IMIBackend.State.STARTED), GDBBackend.this.getProperties());
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            GDBBackend.this.unregister();
            GDBBackend.this.getSession().removeServiceEventListener((Object)GDBBackend.this);
            requestMonitor.done();
        }
    }
}

