/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.properties;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.rdt.sync.core.services.SynchronizeServiceRegistry;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;

public final class RemoteTarget
implements Comparable<RemoteTarget> {
    private static final String DEFAULT_PROJECT_LOCATION = "default_sync_project_location";
    private static final String GIT_SYNC_ID = "org.eclipse.ptp.rdt.sync.git.core.synchronizeService";
    private static final String LOCAL_CONNECTION = "Local";
    private static final String LOCAL_SYSTEM = "Local System";
    private static Map<Object, RemoteTarget> localtargets = new WeakHashMap<Object, RemoteTarget>();
    private static final String RSE_PTP_INTEGRATION = "org.eclipse.ptp.remote.RSERemoteServices";
    private final ITargetContainer container;
    private Cpu cpu = Cpu.Native;
    private final String name;
    private final PropertyChangeSupport pcv = new PropertyChangeSupport(this);
    private String projectLocation;

    public static RemoteTarget forConfig(IProject project, ITargetContainer container, SyncConfig config) {
        if (SyncConfigManager.isLocal((SyncConfig)config)) {
            return RemoteTarget.localTarget(container, project);
        }
        if (RSE_PTP_INTEGRATION.equals(config.getRemoteServicesId())) {
            RemoteTarget target = new RemoteTarget(container, config.getConnectionName());
            target.setProjectLocation(config.getLocation(project));
            target.setCpu(Cpu.getRemoteTargetCpu((SyncConfig)config));
            return target;
        }
        return null;
    }

    public static RemoteTarget forConnection(ITargetContainer container, String projectName, IRemoteConnection selected, IProject project) {
        if (selected == null || selected.getName().equals(LOCAL_CONNECTION)) {
            return RemoteTarget.localTarget(container, project);
        }
        RemoteTarget target = new RemoteTarget(container, selected.getName());
        if (!CoreUtil.isNullOrEmpty((String)projectName)) {
            target.setProjectLocation(RemoteTarget.getDefaultProjectLocation(selected, projectName));
        }
        target.setCpu(Cpu.fromName((String)selected.getProperty(Cpu.class.getName(), null)));
        return target;
    }

    private static String getDefaultProjectLocation(IRemoteConnection selected, String projectName) {
        String property = selected.getProperty(DEFAULT_PROJECT_LOCATION, null);
        if (property != null) {
            return new Path(property).append(projectName).toOSString();
        }
        return null;
    }

    private static synchronized RemoteTarget localTarget(ITargetContainer container, IProject project) {
        if (!localtargets.containsKey(container)) {
            RemoteTarget target = new RemoteTarget(container);
            target.setCpu(Cpu.getLocalTargetCpu((IProject)project));
            localtargets.put(container, target);
        }
        return localtargets.get(container);
    }

    private RemoteTarget(ITargetContainer container) {
        this(container, LOCAL_SYSTEM);
    }

    private RemoteTarget(ITargetContainer container, String name) {
        this.container = container;
        this.name = name;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcv.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcv.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public int compareTo(RemoteTarget o) {
        if (o == null) {
            return 1;
        }
        if (this == o || this.equals(o)) {
            return 0;
        }
        if (this.isLocal()) {
            return -1;
        }
        if (o.isLocal()) {
            return 1;
        }
        if (this.getName() == null) {
            return -1;
        }
        if (o.getName() == null) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public SyncConfig createConfig(IProject project) throws CoreException {
        String connectionName;
        String service;
        if (this.isLocal()) {
            service = "org.eclipse.ptp.remote.LocalServices";
            connectionName = LOCAL_CONNECTION;
        } else {
            service = RSE_PTP_INTEGRATION;
            connectionName = this.getName();
        }
        SyncConfig config = SyncConfigManager.newConfig((String)connectionName, (String)GIT_SYNC_ID, (String)service, (String)connectionName, (String)this.getProjectLocation());
        config.setProperty(Cpu.class.getName(), this.getCpu().name());
        if (!RemoteSyncNature.hasNature((IProject)project)) {
            ISynchronizeService syncService = SynchronizeServiceRegistry.getSynchronizeServiceDescriptor((String)GIT_SYNC_ID).getService();
            RemoteSyncNature.addNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
            SyncConfigManager.addConfig((IProject)project, (SyncConfig)config);
            SyncConfigManager.setActive((IProject)project, (SyncConfig)config);
            syncService.setSyncFileFilter(project, (AbstractSyncFileFilter)SyncManager.getDefaultFileFilter());
            SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.ACTIVE);
        }
        if (!this.isLocal()) {
            config.setSyncOnPreBuild(true);
            config.setSyncOnPostBuild(true);
            this.saveDefaultLocation();
        }
        return config;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteTarget)) {
            return false;
        }
        return CoreUtil.equals((Object)((RemoteTarget)obj).getName(), (Object)this.getName());
    }

    public void fill(SyncConfig config) {
        config.setLocation(this.getProjectLocation());
        this.getCpu().setCpu(config);
        if (!this.isLocal()) {
            IRemoteConnection connection = IRemoteConnectionsService.GetConnection.getConnection((String)config.getConnectionName(), (IProgressMonitor)new NullProgressMonitor());
            connection.setProperty(Cpu.class.getName(), (Object)this.getCpu().name());
            Path path = new Path(this.getProjectLocation());
            if (path.segmentCount() > 1) {
                connection.setProperty(DEFAULT_PROJECT_LOCATION, (Object)path.removeLastSegments(1).toOSString());
            }
        }
    }

    public String getConnectionName() {
        return this.getName();
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode() * 31;
    }

    public boolean isLocal() {
        return LOCAL_SYSTEM.equals(this.name);
    }

    public boolean isSameConfig(SyncConfig config) {
        return this.isLocal() && SyncConfigManager.isLocal((SyncConfig)config) || config.getConnectionName().equals(this.getName()) && config.getRemoteServicesId().equals(RSE_PTP_INTEGRATION);
    }

    public void remove() {
        this.container.remove(this);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcv.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcv.removePropertyChangeListener(propertyName, listener);
    }

    public boolean sameConnection(IRemoteConnection element) {
        return this.isLocal() && LOCAL_CONNECTION.equals(element.getName()) || CoreUtil.equals((Object)element.getName(), (Object)this.getName());
    }

    private void saveDefaultLocation() throws CoreException {
        IRemoteConnection connection = IRemoteConnectionsService.GetConnection.getConnection((String)this.getName(), null);
        connection.setProperty(DEFAULT_PROJECT_LOCATION, (Object)new Path(this.getProjectLocation()).removeLastSegments(1).toOSString());
    }

    public void setCpu(Cpu cpu) {
        Cpu old = this.cpu;
        this.cpu = cpu;
        this.pcv.firePropertyChange("cpu", old, cpu);
    }

    public void setProjectLocation(String projectLocation) {
        String oldLocation = this.projectLocation;
        this.projectLocation = projectLocation;
        this.pcv.firePropertyChange("projectLocation", oldLocation, projectLocation);
    }

    public static interface ITargetContainer {
        public void remove(RemoteTarget var1);
    }
}

