/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import com.jcraft.jsch.ChannelExec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.internal.remote.rse.core.RSEAdapterCorePlugin;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;

public final class RSESSHProcess
extends AbstractRemoteProcess {
    private final ChannelExec channel;
    private final InputStream stderr;
    private final InputStream stdout;
    private final OutputStream stdin;

    public RSESSHProcess(ChannelExec channel) throws IOException {
        this.channel = channel;
        this.stdout = channel.getInputStream();
        this.stderr = channel.getErrStream();
        this.stdin = channel.getOutputStream();
    }

    public void destroy() {
        this.channel.disconnect();
    }

    public int exitValue() {
        return this.channel.getExitStatus();
    }

    public InputStream getErrorStream() {
        return this.stderr;
    }

    public InputStream getInputStream() {
        return this.stdout;
    }

    public OutputStream getOutputStream() {
        return this.stdin;
    }

    public int waitFor() throws InterruptedException {
        while (this.isCompleted()) {
            Thread.sleep(20L);
        }
        return this.exitValue();
    }

    public boolean isCompleted() {
        try {
            return this.stdout.available() == 0 && this.stderr.available() == 0 && this.channel.isConnected();
        }
        catch (IOException e) {
            RSEAdapterCorePlugin.log(e);
            return true;
        }
    }
}

