/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnection;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;

public class RSEConnectionManager
implements IRemoteConnectionManager {
    private final ISystemRegistry fRegistry;
    private final IRemoteServices fRemoteServices;
    private final Map<String, RSEConnection> fConnections = new HashMap<String, RSEConnection>();

    public RSEConnectionManager(ISystemRegistry registry, IRemoteServices services) {
        this.fRegistry = registry;
        this.fRemoteServices = services;
    }

    public IRemoteConnection getConnection(String name) {
        this.refreshConnections();
        if (name != null) {
            IRemoteConnection connection = this.fConnections.get(name);
            if (connection == null) {
                connection = this.fConnections.get(name.toLowerCase());
            }
            if (connection == null) {
                connection = this.fConnections.get(name.toUpperCase());
            }
            return connection;
        }
        return null;
    }

    public IRemoteConnection getConnection(URI uri) {
        String name = uri.getQuery();
        if (name == null) {
            name = uri.getHost();
        }
        return this.getConnection(name);
    }

    public IRemoteConnection[] getConnections() {
        this.refreshConnections();
        return this.fConnections.values().toArray(new IRemoteConnection[this.fConnections.size()]);
    }

    public IRemoteConnection newConnection(String name) throws RemoteConnectionException {
        return null;
    }

    public void refreshConnections() {
        IHost[] hosts;
        HashMap<String, RSEConnection> newConns = new HashMap<String, RSEConnection>();
        IHost[] iHostArray = hosts = this.fRegistry.getHostsBySubSystemConfigurationCategory("shells");
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            IHost host = iHostArray[n2];
            RSEConnection conn = this.fConnections.get(host);
            if (conn != null || (conn = new RSEConnection(host, this.fRemoteServices)).initialize()) {
                newConns.put(host.getAliasName(), conn);
            }
            ++n2;
        }
        this.fConnections.clear();
        this.fConnections.putAll(newConns);
    }

    public void removeConnection(IRemoteConnection conn) {
        if (conn instanceof RSEConnection) {
            ((RSEConnection)conn).dispose();
        }
        this.fConnections.remove(conn.getName());
    }
}

