/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFileFactory;
import org.eclipse.birt.core.archive.compound.ArchiveFileV3;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.i18n.CoreMessages;
import org.eclipse.birt.core.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveUtil {
    protected static Logger logger = Logger.getLogger(ArchiveUtil.class.getName());
    public static String UNIX_SEPERATOR = "/";
    static final String READER_COUNT_FILE_NAME = "/.reader.count";
    static final String[] SKIP_FILES = new String[]{"/.reader.count"};

    public static String generateFullPath(String rootPath, String relativePath) {
        relativePath = ArchiveUtil.convertToSystemString(relativePath);
        if (rootPath != null) {
            if (!rootPath.endsWith(File.separator)) {
                rootPath = String.valueOf(rootPath) + File.separator;
            }
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(1);
            }
            return String.valueOf(rootPath) + relativePath;
        }
        return relativePath;
    }

    public static String generateRelativePath(String rootPath, String fullPath) {
        String relativePath = null;
        relativePath = rootPath != null && fullPath.startsWith(rootPath) ? fullPath.substring(rootPath.length()) : fullPath;
        if (!(relativePath = ArchiveUtil.convertToUnixString(relativePath)).startsWith(UNIX_SEPERATOR)) {
            relativePath = String.valueOf(UNIX_SEPERATOR) + relativePath;
        }
        return relativePath;
    }

    private static String convertToUnixString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(File.separator.charAt(0), UNIX_SEPERATOR.charAt(0));
    }

    private static String convertToSystemString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(UNIX_SEPERATOR.charAt(0), File.separator.charAt(0));
    }

    public static synchronized String generateUniqueFileFolderName(String originalName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        StringBuffer folderName = new StringBuffer(originalName);
        folderName.append('_');
        folderName.append(dateTimeString);
        Random generator = new Random();
        File folder = new File(folderName.toString());
        while (folder.exists()) {
            folderName.append(generator.nextInt());
            folder = new File(folderName.toString());
        }
        return folderName.toString();
    }

    public static void createParentFolder(File fd) {
        if (fd != null && fd.getParentFile() != null && !fd.getParentFile().exists()) {
            fd.getParentFile().mkdirs();
        }
    }

    public static void deleteAllFiles(File dirOrFile) {
        if (!dirOrFile.exists()) {
            return;
        }
        if (dirOrFile.isFile()) {
            dirOrFile.delete();
        } else {
            if (dirOrFile.listFiles() != null && dirOrFile.listFiles().length > 0) {
                File[] fileList = dirOrFile.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    ArchiveUtil.deleteAllFiles(fileList[i]);
                    ++i;
                }
            }
            dirOrFile.delete();
        }
    }

    public static void zipFolderToStream(String tempFolderPath, OutputStream ostream) {
        ZipOutputStream zipOutput = new ZipOutputStream(ostream);
        File rootDir = new File(tempFolderPath);
        File[] files = rootDir.listFiles();
        try {
            ArchiveUtil.zipFiles(zipOutput, files, tempFolderPath);
            zipOutput.close();
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    private static void zipFiles(ZipOutputStream zipOut, File[] files, String tempFolderPath) throws FileNotFoundException, IOException {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                File[] dirFiles = file.listFiles();
                ArchiveUtil.zipFiles(zipOut, dirFiles, tempFolderPath);
            } else {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                try {
                    String relativePath = ArchiveUtil.generateRelativePath(tempFolderPath, file.getPath());
                    ZipEntry entry = new ZipEntry(relativePath);
                    try {
                        int len;
                        entry.setTime(file.lastModified());
                        zipOut.putNextEntry(entry);
                        byte[] buf = new byte[5120];
                        while ((len = in.read(buf)) > 0) {
                            zipOut.write(buf, 0, len);
                        }
                    }
                    finally {
                        zipOut.closeEntry();
                    }
                }
                finally {
                    in.close();
                }
            }
            ++i;
        }
    }

    public static void unzipArchive(File zipArchive, String tempFolderPath) {
        try {
            ZipFile zipFile = new ZipFile(zipArchive);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirName = ArchiveUtil.generateFullPath(tempFolderPath, entry.getName());
                    File dir = new File(dirName);
                    dir.mkdirs();
                    continue;
                }
                InputStream in = null;
                try {
                    in = zipFile.getInputStream(entry);
                    File file = new File(ArchiveUtil.generateFullPath(tempFolderPath, entry.getName()));
                    File dir = new File(file.getParent());
                    if (dir.exists()) {
                        assert (dir.isDirectory());
                    } else {
                        dir.mkdirs();
                    }
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buf = new byte[5120];
                    try {
                        int len;
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            zipFile.close();
        }
        catch (ZipException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public static void copy(IArchiveFile inArchive, IArchiveFile outArchive) throws IOException {
        if (inArchive == null || outArchive == null) {
            throw new IOException(CoreMessages.getString("error.NullSource"));
        }
        ArchiveUtil.copy(new ArchiveReader(inArchive), new ArchiveWriter(outArchive));
    }

    public static void copy(IDocArchiveReader reader, IDocArchiveWriter writer) throws IOException {
        List<String> streamList = reader.listAllStreams();
        int i = 0;
        while (i < streamList.size()) {
            String streamPath = streamList.get(i);
            RAInputStream in = reader.getStream(streamPath);
            try {
                RAOutputStream out = writer.createRandomAccessStream(streamPath);
                try {
                    ArchiveUtil.copyStream(in, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
            ++i;
        }
    }

    private static void copyStream(RAInputStream in, RAOutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        int readSize = in.read(buf);
        while (readSize != -1) {
            out.write(buf, 0, readSize);
            readSize = in.read(buf);
        }
    }

    public static void archive(String folder, String file) throws IOException {
        ArchiveUtil.archive(folder, null, file);
    }

    public static void converFolderArchive(String folder, String file) throws IOException {
        FolderArchiveReader reader = null;
        InputStream inputStream = null;
        FilterInputStream dataInput = null;
        try {
            ArchiveUtil.archive(folder, null, file);
            String folderName = new File(folder).getCanonicalPath();
            reader = new FolderArchiveReader(folderName);
            if (reader.exists(".metedata")) {
                inputStream = reader.getInputStream(".metedata");
                dataInput = new DataInputStream(inputStream);
                Map properties = IOUtil.readMap((DataInputStream)dataInput);
                new ArchiveFileFactory();
                ArchiveFileV3 archive = new ArchiveFileV3(file, "rw+");
                if (properties.containsKey("archive.depened-id")) {
                    archive.setDependId(properties.get("archive.depened-id").toString());
                }
                if (properties.containsKey("archive.system-id")) {
                    archive.setDependId(properties.get("archive.system-id").toString());
                }
                archive.removeEntry(".metedata");
                archive.close();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (dataInput != null) {
                dataInput.close();
            }
        }
    }

    public static void archive(String folderName, IStreamSorter sorter, String fileName) throws IOException {
        folderName = new File(folderName).getCanonicalPath();
        FolderArchiveReader reader = new FolderArchiveReader(folderName);
        try {
            reader.open();
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            FileArchiveWriter writer = new FileArchiveWriter(fileName);
            try {
                writer.initialize();
                ArchiveUtil.copy(reader, writer);
            }
            finally {
                writer.finish();
            }
        }
        finally {
            reader.close();
        }
    }

    static boolean needSkip(String file) {
        int i = 0;
        while (i < SKIP_FILES.length) {
            if (SKIP_FILES[i].equals(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void listAllFiles(File dir, ArrayList<? super File> fileList) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    fileList.add(file);
                } else if (file.isDirectory()) {
                    ArchiveUtil.listAllFiles(file, fileList);
                }
                ++i;
            }
        }
    }

    public static void expand(String file, String folder) throws IOException {
        FileArchiveReader reader = new FileArchiveReader(file);
        try {
            reader.open();
            reader.expandFileArchive(folder);
        }
        finally {
            reader.close();
        }
    }

    public static final int bytesToInteger(byte[] b) {
        assert (b.length >= 4);
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + ((b[3] & 0xFF) << 0);
    }

    public static final int bytesToInteger(byte[] b, int off) {
        assert (b.length - off >= 4);
        return ((b[off++] & 0xFF) << 24) + ((b[off++] & 0xFF) << 16) + ((b[off++] & 0xFF) << 8) + ((b[off] & 0xFF) << 0);
    }

    public static final long bytesToLong(byte[] b) {
        assert (b.length >= 8);
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + (((long)b[7] & 0xFFL) << 0);
    }

    public static final long bytesToLong(byte[] b, int off) {
        assert (b.length - off >= 8);
        return (((long)b[off++] & 0xFFL) << 56) + (((long)b[off++] & 0xFFL) << 48) + (((long)b[off++] & 0xFFL) << 40) + (((long)b[off++] & 0xFFL) << 32) + (((long)b[off++] & 0xFFL) << 24) + (((long)b[off++] & 0xFFL) << 16) + (((long)b[off++] & 0xFFL) << 8) + (((long)b[off] & 0xFFL) << 0);
    }

    public static final void integerToBytes(int v, byte[] b) {
        assert (b.length >= 4);
        b[0] = (byte)(v >>> 24 & 0xFF);
        b[1] = (byte)(v >>> 16 & 0xFF);
        b[2] = (byte)(v >>> 8 & 0xFF);
        b[3] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void integerToBytes(int v, byte[] b, int off) {
        assert (b.length - off >= 4);
        b[off++] = (byte)(v >>> 24 & 0xFF);
        b[off++] = (byte)(v >>> 16 & 0xFF);
        b[off++] = (byte)(v >>> 8 & 0xFF);
        b[off] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void longToBytes(long v, byte[] b) {
        assert (b.length >= 8);
        b[0] = (byte)(v >>> 56 & 0xFFL);
        b[1] = (byte)(v >>> 48 & 0xFFL);
        b[2] = (byte)(v >>> 40 & 0xFFL);
        b[3] = (byte)(v >>> 32 & 0xFFL);
        b[4] = (byte)(v >>> 24 & 0xFFL);
        b[5] = (byte)(v >>> 16 & 0xFFL);
        b[6] = (byte)(v >>> 8 & 0xFFL);
        b[7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final void longToBytes(long v, byte[] b, int off) {
        assert (b.length - off >= 8);
        b[off++] = (byte)(v >>> 56 & 0xFFL);
        b[off++] = (byte)(v >>> 48 & 0xFFL);
        b[off++] = (byte)(v >>> 40 & 0xFFL);
        b[off++] = (byte)(v >>> 32 & 0xFFL);
        b[off++] = (byte)(v >>> 24 & 0xFFL);
        b[off++] = (byte)(v >>> 16 & 0xFFL);
        b[off++] = (byte)(v >>> 8 & 0xFFL);
        b[off] = (byte)(v >>> 0 & 0xFFL);
    }

    public static boolean removeFileAndFolder(File file) {
        File[] children;
        assert (file != null);
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                ArchiveUtil.removeFileAndFolder(children[i]);
                ++i;
            }
        }
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }
}

