/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.properties;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.internal.rdt.sync.ui.SynchronizePropertiesRegistry;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.AddSyncConfigWizard;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ManageConfigurationWidget
extends Composite {
    private IProject fProject;
    private final Button fAddButton;
    private final TreeViewer fTreeViewer;
    private final Composite fUserDefinedRegion;
    private final Set<SyncConfig> fConfigs = new TreeSet<SyncConfig>();
    private final Set<SyncConfig> fAddedConfigs = new HashSet<SyncConfig>();
    private final Set<SyncConfig> fRemovedConfigs = new HashSet<SyncConfig>();

    public ManageConfigurationWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Composite main = new Composite((Composite)this, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTreeViewer = new TreeViewer(main, 68354);
        this.fTreeViewer.setContentProvider((IContentProvider)new SyncConfigContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new SyncConfigLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISynchronizeProperties prop;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (prop = SynchronizePropertiesRegistry.getSynchronizePropertiesForProject(ManageConfigurationWidget.this.getProject())) != null) {
                    Object obj;
                    prop.disposePropertiesConfigurationArea();
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof SyncConfig) {
                        prop.createPropertiesConfigurationArea(ManageConfigurationWidget.this.fUserDefinedRegion, (SyncConfig)obj);
                        ManageConfigurationWidget.this.fUserDefinedRegion.layout();
                    }
                }
            }
        });
        Tree tree = this.fTreeViewer.getTree();
        tree.setLinesVisible(false);
        tree.setHeaderVisible(false);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.fAddButton = new Button(main, 0);
        this.fAddButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fAddButton.setText(Messages.ManageConfigurationWidget_Add);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSyncConfigWizard wizard = new AddSyncConfigWizard(ManageConfigurationWidget.this.getProject());
                WizardDialog dialog = new WizardDialog(ManageConfigurationWidget.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    SyncConfig config = wizard.getSyncConfig();
                    ManageConfigurationWidget.this.fAddedConfigs.add(config);
                    ManageConfigurationWidget.this.fConfigs.add(config);
                    ManageConfigurationWidget.this.fTreeViewer.refresh();
                    ISynchronizeProperties prop = SynchronizePropertiesRegistry.getSynchronizePropertiesForProject(ManageConfigurationWidget.this.getProject());
                    if (prop != null) {
                        prop.addConfiguration(config);
                    }
                }
            }
        });
        Button removeButton = new Button(main, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        removeButton.setText(Messages.ManageConfigurationWidget_Remove);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)ManageConfigurationWidget.this.fTreeViewer.getSelection();
                if (ss.size() == ManageConfigurationWidget.this.fConfigs.size()) {
                    MessageDialog.openError((Shell)ManageConfigurationWidget.this.getShell(), (String)Messages.ManageConfigurationWidget_Remove_Configuration, (String)Messages.ManageConfigurationWidget_Must_be_at_least_one);
                } else if (!ss.isEmpty()) {
                    for (Object el : ss) {
                        if (!(el instanceof SyncConfig)) continue;
                        SyncConfig config = (SyncConfig)el;
                        if (SyncConfigManager.isActive((IProject)ManageConfigurationWidget.this.getProject(), (SyncConfig)config)) {
                            MessageDialog.openError((Shell)ManageConfigurationWidget.this.getShell(), (String)Messages.ManageConfigurationWidget_Remove_Configuration, (String)Messages.ManageConfigurationWidget_Cannot_remove_active);
                            continue;
                        }
                        if (ManageConfigurationWidget.this.fAddedConfigs.contains(config)) {
                            ManageConfigurationWidget.this.fAddedConfigs.remove(config);
                        } else {
                            ManageConfigurationWidget.this.fRemovedConfigs.add(config);
                        }
                        ManageConfigurationWidget.this.fConfigs.remove(config);
                    }
                    ManageConfigurationWidget.this.fTreeViewer.refresh();
                }
            }
        });
        Button setActiveButton = new Button(main, 0);
        setActiveButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        setActiveButton.setText(Messages.ManageConfigurationWidget_Set_Active);
        setActiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)ManageConfigurationWidget.this.fTreeViewer.getSelection();
                if (ss.size() > 1) {
                    MessageDialog.openError((Shell)ManageConfigurationWidget.this.getShell(), (String)Messages.ManageConfigurationWidget_Set_Active_Configuration, (String)Messages.ManageConfigurationWidget_Only_one_configuration_active);
                } else if (!ss.isEmpty()) {
                    for (Object el : ss) {
                        if (!(el instanceof SyncConfig)) continue;
                        SyncConfig config = (SyncConfig)el;
                        if (SyncConfigManager.isActive((IProject)ManageConfigurationWidget.this.getProject(), (SyncConfig)config)) continue;
                        SyncConfigManager.setActive((IProject)ManageConfigurationWidget.this.getProject(), (SyncConfig)config);
                    }
                    ManageConfigurationWidget.this.fTreeViewer.refresh();
                }
            }
        });
        Label rule = new Label((Composite)this, 258);
        rule.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fUserDefinedRegion = new Composite((Composite)this, 0);
        this.fUserDefinedRegion.setLayout((Layout)new GridLayout(1, false));
        this.fUserDefinedRegion.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    public void commit() {
        ISynchronizeProperties prop;
        if (!this.fAddedConfigs.isEmpty() || !this.fRemovedConfigs.isEmpty()) {
            SyncConfigManager.updateConfigs((IProject)this.getProject(), (SyncConfig[])this.fAddedConfigs.toArray(new SyncConfig[0]), (SyncConfig[])this.fRemovedConfigs.toArray(new SyncConfig[0]));
        }
        if ((prop = SynchronizePropertiesRegistry.getSynchronizePropertiesForProject(this.getProject())) != null) {
            prop.performApply();
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setDefaults() {
        for (SyncConfig config : this.fAddedConfigs) {
            this.fConfigs.remove(config);
        }
        for (SyncConfig config : this.fRemovedConfigs) {
            this.fConfigs.add(config);
        }
        this.fAddedConfigs.clear();
        this.fRemovedConfigs.clear();
        this.fTreeViewer.refresh();
        ISynchronizeProperties prop = SynchronizePropertiesRegistry.getSynchronizePropertiesForProject(this.getProject());
        if (prop != null) {
            prop.performDefaults();
        }
    }

    public void setProject(IProject project) {
        this.fProject = project;
        SyncConfig[] configs = SyncConfigManager.getConfigs((IProject)project);
        this.fConfigs.addAll(Arrays.asList(configs));
        this.fTreeViewer.setInput(this.fConfigs);
        for (SyncConfig config : this.fConfigs) {
            if (!SyncConfigManager.isActive((IProject)project, (SyncConfig)config)) continue;
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)config));
            break;
        }
    }

    private static class FontStyler
    extends StyledString.Styler {
        private final String fFont;

        public FontStyler(String font) {
            this.fFont = font;
        }

        public void applyStyles(TextStyle textStyle) {
            FontRegistry registry = new FontRegistry();
            textStyle.font = registry.getBold(this.fFont);
        }
    }

    private class SyncConfigContentProvider
    implements ITreeContentProvider {
        private SyncConfigContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SyncConfig) {
                SyncConfig config = (SyncConfig)parentElement;
                Object[] children = new String[]{String.valueOf(Messages.ManageConfigurationWidget_Connection_name) + config.getConnectionName(), String.valueOf(Messages.ManageConfigurationWidget_Project_location) + config.getLocation(), String.valueOf(Messages.ManageConfigurationWidget_Sync_provider) + config.getSyncService().getName()};
                return children;
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return ManageConfigurationWidget.this.fConfigs.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof SyncConfig;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class SyncConfigLabelProvider
    extends StyledCellLabelProvider {
        private SyncConfigLabelProvider() {
        }

        public void update(ViewerCell cell) {
            String str;
            int pos;
            Object element = cell.getElement();
            StyledString styledString = new StyledString();
            if (element instanceof SyncConfig) {
                SyncConfig config = (SyncConfig)element;
                styledString.append(config.getName());
                if (SyncConfigManager.isActive((IProject)ManageConfigurationWidget.this.getProject(), (SyncConfig)config)) {
                    styledString.setStyle(0, styledString.length(), (StyledString.Styler)new FontStyler(Display.getCurrent().getSystemFont().getFontData()[0].getName()));
                }
            } else if (element instanceof String && (pos = (str = (String)element).indexOf(":")) >= 0) {
                styledString = new StyledString();
                styledString.append(str.substring(0, pos + 1), StyledString.DECORATIONS_STYLER);
                styledString.append(str.substring(pos + 1, str.length()));
            }
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            super.update(cell);
        }
    }
}

