/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.core.runtime.CoreException;

class PDOMCVariable
extends PDOMBinding
implements IVariable {
    private static final int TYPE_OFFSET = 28;
    private static final int VALUE_OFFSET = 34;
    private static final int ANNOTATIONS = 40;
    private static final int EXTRA_BITS = 41;
    protected static final int RECORD_SIZE = 43;

    public PDOMCVariable(PDOMLinkage linkage, PDOMNode parent, IVariable variable) throws CoreException {
        super(linkage, parent, variable.getNameCharArray());
        Database db = this.getDB();
        linkage.storeType(this.record + 28L, variable.getType());
        linkage.storeValue(this.record + 34L, variable.getInitialValue());
        db.putByte(this.record + 40L, PDOMCAnnotation.encodeAnnotation(variable));
        db.putShort(this.record + 41L, variable.getExtendedBits());
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IVariable) {
            Database db = this.getDB();
            IVariable var = (IVariable)newBinding;
            linkage.storeType(this.record + 28L, var.getType());
            linkage.storeValue(this.record + 34L, var.getInitialValue());
            db.putByte(this.record + 40L, PDOMCAnnotation.encodeAnnotation(var));
            db.putShort(this.record + 41L, var.getExtendedBits());
        }
    }

    public PDOMCVariable(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    protected int getRecordSize() {
        return 43;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    public IType getType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 28L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public IValue getInitialValue() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 34L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public boolean isStatic() {
        return PDOMCVariable.getBit(this.getByte(this.record + 40L), 4);
    }

    @Override
    public boolean isExtern() {
        return PDOMCVariable.getBit(this.getByte(this.record + 40L), 1);
    }

    @Override
    public boolean isAuto() {
        return PDOMCVariable.getBit(this.getByte(this.record + 40L), 0);
    }

    @Override
    public boolean isRegister() {
        return PDOMCVariable.getBit(this.getByte(this.record + 40L), 3);
    }

    @Override
    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            return CVariableReadWriteFlags.getReadWriteFlags(name);
        }
        return 0;
    }

    @Override
    public short getExtendedBits() {
        try {
            return this.getDB().getShort(this.record + 41L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }
}

