/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class NodeCommentMap {
    protected final Map<IASTNode, List<IASTComment>> leadingMap = new HashMap<IASTNode, List<IASTComment>>();
    protected final Map<IASTNode, List<IASTComment>> trailingMap = new HashMap<IASTNode, List<IASTComment>>();
    protected final Map<IASTNode, List<IASTComment>> freestandingMap = new HashMap<IASTNode, List<IASTComment>>();

    public void addTrailingCommentToNode(IASTNode node, IASTComment comment) {
        List<IASTComment> comments = this.trailingMap.get(node);
        if (comments == null) {
            comments = new ArrayList<IASTComment>();
        }
        comments.add(comment);
        this.trailingMap.put(node, comments);
    }

    public List<IASTComment> getTrailingCommentsForNode(IASTNode node) {
        ArrayList list = this.trailingMap.get(node);
        return list != null ? list : new ArrayList();
    }

    public void addLeadingCommentToNode(IASTNode node, IASTComment comment) {
        List<IASTComment> comments = this.leadingMap.get(node);
        if (comments == null) {
            comments = new ArrayList<IASTComment>();
        }
        comments.add(comment);
        this.leadingMap.put(node, comments);
    }

    public List<IASTComment> getLeadingCommentsForNode(IASTNode node) {
        ArrayList list = this.leadingMap.get(node);
        return list != null ? list : new ArrayList();
    }

    public void addFreestandingCommentToNode(IASTNode node, IASTComment comment) {
        List<IASTComment> comments = this.freestandingMap.get(node);
        if (comments == null) {
            comments = new ArrayList<IASTComment>();
        }
        comments.add(comment);
        this.freestandingMap.put(node, comments);
    }

    public List<IASTComment> getFreestandingCommentsForNode(IASTNode node) {
        ArrayList list = this.freestandingMap.get(node);
        return list != null ? list : new ArrayList();
    }

    public Map<IASTNode, List<IASTComment>> getLeadingMap() {
        return this.leadingMap;
    }

    public Map<IASTNode, List<IASTComment>> getTrailingMap() {
        return this.trailingMap;
    }

    public Map<IASTNode, List<IASTComment>> getFreestandingMap() {
        return this.freestandingMap;
    }

    public List<IASTComment> getAllCommentsForNode(IASTNode node) {
        ArrayList<IASTComment> comment = new ArrayList<IASTComment>();
        comment.addAll(this.getFreestandingCommentsForNode(node));
        comment.addAll(this.getLeadingCommentsForNode(node));
        comment.addAll(this.getTrailingCommentsForNode(node));
        return comment;
    }
}

